/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenAssociateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenID;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenAssociateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenAssociateTransaction> {
    @Nullable
    private AccountId accountId = null;
    private List<TokenId> tokenIds = new ArrayList<TokenId>();

    public TokenAssociateTransaction() {
        this.defaultMaxTransactionFee = new Hbar(5L);
    }

    TokenAssociateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenAssociateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public TokenAssociateTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    public List<TokenId> getTokenIds() {
        return new ArrayList<TokenId>(this.tokenIds);
    }

    public TokenAssociateTransaction setTokenIds(List<TokenId> tokens) {
        Objects.requireNonNull(tokens);
        this.requireNotFrozen();
        this.tokenIds = new ArrayList<TokenId>(tokens);
        return this;
    }

    TokenAssociateTransactionBody.Builder build() {
        TokenAssociateTransactionBody.Builder builder = TokenAssociateTransactionBody.newBuilder();
        if (this.accountId != null) {
            builder.setAccount(this.accountId.toProtobuf());
        }
        for (TokenId token : this.tokenIds) {
            if (token == null) continue;
            builder.addTokens(token.toProtobuf());
        }
        return builder;
    }

    void initFromTransactionBody() {
        TokenAssociateTransactionBody body = this.sourceTransactionBody.getTokenAssociate();
        if (body.hasAccount()) {
            this.accountId = AccountId.fromProtobuf(body.getAccount());
        }
        for (TokenID token : body.getTokensList()) {
            this.tokenIds.add(TokenId.fromProtobuf(token));
        }
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        Objects.requireNonNull(client);
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
        for (TokenId token : this.tokenIds) {
            if (token == null) continue;
            token.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getAssociateTokensMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenAssociate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenAssociate(this.build());
    }
}

