/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenDissociateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenID;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenDissociateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenDissociateTransaction> {
    @Nullable
    private AccountId accountId = null;
    private List<TokenId> tokenIds = new ArrayList<TokenId>();

    public TokenDissociateTransaction() {
        this.defaultMaxTransactionFee = new Hbar(5L);
    }

    TokenDissociateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenDissociateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public TokenDissociateTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    public List<TokenId> getTokenIds() {
        return new ArrayList<TokenId>(this.tokenIds);
    }

    public TokenDissociateTransaction setTokenIds(List<TokenId> tokens) {
        this.requireNotFrozen();
        this.tokenIds = new ArrayList<TokenId>(tokens);
        return this;
    }

    void initFromTransactionBody() {
        TokenDissociateTransactionBody body = this.sourceTransactionBody.getTokenDissociate();
        if (body.hasAccount()) {
            this.accountId = AccountId.fromProtobuf(body.getAccount());
        }
        for (TokenID token : body.getTokensList()) {
            this.tokenIds.add(TokenId.fromProtobuf(token));
        }
    }

    TokenDissociateTransactionBody.Builder build() {
        TokenDissociateTransactionBody.Builder builder = TokenDissociateTransactionBody.newBuilder();
        if (this.accountId != null) {
            builder.setAccount(this.accountId.toProtobuf());
        }
        for (TokenId token : this.tokenIds) {
            if (token == null) continue;
            builder.addTokens(token.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
        for (TokenId token : this.tokenIds) {
            if (token == null) continue;
            token.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getDissociateTokensMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenDissociate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenDissociate(this.build());
    }
}

