/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenSupplyType;
import com.hedera.hashgraph.sdk.TokenType;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.TokenFreezeStatus;
import com.hedera.hashgraph.sdk.proto.TokenGetInfoResponse;
import com.hedera.hashgraph.sdk.proto.TokenInfo;
import com.hedera.hashgraph.sdk.proto.TokenKycStatus;
import com.hedera.hashgraph.sdk.proto.TokenPauseStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class TokenInfo {
    public final TokenId tokenId;
    public final String name;
    public final String symbol;
    public final int decimals;
    public final long totalSupply;
    public final AccountId treasuryAccountId;
    @Nullable
    public final Key adminKey;
    @Nullable
    public final Key kycKey;
    @Nullable
    public final Key freezeKey;
    @Nullable
    public final Key wipeKey;
    @Nullable
    public final Key supplyKey;
    @Nullable
    public final Key feeScheduleKey;
    @Nullable
    public final Boolean defaultFreezeStatus;
    @Nullable
    public final Boolean defaultKycStatus;
    public final boolean isDeleted;
    @Nullable
    public final AccountId autoRenewAccount;
    @Nullable
    public final Duration autoRenewPeriod;
    @Nullable
    public final Instant expirationTime;
    public final String tokenMemo;
    public final List<com.hedera.hashgraph.sdk.CustomFee> customFees;
    public final TokenType tokenType;
    public final TokenSupplyType supplyType;
    public final long maxSupply;
    @Nullable
    public final Key pauseKey;
    @Nullable
    public final Boolean pauseStatus;
    public byte[] metadata = new byte[0];
    @Nullable
    public final Key metadataKey;
    public final LedgerId ledgerId;

    TokenInfo(TokenId tokenId, String name, String symbol, int decimals, long totalSupply, AccountId treasuryAccountId, @Nullable Key adminKey, @Nullable Key kycKey, @Nullable Key freezeKey, @Nullable Key wipeKey, @Nullable Key supplyKey, @Nullable Key feeScheduleKey, @Nullable Boolean defaultFreezeStatus, @Nullable Boolean defaultKycStatus, boolean isDeleted, @Nullable AccountId autoRenewAccount, @Nullable Duration autoRenewPeriod, @Nullable Instant expirationTime, String tokenMemo, List<com.hedera.hashgraph.sdk.CustomFee> customFees, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, @Nullable Key pauseKey, @Nullable Boolean pauseStatus, byte[] metadata, @Nullable Key metadataKey, LedgerId ledgerId) {
        this.tokenId = tokenId;
        this.name = name;
        this.symbol = symbol;
        this.decimals = decimals;
        this.totalSupply = totalSupply;
        this.treasuryAccountId = treasuryAccountId;
        this.adminKey = adminKey;
        this.kycKey = kycKey;
        this.freezeKey = freezeKey;
        this.wipeKey = wipeKey;
        this.supplyKey = supplyKey;
        this.feeScheduleKey = feeScheduleKey;
        this.defaultFreezeStatus = defaultFreezeStatus;
        this.defaultKycStatus = defaultKycStatus;
        this.isDeleted = isDeleted;
        this.autoRenewAccount = autoRenewAccount;
        this.autoRenewPeriod = autoRenewPeriod;
        this.expirationTime = expirationTime;
        this.tokenMemo = tokenMemo;
        this.customFees = customFees;
        this.tokenType = tokenType;
        this.supplyType = supplyType;
        this.maxSupply = maxSupply;
        this.pauseKey = pauseKey;
        this.pauseStatus = pauseStatus;
        this.metadata = metadata;
        this.metadataKey = metadataKey;
        this.ledgerId = ledgerId;
    }

    @Nullable
    static Boolean freezeStatusFromProtobuf(TokenFreezeStatus freezeStatus) {
        return freezeStatus == TokenFreezeStatus.FreezeNotApplicable ? null : Boolean.valueOf(freezeStatus == TokenFreezeStatus.Frozen);
    }

    @Nullable
    static Boolean kycStatusFromProtobuf(TokenKycStatus kycStatus) {
        return kycStatus == TokenKycStatus.KycNotApplicable ? null : Boolean.valueOf(kycStatus == TokenKycStatus.Granted);
    }

    @Nullable
    static Boolean pauseStatusFromProtobuf(TokenPauseStatus pauseStatus) {
        return pauseStatus == TokenPauseStatus.PauseNotApplicable ? null : Boolean.valueOf(pauseStatus == TokenPauseStatus.Paused);
    }

    static TokenInfo fromProtobuf(TokenGetInfoResponse response) {
        com.hedera.hashgraph.sdk.proto.TokenInfo info = response.getTokenInfo();
        return new TokenInfo(TokenId.fromProtobuf(info.getTokenId()), info.getName(), info.getSymbol(), info.getDecimals(), info.getTotalSupply(), AccountId.fromProtobuf(info.getTreasury()), info.hasAdminKey() ? Key.fromProtobufKey(info.getAdminKey()) : null, info.hasKycKey() ? Key.fromProtobufKey(info.getKycKey()) : null, info.hasFreezeKey() ? Key.fromProtobufKey(info.getFreezeKey()) : null, info.hasWipeKey() ? Key.fromProtobufKey(info.getWipeKey()) : null, info.hasSupplyKey() ? Key.fromProtobufKey(info.getSupplyKey()) : null, info.hasFeeScheduleKey() ? Key.fromProtobufKey(info.getFeeScheduleKey()) : null, TokenInfo.freezeStatusFromProtobuf(info.getDefaultFreezeStatus()), TokenInfo.kycStatusFromProtobuf(info.getDefaultKycStatus()), info.getDeleted(), info.hasAutoRenewAccount() ? AccountId.fromProtobuf(info.getAutoRenewAccount()) : null, info.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(info.getAutoRenewPeriod()) : null, info.hasExpiry() ? InstantConverter.fromProtobuf(info.getExpiry()) : null, info.getMemo(), TokenInfo.customFeesFromProto(info), TokenType.valueOf(info.getTokenType()), TokenSupplyType.valueOf(info.getSupplyType()), info.getMaxSupply(), info.hasPauseKey() ? Key.fromProtobufKey(info.getPauseKey()) : null, TokenInfo.pauseStatusFromProtobuf(info.getPauseStatus()), info.getMetadata().toByteArray(), info.hasMetadataKey() ? Key.fromProtobufKey(info.getMetadataKey()) : null, LedgerId.fromByteString(info.getLedgerId()));
    }

    public static TokenInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenInfo.fromProtobuf((TokenGetInfoResponse)((TokenGetInfoResponse.Builder)TokenGetInfoResponse.parseFrom(bytes).toBuilder()).build());
    }

    private static List<com.hedera.hashgraph.sdk.CustomFee> customFeesFromProto(com.hedera.hashgraph.sdk.proto.TokenInfo info) {
        ArrayList<com.hedera.hashgraph.sdk.CustomFee> returnCustomFees = new ArrayList<com.hedera.hashgraph.sdk.CustomFee>(info.getCustomFeesCount());
        for (CustomFee feeProto : info.getCustomFeesList()) {
            returnCustomFees.add(com.hedera.hashgraph.sdk.CustomFee.fromProtobuf(feeProto));
        }
        return returnCustomFees;
    }

    static TokenFreezeStatus freezeStatusToProtobuf(@Nullable Boolean freezeStatus) {
        return freezeStatus == null ? TokenFreezeStatus.FreezeNotApplicable : (freezeStatus != false ? TokenFreezeStatus.Frozen : TokenFreezeStatus.Unfrozen);
    }

    static TokenKycStatus kycStatusToProtobuf(@Nullable Boolean kycStatus) {
        return kycStatus == null ? TokenKycStatus.KycNotApplicable : (kycStatus != false ? TokenKycStatus.Granted : TokenKycStatus.Revoked);
    }

    static TokenPauseStatus pauseStatusToProtobuf(@Nullable Boolean pauseStatus) {
        return pauseStatus == null ? TokenPauseStatus.PauseNotApplicable : (pauseStatus != false ? TokenPauseStatus.Paused : TokenPauseStatus.Unpaused);
    }

    TokenGetInfoResponse toProtobuf() {
        TokenInfo.Builder tokenInfoBuilder = com.hedera.hashgraph.sdk.proto.TokenInfo.newBuilder().setTokenId(this.tokenId.toProtobuf()).setName(this.name).setSymbol(this.symbol).setDecimals(this.decimals).setTotalSupply(this.totalSupply).setTreasury(this.treasuryAccountId.toProtobuf()).setDefaultFreezeStatus(TokenInfo.freezeStatusToProtobuf(this.defaultFreezeStatus)).setDefaultKycStatus(TokenInfo.kycStatusToProtobuf(this.defaultKycStatus)).setDeleted(this.isDeleted).setMemo(this.tokenMemo).setTokenType(this.tokenType.code).setSupplyType(this.supplyType.code).setMaxSupply(this.maxSupply).setPauseStatus(TokenInfo.pauseStatusToProtobuf(this.pauseStatus)).setLedgerId(this.ledgerId.toByteString());
        if (this.adminKey != null) {
            tokenInfoBuilder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.kycKey != null) {
            tokenInfoBuilder.setKycKey(this.kycKey.toProtobufKey());
        }
        if (this.freezeKey != null) {
            tokenInfoBuilder.setFreezeKey(this.freezeKey.toProtobufKey());
        }
        if (this.wipeKey != null) {
            tokenInfoBuilder.setWipeKey(this.wipeKey.toProtobufKey());
        }
        if (this.supplyKey != null) {
            tokenInfoBuilder.setSupplyKey(this.supplyKey.toProtobufKey());
        }
        if (this.feeScheduleKey != null) {
            tokenInfoBuilder.setFeeScheduleKey(this.feeScheduleKey.toProtobufKey());
        }
        if (this.pauseKey != null) {
            tokenInfoBuilder.setPauseKey(this.pauseKey.toProtobufKey());
        }
        if (this.metadata != null) {
            tokenInfoBuilder.setMetadata(ByteString.copyFrom((byte[])this.metadata));
        }
        if (this.metadataKey != null) {
            tokenInfoBuilder.setMetadataKey(this.metadataKey.toProtobufKey());
        }
        if (this.autoRenewAccount != null) {
            tokenInfoBuilder.setAutoRenewAccount(this.autoRenewAccount.toProtobuf());
        }
        if (this.autoRenewPeriod != null) {
            tokenInfoBuilder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        if (this.expirationTime != null) {
            tokenInfoBuilder.setExpiry(InstantConverter.toProtobuf(this.expirationTime));
        }
        for (com.hedera.hashgraph.sdk.CustomFee fee : this.customFees) {
            tokenInfoBuilder.addCustomFees(fee.toProtobuf());
        }
        return (TokenGetInfoResponse)TokenGetInfoResponse.newBuilder().setTokenInfo(tokenInfoBuilder).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokenId", (Object)this.tokenId).add("name", (Object)this.name).add("symbol", (Object)this.symbol).add("decimals", this.decimals).add("totalSupply", this.totalSupply).add("treasuryAccountId", (Object)this.treasuryAccountId).add("adminKey", (Object)this.adminKey).add("kycKey", (Object)this.kycKey).add("freezeKey", (Object)this.freezeKey).add("wipeKey", (Object)this.wipeKey).add("supplyKey", (Object)this.supplyKey).add("feeScheduleKey", (Object)this.feeScheduleKey).add("defaultFreezeStatus", (Object)this.defaultFreezeStatus).add("defaultKycStatus", (Object)this.defaultKycStatus).add("isDeleted", this.isDeleted).add("autoRenewAccount", (Object)this.autoRenewAccount).add("autoRenewPeriod", (Object)this.autoRenewPeriod).add("expirationTime", (Object)this.expirationTime).add("tokenMemo", (Object)this.tokenMemo).add("customFees", this.customFees).add("tokenType", (Object)this.tokenType).add("supplyType", (Object)this.supplyType).add("maxSupply", this.maxSupply).add("pauseKey", (Object)this.pauseKey).add("pauseStatus", (Object)this.pauseStatus).add("metadata", (Object)this.metadata).add("metadataKey", (Object)this.metadataKey).add("ledgerId", (Object)this.ledgerId).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

