/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.logger;

import com.hedera.hashgraph.sdk.logger.LogLevel;
import org.slf4j.LoggerFactory;

public class Logger {
    private org.slf4j.Logger internalLogger = LoggerFactory.getLogger(this.getClass());
    private LogLevel currentLevel;
    private LogLevel previousLevel;

    public Logger(LogLevel level) {
        this.currentLevel = level;
        this.previousLevel = level;
    }

    public Logger setLogger(org.slf4j.Logger logger) {
        this.internalLogger = logger;
        return this;
    }

    public LogLevel getLevel() {
        return this.currentLevel;
    }

    public Logger setLevel(LogLevel level) {
        this.previousLevel = this.currentLevel;
        this.currentLevel = level;
        return this;
    }

    public Logger setSilent(boolean silent) {
        this.currentLevel = silent ? LogLevel.SILENT : this.previousLevel;
        return this;
    }

    public void trace(String message, Object ... arguments) {
        if (this.isEnabledForLevel(LogLevel.TRACE)) {
            this.internalLogger.trace(message, arguments);
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.isEnabledForLevel(LogLevel.DEBUG)) {
            this.internalLogger.debug(message, arguments);
        }
    }

    public void info(String message, Object ... arguments) {
        if (this.isEnabledForLevel(LogLevel.INFO)) {
            this.internalLogger.info(message, arguments);
        }
    }

    public void warn(String message, Object ... arguments) {
        if (this.isEnabledForLevel(LogLevel.WARN)) {
            this.internalLogger.warn(message, arguments);
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.isEnabledForLevel(LogLevel.ERROR)) {
            this.internalLogger.error(message, arguments);
        }
    }

    public boolean isEnabledForLevel(LogLevel level) {
        return level.toInt() >= this.currentLevel.toInt();
    }
}

