/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HbarAllowance;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.LiveHash;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.StakingInfo;
import com.hedera.hashgraph.sdk.TokenAllowance;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftAllowance;
import com.hedera.hashgraph.sdk.TokenRelationship;
import com.hedera.hashgraph.sdk.proto.CryptoGetInfoResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class AccountInfo {
    public final AccountId accountId;
    public final String contractAccountId;
    public final boolean isDeleted;
    @Nullable
    public final AccountId proxyAccountId;
    public final Hbar proxyReceived;
    public final Key key;
    public final Hbar balance;
    public final Hbar sendRecordThreshold;
    public final Hbar receiveRecordThreshold;
    public final boolean isReceiverSignatureRequired;
    public final Instant expirationTime;
    public final Duration autoRenewPeriod;
    public final List<LiveHash> liveHashes;
    public final Map<TokenId, TokenRelationship> tokenRelationships;
    public final String accountMemo;
    public final long ownedNfts;
    public final int maxAutomaticTokenAssociations;
    @Nullable
    public final PublicKey aliasKey;
    public final LedgerId ledgerId;
    public final long ethereumNonce;
    @Deprecated
    public final List<HbarAllowance> hbarAllowances;
    @Deprecated
    public final List<TokenAllowance> tokenAllowances;
    @Deprecated
    public final List<TokenNftAllowance> tokenNftAllowances;
    @Nullable
    public final StakingInfo stakingInfo;

    private AccountInfo(AccountId accountId, String contractAccountId, boolean isDeleted, @Nullable AccountId proxyAccountId, long proxyReceived, Key key, long balance, long sendRecordThreshold, long receiveRecordThreshold, boolean receiverSignatureRequired, Instant expirationTime, Duration autoRenewPeriod, List<LiveHash> liveHashes, Map<TokenId, TokenRelationship> tokenRelationships, String accountMemo, long ownedNfts, int maxAutomaticTokenAssociations, @Nullable PublicKey aliasKey, LedgerId ledgerId, long ethereumNonce, @Nullable StakingInfo stakingInfo) {
        this.accountId = accountId;
        this.contractAccountId = contractAccountId;
        this.isDeleted = isDeleted;
        this.proxyAccountId = proxyAccountId;
        this.proxyReceived = Hbar.fromTinybars(proxyReceived);
        this.key = key;
        this.balance = Hbar.fromTinybars(balance);
        this.sendRecordThreshold = Hbar.fromTinybars(sendRecordThreshold);
        this.receiveRecordThreshold = Hbar.fromTinybars(receiveRecordThreshold);
        this.isReceiverSignatureRequired = receiverSignatureRequired;
        this.expirationTime = expirationTime;
        this.autoRenewPeriod = autoRenewPeriod;
        this.liveHashes = liveHashes;
        this.tokenRelationships = Collections.unmodifiableMap(tokenRelationships);
        this.accountMemo = accountMemo;
        this.ownedNfts = ownedNfts;
        this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
        this.aliasKey = aliasKey;
        this.ledgerId = ledgerId;
        this.ethereumNonce = ethereumNonce;
        this.hbarAllowances = Collections.emptyList();
        this.tokenAllowances = Collections.emptyList();
        this.tokenNftAllowances = Collections.emptyList();
        this.stakingInfo = stakingInfo;
    }

    static AccountInfo fromProtobuf(CryptoGetInfoResponse.AccountInfo accountInfo) {
        AccountId accountId = AccountId.fromProtobuf(accountInfo.getAccountID());
        AccountId proxyAccountId = accountInfo.getProxyAccountID().getAccountNum() > 0L ? AccountId.fromProtobuf(accountInfo.getProxyAccountID()) : null;
        List<LiveHash> liveHashes = Arrays.stream(accountInfo.getLiveHashesList().toArray()).map(liveHash -> LiveHash.fromProtobuf((com.hedera.hashgraph.sdk.proto.LiveHash)liveHash)).collect(Collectors.toList());
        HashMap<TokenId, TokenRelationship> relationships = new HashMap<TokenId, TokenRelationship>();
        for (com.hedera.hashgraph.sdk.proto.TokenRelationship relationship : accountInfo.getTokenRelationshipsList()) {
            TokenId tokenId = TokenId.fromProtobuf(relationship.getTokenId());
            relationships.put(tokenId, TokenRelationship.fromProtobuf(relationship));
        }
        PublicKey aliasKey = PublicKey.fromAliasBytes(accountInfo.getAlias());
        return new AccountInfo(accountId, accountInfo.getContractAccountID(), accountInfo.getDeleted(), proxyAccountId, accountInfo.getProxyReceived(), Key.fromProtobufKey(accountInfo.getKey()), accountInfo.getBalance(), accountInfo.getGenerateSendRecordThreshold(), accountInfo.getGenerateReceiveRecordThreshold(), accountInfo.getReceiverSigRequired(), InstantConverter.fromProtobuf(accountInfo.getExpirationTime()), DurationConverter.fromProtobuf(accountInfo.getAutoRenewPeriod()), liveHashes, relationships, accountInfo.getMemo(), accountInfo.getOwnedNfts(), accountInfo.getMaxAutomaticTokenAssociations(), aliasKey, LedgerId.fromByteString(accountInfo.getLedgerId()), accountInfo.getEthereumNonce(), accountInfo.hasStakingInfo() ? StakingInfo.fromProtobuf(accountInfo.getStakingInfo()) : null);
    }

    public static AccountInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return AccountInfo.fromProtobuf((CryptoGetInfoResponse.AccountInfo)((CryptoGetInfoResponse.AccountInfo.Builder)CryptoGetInfoResponse.AccountInfo.parseFrom(bytes).toBuilder()).build());
    }

    CryptoGetInfoResponse.AccountInfo toProtobuf() {
        List hashes = Arrays.stream(this.liveHashes.toArray()).map(liveHash -> ((LiveHash)liveHash).toProtobuf()).collect(Collectors.toList());
        CryptoGetInfoResponse.AccountInfo.Builder accountInfoBuilder = CryptoGetInfoResponse.AccountInfo.newBuilder().setAccountID(this.accountId.toProtobuf()).setDeleted(this.isDeleted).setProxyReceived(this.proxyReceived.toTinybars()).setKey(this.key.toProtobufKey()).setBalance(this.balance.toTinybars()).setGenerateSendRecordThreshold(this.sendRecordThreshold.toTinybars()).setGenerateReceiveRecordThreshold(this.receiveRecordThreshold.toTinybars()).setReceiverSigRequired(this.isReceiverSignatureRequired).setExpirationTime(InstantConverter.toProtobuf(this.expirationTime)).setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod)).addAllLiveHashes(hashes).setMemo(this.accountMemo).setOwnedNfts(this.ownedNfts).setMaxAutomaticTokenAssociations(this.maxAutomaticTokenAssociations).setLedgerId(this.ledgerId.toByteString()).setEthereumNonce(this.ethereumNonce);
        if (this.contractAccountId != null) {
            accountInfoBuilder.setContractAccountID(this.contractAccountId);
        }
        if (this.proxyAccountId != null) {
            accountInfoBuilder.setProxyAccountID(this.proxyAccountId.toProtobuf());
        }
        if (this.aliasKey != null) {
            accountInfoBuilder.setAlias(this.aliasKey.toProtobufKey().toByteString());
        }
        if (this.stakingInfo != null) {
            accountInfoBuilder.setStakingInfo(this.stakingInfo.toProtobuf());
        }
        return (CryptoGetInfoResponse.AccountInfo)accountInfoBuilder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountId", (Object)this.accountId).add("contractAccountId", (Object)this.contractAccountId).add("deleted", this.isDeleted).add("proxyAccountId", (Object)this.proxyAccountId).add("proxyReceived", (Object)this.proxyReceived).add("key", (Object)this.key).add("balance", (Object)this.balance).add("sendRecordThreshold", (Object)this.sendRecordThreshold).add("receiveRecordThreshold", (Object)this.receiveRecordThreshold).add("receiverSignatureRequired", this.isReceiverSignatureRequired).add("expirationTime", (Object)this.expirationTime).add("autoRenewPeriod", (Object)this.autoRenewPeriod).add("liveHashes", this.liveHashes).add("tokenRelationships", this.tokenRelationships).add("accountMemo", (Object)this.accountMemo).add("ownedNfts", this.ownedNfts).add("maxAutomaticTokenAssociations", this.maxAutomaticTokenAssociations).add("aliasKey", (Object)this.aliasKey).add("ledgerId", (Object)this.ledgerId).add("ethereumNonce", this.ethereumNonce).add("stakingInfo", (Object)this.stakingInfo).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

