/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.AccountInfo;
import com.hedera.hashgraph.sdk.AccountInfoQuery;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.Transaction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class AccountInfoFlow {
    private static PublicKey getAccountPublicKey(Client client, AccountId accountId) throws PrecheckStatusException, TimeoutException {
        return AccountInfoFlow.requirePublicKey(accountId, ((AccountInfo)new AccountInfoQuery().setAccountId((AccountId)accountId).execute((Client)client)).key);
    }

    private static CompletableFuture<PublicKey> getAccountPublicKeyAsync(Client client, AccountId accountId) {
        return new AccountInfoQuery().setAccountId(accountId).executeAsync(client).thenApply(accountInfo -> AccountInfoFlow.requirePublicKey(accountId, accountInfo.key));
    }

    private static PublicKey requirePublicKey(AccountId accountId, Key key) {
        if (key instanceof PublicKey) {
            PublicKey k = (PublicKey)key;
            return k;
        }
        throw new UnsupportedOperationException("Account " + accountId + " has a KeyList key, which is not supported");
    }

    public static boolean verifySignature(Client client, AccountId accountId, byte[] message, byte[] signature) throws PrecheckStatusException, TimeoutException {
        return AccountInfoFlow.getAccountPublicKey(client, accountId).verify(message, signature);
    }

    public static boolean verifyTransactionSignature(Client client, AccountId accountId, Transaction<?> transaction) throws PrecheckStatusException, TimeoutException {
        return AccountInfoFlow.getAccountPublicKey(client, accountId).verifyTransaction(transaction);
    }

    public static CompletableFuture<Boolean> verifySignatureAsync(Client client, AccountId accountId, byte[] message, byte[] signature) {
        return AccountInfoFlow.getAccountPublicKeyAsync(client, accountId).thenApply(pubKey -> pubKey.verify(message, signature));
    }

    public static CompletableFuture<Boolean> verifyTransactionSignatureAsync(Client client, AccountId accountId, Transaction<?> transaction) {
        return AccountInfoFlow.getAccountPublicKeyAsync(client, accountId).thenApply(pubKey -> pubKey.verifyTransaction(transaction));
    }
}

