/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.CustomFeeBase;
import com.hedera.hashgraph.sdk.FeeAssessmentMethod;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.Fraction;
import com.hedera.hashgraph.sdk.proto.FractionalFee;
import java.util.Objects;

public class CustomFractionalFee
extends CustomFeeBase<CustomFractionalFee> {
    private long numerator = 0L;
    private long denominator = 1L;
    private long min = 0L;
    private long max = 0L;
    private FeeAssessmentMethod assessmentMethod = FeeAssessmentMethod.INCLUSIVE;

    static CustomFractionalFee fromProtobuf(FractionalFee fractionalFee) {
        Fraction fraction = fractionalFee.getFractionalAmount();
        return new CustomFractionalFee().setNumerator(fraction.getNumerator()).setDenominator(fraction.getDenominator()).setMin(fractionalFee.getMinimumAmount()).setMax(fractionalFee.getMaximumAmount()).setAssessmentMethod(FeeAssessmentMethod.valueOf(fractionalFee.getNetOfTransfers()));
    }

    @Override
    CustomFractionalFee deepCloneSubclass() {
        return new CustomFractionalFee().setNumerator(this.numerator).setDenominator(this.denominator).setMin(this.min).setMax(this.max).setAssessmentMethod(this.assessmentMethod).finishDeepClone(this);
    }

    public long getNumerator() {
        return this.numerator;
    }

    public CustomFractionalFee setNumerator(long numerator) {
        this.numerator = numerator;
        return this;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public CustomFractionalFee setDenominator(long denominator) {
        this.denominator = denominator;
        return this;
    }

    public long getMin() {
        return this.min;
    }

    public CustomFractionalFee setMin(long min) {
        this.min = min;
        return this;
    }

    public long getMax() {
        return this.max;
    }

    public CustomFractionalFee setMax(long max) {
        this.max = max;
        return this;
    }

    public FeeAssessmentMethod getAssessmentMethod() {
        return this.assessmentMethod;
    }

    public CustomFractionalFee setAssessmentMethod(FeeAssessmentMethod assessmentMethod) {
        Objects.requireNonNull(assessmentMethod);
        this.assessmentMethod = assessmentMethod;
        return this;
    }

    public String toString() {
        return this.toStringHelper().add("numerator", this.getNumerator()).add("denominator", this.getDenominator()).add("min", this.getMin()).add("max", this.getMax()).add("assessmentMethod", (Object)this.getAssessmentMethod()).toString();
    }

    FractionalFee toFractionalFeeProtobuf() {
        return (FractionalFee)FractionalFee.newBuilder().setMinimumAmount(this.getMin()).setMaximumAmount(this.getMax()).setFractionalAmount(Fraction.newBuilder().setNumerator(this.getNumerator()).setDenominator(this.getDenominator())).setNetOfTransfers(this.assessmentMethod.code).build();
    }

    @Override
    CustomFee toProtobuf() {
        CustomFee.Builder customFeeBuilder = CustomFee.newBuilder().setFractionalFee(this.toFractionalFeeProtobuf());
        return this.finishToProtobuf(customFeeBuilder);
    }
}

