/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Delayer {
    private static final Logger logger = LoggerFactory.getLogger(Delayer.class);
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });
    private static final Duration MIN_DELAY = Duration.ofMillis(500L);

    private Delayer() {
    }

    static CompletableFuture<Void> delayBackOff(int attempt, Executor executor) {
        Duration interval = MIN_DELAY.multipliedBy(ThreadLocalRandom.current().nextLong(1L << attempt));
        return Delayer.delayFor(interval.toMillis(), executor);
    }

    static CompletableFuture<Void> delayFor(long milliseconds, Executor executor) {
        logger.trace("waiting for {} seconds before trying again", (Object)((double)milliseconds / 1000.0));
        return CompletableFuture.runAsync(() -> {}, Delayer.delayedExecutor(milliseconds, TimeUnit.MILLISECONDS, executor));
    }

    private static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        return r -> SCHEDULER.schedule(() -> executor.execute(r), delay, unit);
    }
}

