/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BaseNetwork;
import com.hedera.hashgraph.sdk.Endpoint;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.NodeAddress;
import com.hedera.hashgraph.sdk.NodeAddressBook;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

class Network
extends BaseNetwork<Network, AccountId, Node> {
    @Nullable
    private Integer maxNodesPerRequest;
    @Nullable
    Map<AccountId, NodeAddress> addressBook;
    private boolean verifyCertificates = true;

    private Network(ExecutorService executor, Map<String, AccountId> network) {
        super(executor);
        try {
            this.setNetwork(network);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
    }

    static Network forNetwork(ExecutorService executor, Map<String, AccountId> network) {
        return new Network(executor, network);
    }

    static Network forMainnet(ExecutorService executor) {
        Map<AccountId, NodeAddress> addressBook = Network.getAddressBookForLedger(LedgerId.MAINNET);
        HashMap<String, AccountId> network = Network.addressBookToNetwork(Objects.requireNonNull(addressBook).values(), 50211);
        return new Network(executor, network).setLedgerIdInternal(LedgerId.MAINNET, addressBook);
    }

    static Network forTestnet(ExecutorService executor) {
        Map<AccountId, NodeAddress> addressBook = Network.getAddressBookForLedger(LedgerId.TESTNET);
        HashMap<String, AccountId> network = Network.addressBookToNetwork(Objects.requireNonNull(addressBook).values(), 50211);
        return new Network(executor, network).setLedgerIdInternal(LedgerId.TESTNET, addressBook);
    }

    static Network forPreviewnet(ExecutorService executor) {
        Map<AccountId, NodeAddress> addressBook = Network.getAddressBookForLedger(LedgerId.PREVIEWNET);
        HashMap<String, AccountId> network = Network.addressBookToNetwork(Objects.requireNonNull(addressBook).values(), 50211);
        return new Network(executor, network).setLedgerIdInternal(LedgerId.PREVIEWNET, addressBook);
    }

    boolean isVerifyCertificates() {
        return this.verifyCertificates;
    }

    synchronized Network setVerifyCertificates(boolean verifyCertificates) {
        this.verifyCertificates = verifyCertificates;
        for (Node node : this.nodes) {
            node.setVerifyCertificates(verifyCertificates);
        }
        return this;
    }

    @Override
    synchronized Network setLedgerId(@Nullable LedgerId ledgerId) {
        return this.setLedgerIdInternal(ledgerId, Network.getAddressBookForLedger(ledgerId));
    }

    private Network setLedgerIdInternal(@Nullable LedgerId ledgerId, @Nullable Map<AccountId, NodeAddress> addressBook) {
        super.setLedgerId(ledgerId);
        this.addressBook = addressBook;
        for (Node node : this.nodes) {
            node.setAddressBookEntry(addressBook == null ? null : addressBook.get(node.getAccountId()));
        }
        return this;
    }

    @Nullable
    private static Map<AccountId, NodeAddress> getAddressBookForLedger(@Nullable LedgerId ledgerId) {
        return ledgerId == null || !ledgerId.isKnownNetwork() ? null : Network.readAddressBookResource("addressbook/" + ledgerId + ".pb");
    }

    static HashMap<String, AccountId> addressBookToNetwork(Collection<NodeAddress> addressBook, int desiredPort) {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        for (NodeAddress nodeAddress : addressBook) {
            for (Endpoint endpoint : nodeAddress.addresses) {
                if (endpoint.port != desiredPort) continue;
                network.put(endpoint.toString(), nodeAddress.accountId);
            }
        }
        return network;
    }

    static Map<AccountId, NodeAddress> readAddressBookResource(String fileName) {
        HashMap<AccountId, NodeAddress> hashMap;
        block9: {
            InputStream inputStream = Objects.requireNonNull(Network.class.getResource("/" + fileName)).openStream();
            try {
                byte[] contents = ByteStreams.toByteArray((InputStream)inputStream);
                NodeAddressBook nodeAddressBook = NodeAddressBook.fromBytes(ByteString.copyFrom((byte[])contents));
                HashMap<AccountId, NodeAddress> map = new HashMap<AccountId, NodeAddress>();
                for (NodeAddress nodeAddress : nodeAddressBook.nodeAddresses) {
                    if (nodeAddress.accountId == null) continue;
                    map.put(nodeAddress.accountId, nodeAddress);
                }
                hashMap = map;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return hashMap;
    }

    synchronized Map<String, AccountId> getNetwork() {
        HashMap<String, AccountId> returnMap = new HashMap<String, AccountId>();
        for (Node node : this.nodes) {
            returnMap.put(node.address.toString(), node.getAccountId());
        }
        return returnMap;
    }

    @Override
    protected Node createNodeFromNetworkEntry(Map.Entry<String, AccountId> entry) {
        return new Node(entry.getValue(), entry.getKey(), this.executor).setVerifyCertificates(this.verifyCertificates);
    }

    synchronized List<AccountId> getNodeAccountIdsForExecute() throws InterruptedException {
        List nodes = this.getNumberOfMostHealthyNodes(this.getNumberOfNodesForRequest());
        ArrayList<AccountId> nodeAccountIds = new ArrayList<AccountId>(nodes.size());
        for (Node node : nodes) {
            nodeAccountIds.add(node.getAccountId());
        }
        return nodeAccountIds;
    }

    Network setMaxNodesPerRequest(int maxNodesPerRequest) {
        this.maxNodesPerRequest = maxNodesPerRequest;
        return this;
    }

    int getNumberOfNodesForRequest() {
        if (this.maxNodesPerRequest != null) {
            return Math.min(this.maxNodesPerRequest, this.network.size());
        }
        return (this.network.size() + 3 - 1) / 3;
    }

    private List<Node> getNodesForKey(AccountId key) {
        if (this.network.containsKey(key)) {
            return (List)this.network.get(key);
        }
        ArrayList<Node> newList = new ArrayList<Node>();
        this.network.put(key, newList);
        return newList;
    }

    synchronized Network setTransportSecurity(boolean transportSecurity) throws InterruptedException {
        if (this.transportSecurity != transportSecurity) {
            this.network.clear();
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node node = (Node)this.nodes.get(i);
                node.close(this.closeTimeout);
                node = transportSecurity ? node.toSecure() : node.toInsecure();
                this.nodes.set(i, node);
                this.getNodesForKey(node.getKey()).add(node);
            }
        }
        this.healthyNodes = new ArrayList(this.nodes);
        this.transportSecurity = transportSecurity;
        return this;
    }
}

