/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleServiceGrpc;
import com.hedera.hashgraph.sdk.proto.ScheduleSignTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ScheduleSignTransaction
extends com.hedera.hashgraph.sdk.Transaction<ScheduleSignTransaction> {
    @Nullable
    private ScheduleId scheduleId = null;

    public ScheduleSignTransaction() {
        this.defaultMaxTransactionFee = new Hbar(5L);
    }

    ScheduleSignTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    @Nullable
    public ScheduleId getScheduleId() {
        return this.scheduleId;
    }

    public ScheduleSignTransaction setScheduleId(ScheduleId scheduleId) {
        Objects.requireNonNull(scheduleId);
        this.requireNotFrozen();
        this.scheduleId = scheduleId;
        return this;
    }

    @Deprecated
    public ScheduleSignTransaction clearScheduleId() {
        this.requireNotFrozen();
        this.scheduleId = null;
        return this;
    }

    ScheduleSignTransactionBody.Builder build() {
        ScheduleSignTransactionBody.Builder builder = ScheduleSignTransactionBody.newBuilder();
        if (this.scheduleId != null) {
            builder.setScheduleID(this.scheduleId.toProtobuf());
        }
        return builder;
    }

    void initFromTransactionBody() {
        ScheduleSignTransactionBody body = this.sourceTransactionBody.getScheduleSign();
        if (body.hasScheduleID()) {
            this.scheduleId = ScheduleId.fromProtobuf(body.getScheduleID());
        }
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.scheduleId != null) {
            this.scheduleId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ScheduleServiceGrpc.getSignScheduleMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setScheduleSign(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        throw new UnsupportedOperationException("cannot schedule ScheduleSignTransaction");
    }
}

