/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.ResponseCodeEnum;
import java.util.Objects;

public enum Status {
    OK(ResponseCodeEnum.OK),
    INVALID_TRANSACTION(ResponseCodeEnum.INVALID_TRANSACTION),
    PAYER_ACCOUNT_NOT_FOUND(ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND),
    INVALID_NODE_ACCOUNT(ResponseCodeEnum.INVALID_NODE_ACCOUNT),
    TRANSACTION_EXPIRED(ResponseCodeEnum.TRANSACTION_EXPIRED),
    INVALID_TRANSACTION_START(ResponseCodeEnum.INVALID_TRANSACTION_START),
    INVALID_TRANSACTION_DURATION(ResponseCodeEnum.INVALID_TRANSACTION_DURATION),
    INVALID_SIGNATURE(ResponseCodeEnum.INVALID_SIGNATURE),
    MEMO_TOO_LONG(ResponseCodeEnum.MEMO_TOO_LONG),
    INSUFFICIENT_TX_FEE(ResponseCodeEnum.INSUFFICIENT_TX_FEE),
    INSUFFICIENT_PAYER_BALANCE(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE),
    DUPLICATE_TRANSACTION(ResponseCodeEnum.DUPLICATE_TRANSACTION),
    BUSY(ResponseCodeEnum.BUSY),
    NOT_SUPPORTED(ResponseCodeEnum.NOT_SUPPORTED),
    INVALID_FILE_ID(ResponseCodeEnum.INVALID_FILE_ID),
    INVALID_ACCOUNT_ID(ResponseCodeEnum.INVALID_ACCOUNT_ID),
    INVALID_CONTRACT_ID(ResponseCodeEnum.INVALID_CONTRACT_ID),
    INVALID_TRANSACTION_ID(ResponseCodeEnum.INVALID_TRANSACTION_ID),
    RECEIPT_NOT_FOUND(ResponseCodeEnum.RECEIPT_NOT_FOUND),
    RECORD_NOT_FOUND(ResponseCodeEnum.RECORD_NOT_FOUND),
    INVALID_SOLIDITY_ID(ResponseCodeEnum.INVALID_SOLIDITY_ID),
    UNKNOWN(ResponseCodeEnum.UNKNOWN),
    SUCCESS(ResponseCodeEnum.SUCCESS),
    FAIL_INVALID(ResponseCodeEnum.FAIL_INVALID),
    FAIL_FEE(ResponseCodeEnum.FAIL_FEE),
    FAIL_BALANCE(ResponseCodeEnum.FAIL_BALANCE),
    KEY_REQUIRED(ResponseCodeEnum.KEY_REQUIRED),
    BAD_ENCODING(ResponseCodeEnum.BAD_ENCODING),
    INSUFFICIENT_ACCOUNT_BALANCE(ResponseCodeEnum.INSUFFICIENT_ACCOUNT_BALANCE),
    INVALID_SOLIDITY_ADDRESS(ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS),
    INSUFFICIENT_GAS(ResponseCodeEnum.INSUFFICIENT_GAS),
    CONTRACT_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.CONTRACT_SIZE_LIMIT_EXCEEDED),
    LOCAL_CALL_MODIFICATION_EXCEPTION(ResponseCodeEnum.LOCAL_CALL_MODIFICATION_EXCEPTION),
    CONTRACT_REVERT_EXECUTED(ResponseCodeEnum.CONTRACT_REVERT_EXECUTED),
    CONTRACT_EXECUTION_EXCEPTION(ResponseCodeEnum.CONTRACT_EXECUTION_EXCEPTION),
    INVALID_RECEIVING_NODE_ACCOUNT(ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT),
    MISSING_QUERY_HEADER(ResponseCodeEnum.MISSING_QUERY_HEADER),
    ACCOUNT_UPDATE_FAILED(ResponseCodeEnum.ACCOUNT_UPDATE_FAILED),
    INVALID_KEY_ENCODING(ResponseCodeEnum.INVALID_KEY_ENCODING),
    NULL_SOLIDITY_ADDRESS(ResponseCodeEnum.NULL_SOLIDITY_ADDRESS),
    CONTRACT_UPDATE_FAILED(ResponseCodeEnum.CONTRACT_UPDATE_FAILED),
    INVALID_QUERY_HEADER(ResponseCodeEnum.INVALID_QUERY_HEADER),
    INVALID_FEE_SUBMITTED(ResponseCodeEnum.INVALID_FEE_SUBMITTED),
    INVALID_PAYER_SIGNATURE(ResponseCodeEnum.INVALID_PAYER_SIGNATURE),
    KEY_NOT_PROVIDED(ResponseCodeEnum.KEY_NOT_PROVIDED),
    INVALID_EXPIRATION_TIME(ResponseCodeEnum.INVALID_EXPIRATION_TIME),
    NO_WACL_KEY(ResponseCodeEnum.NO_WACL_KEY),
    FILE_CONTENT_EMPTY(ResponseCodeEnum.FILE_CONTENT_EMPTY),
    INVALID_ACCOUNT_AMOUNTS(ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS),
    EMPTY_TRANSACTION_BODY(ResponseCodeEnum.EMPTY_TRANSACTION_BODY),
    INVALID_TRANSACTION_BODY(ResponseCodeEnum.INVALID_TRANSACTION_BODY),
    INVALID_SIGNATURE_TYPE_MISMATCHING_KEY(ResponseCodeEnum.INVALID_SIGNATURE_TYPE_MISMATCHING_KEY),
    INVALID_SIGNATURE_COUNT_MISMATCHING_KEY(ResponseCodeEnum.INVALID_SIGNATURE_COUNT_MISMATCHING_KEY),
    EMPTY_LIVE_HASH_BODY(ResponseCodeEnum.EMPTY_LIVE_HASH_BODY),
    EMPTY_LIVE_HASH(ResponseCodeEnum.EMPTY_LIVE_HASH),
    EMPTY_LIVE_HASH_KEYS(ResponseCodeEnum.EMPTY_LIVE_HASH_KEYS),
    INVALID_LIVE_HASH_SIZE(ResponseCodeEnum.INVALID_LIVE_HASH_SIZE),
    EMPTY_QUERY_BODY(ResponseCodeEnum.EMPTY_QUERY_BODY),
    EMPTY_LIVE_HASH_QUERY(ResponseCodeEnum.EMPTY_LIVE_HASH_QUERY),
    LIVE_HASH_NOT_FOUND(ResponseCodeEnum.LIVE_HASH_NOT_FOUND),
    ACCOUNT_ID_DOES_NOT_EXIST(ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST),
    LIVE_HASH_ALREADY_EXISTS(ResponseCodeEnum.LIVE_HASH_ALREADY_EXISTS),
    INVALID_FILE_WACL(ResponseCodeEnum.INVALID_FILE_WACL),
    SERIALIZATION_FAILED(ResponseCodeEnum.SERIALIZATION_FAILED),
    TRANSACTION_OVERSIZE(ResponseCodeEnum.TRANSACTION_OVERSIZE),
    TRANSACTION_TOO_MANY_LAYERS(ResponseCodeEnum.TRANSACTION_TOO_MANY_LAYERS),
    CONTRACT_DELETED(ResponseCodeEnum.CONTRACT_DELETED),
    PLATFORM_NOT_ACTIVE(ResponseCodeEnum.PLATFORM_NOT_ACTIVE),
    KEY_PREFIX_MISMATCH(ResponseCodeEnum.KEY_PREFIX_MISMATCH),
    PLATFORM_TRANSACTION_NOT_CREATED(ResponseCodeEnum.PLATFORM_TRANSACTION_NOT_CREATED),
    INVALID_RENEWAL_PERIOD(ResponseCodeEnum.INVALID_RENEWAL_PERIOD),
    INVALID_PAYER_ACCOUNT_ID(ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID),
    ACCOUNT_DELETED(ResponseCodeEnum.ACCOUNT_DELETED),
    FILE_DELETED(ResponseCodeEnum.FILE_DELETED),
    ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS(ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS),
    SETTING_NEGATIVE_ACCOUNT_BALANCE(ResponseCodeEnum.SETTING_NEGATIVE_ACCOUNT_BALANCE),
    OBTAINER_REQUIRED(ResponseCodeEnum.OBTAINER_REQUIRED),
    OBTAINER_SAME_CONTRACT_ID(ResponseCodeEnum.OBTAINER_SAME_CONTRACT_ID),
    OBTAINER_DOES_NOT_EXIST(ResponseCodeEnum.OBTAINER_DOES_NOT_EXIST),
    MODIFYING_IMMUTABLE_CONTRACT(ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT),
    FILE_SYSTEM_EXCEPTION(ResponseCodeEnum.FILE_SYSTEM_EXCEPTION),
    AUTORENEW_DURATION_NOT_IN_RANGE(ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE),
    ERROR_DECODING_BYTESTRING(ResponseCodeEnum.ERROR_DECODING_BYTESTRING),
    CONTRACT_FILE_EMPTY(ResponseCodeEnum.CONTRACT_FILE_EMPTY),
    CONTRACT_BYTECODE_EMPTY(ResponseCodeEnum.CONTRACT_BYTECODE_EMPTY),
    INVALID_INITIAL_BALANCE(ResponseCodeEnum.INVALID_INITIAL_BALANCE),
    INVALID_RECEIVE_RECORD_THRESHOLD(ResponseCodeEnum.INVALID_RECEIVE_RECORD_THRESHOLD),
    INVALID_SEND_RECORD_THRESHOLD(ResponseCodeEnum.INVALID_SEND_RECORD_THRESHOLD),
    ACCOUNT_IS_NOT_GENESIS_ACCOUNT(ResponseCodeEnum.ACCOUNT_IS_NOT_GENESIS_ACCOUNT),
    PAYER_ACCOUNT_UNAUTHORIZED(ResponseCodeEnum.PAYER_ACCOUNT_UNAUTHORIZED),
    INVALID_FREEZE_TRANSACTION_BODY(ResponseCodeEnum.INVALID_FREEZE_TRANSACTION_BODY),
    FREEZE_TRANSACTION_BODY_NOT_FOUND(ResponseCodeEnum.FREEZE_TRANSACTION_BODY_NOT_FOUND),
    TRANSFER_LIST_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.TRANSFER_LIST_SIZE_LIMIT_EXCEEDED),
    RESULT_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.RESULT_SIZE_LIMIT_EXCEEDED),
    NOT_SPECIAL_ACCOUNT(ResponseCodeEnum.NOT_SPECIAL_ACCOUNT),
    CONTRACT_NEGATIVE_GAS(ResponseCodeEnum.CONTRACT_NEGATIVE_GAS),
    CONTRACT_NEGATIVE_VALUE(ResponseCodeEnum.CONTRACT_NEGATIVE_VALUE),
    INVALID_FEE_FILE(ResponseCodeEnum.INVALID_FEE_FILE),
    INVALID_EXCHANGE_RATE_FILE(ResponseCodeEnum.INVALID_EXCHANGE_RATE_FILE),
    INSUFFICIENT_LOCAL_CALL_GAS(ResponseCodeEnum.INSUFFICIENT_LOCAL_CALL_GAS),
    ENTITY_NOT_ALLOWED_TO_DELETE(ResponseCodeEnum.ENTITY_NOT_ALLOWED_TO_DELETE),
    AUTHORIZATION_FAILED(ResponseCodeEnum.AUTHORIZATION_FAILED),
    FILE_UPLOADED_PROTO_INVALID(ResponseCodeEnum.FILE_UPLOADED_PROTO_INVALID),
    FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK(ResponseCodeEnum.FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK),
    FEE_SCHEDULE_FILE_PART_UPLOADED(ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED),
    EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED(ResponseCodeEnum.EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED),
    MAX_CONTRACT_STORAGE_EXCEEDED(ResponseCodeEnum.MAX_CONTRACT_STORAGE_EXCEEDED),
    TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT(ResponseCodeEnum.TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT),
    TOTAL_LEDGER_BALANCE_INVALID(ResponseCodeEnum.TOTAL_LEDGER_BALANCE_INVALID),
    EXPIRATION_REDUCTION_NOT_ALLOWED(ResponseCodeEnum.EXPIRATION_REDUCTION_NOT_ALLOWED),
    MAX_GAS_LIMIT_EXCEEDED(ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED),
    MAX_FILE_SIZE_EXCEEDED(ResponseCodeEnum.MAX_FILE_SIZE_EXCEEDED),
    RECEIVER_SIG_REQUIRED(ResponseCodeEnum.RECEIVER_SIG_REQUIRED),
    INVALID_TOPIC_ID(ResponseCodeEnum.INVALID_TOPIC_ID),
    INVALID_ADMIN_KEY(ResponseCodeEnum.INVALID_ADMIN_KEY),
    INVALID_SUBMIT_KEY(ResponseCodeEnum.INVALID_SUBMIT_KEY),
    UNAUTHORIZED(ResponseCodeEnum.UNAUTHORIZED),
    INVALID_TOPIC_MESSAGE(ResponseCodeEnum.INVALID_TOPIC_MESSAGE),
    INVALID_AUTORENEW_ACCOUNT(ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT),
    AUTORENEW_ACCOUNT_NOT_ALLOWED(ResponseCodeEnum.AUTORENEW_ACCOUNT_NOT_ALLOWED),
    TOPIC_EXPIRED(ResponseCodeEnum.TOPIC_EXPIRED),
    INVALID_CHUNK_NUMBER(ResponseCodeEnum.INVALID_CHUNK_NUMBER),
    INVALID_CHUNK_TRANSACTION_ID(ResponseCodeEnum.INVALID_CHUNK_TRANSACTION_ID),
    ACCOUNT_FROZEN_FOR_TOKEN(ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN),
    TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED(ResponseCodeEnum.TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED),
    INVALID_TOKEN_ID(ResponseCodeEnum.INVALID_TOKEN_ID),
    INVALID_TOKEN_DECIMALS(ResponseCodeEnum.INVALID_TOKEN_DECIMALS),
    INVALID_TOKEN_INITIAL_SUPPLY(ResponseCodeEnum.INVALID_TOKEN_INITIAL_SUPPLY),
    INVALID_TREASURY_ACCOUNT_FOR_TOKEN(ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN),
    INVALID_TOKEN_SYMBOL(ResponseCodeEnum.INVALID_TOKEN_SYMBOL),
    TOKEN_HAS_NO_FREEZE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY),
    TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN(ResponseCodeEnum.TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN),
    MISSING_TOKEN_SYMBOL(ResponseCodeEnum.MISSING_TOKEN_SYMBOL),
    TOKEN_SYMBOL_TOO_LONG(ResponseCodeEnum.TOKEN_SYMBOL_TOO_LONG),
    ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN(ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN),
    TOKEN_HAS_NO_KYC_KEY(ResponseCodeEnum.TOKEN_HAS_NO_KYC_KEY),
    INSUFFICIENT_TOKEN_BALANCE(ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE),
    TOKEN_WAS_DELETED(ResponseCodeEnum.TOKEN_WAS_DELETED),
    TOKEN_HAS_NO_SUPPLY_KEY(ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY),
    TOKEN_HAS_NO_WIPE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_WIPE_KEY),
    INVALID_TOKEN_MINT_AMOUNT(ResponseCodeEnum.INVALID_TOKEN_MINT_AMOUNT),
    INVALID_TOKEN_BURN_AMOUNT(ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT),
    TOKEN_NOT_ASSOCIATED_TO_ACCOUNT(ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT),
    CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT(ResponseCodeEnum.CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT),
    INVALID_KYC_KEY(ResponseCodeEnum.INVALID_KYC_KEY),
    INVALID_WIPE_KEY(ResponseCodeEnum.INVALID_WIPE_KEY),
    INVALID_FREEZE_KEY(ResponseCodeEnum.INVALID_FREEZE_KEY),
    INVALID_SUPPLY_KEY(ResponseCodeEnum.INVALID_SUPPLY_KEY),
    MISSING_TOKEN_NAME(ResponseCodeEnum.MISSING_TOKEN_NAME),
    TOKEN_NAME_TOO_LONG(ResponseCodeEnum.TOKEN_NAME_TOO_LONG),
    INVALID_WIPING_AMOUNT(ResponseCodeEnum.INVALID_WIPING_AMOUNT),
    TOKEN_IS_IMMUTABLE(ResponseCodeEnum.TOKEN_IS_IMMUTABLE),
    TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT(ResponseCodeEnum.TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT),
    TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES(ResponseCodeEnum.TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES),
    ACCOUNT_IS_TREASURY(ResponseCodeEnum.ACCOUNT_IS_TREASURY),
    TOKEN_ID_REPEATED_IN_TOKEN_LIST(ResponseCodeEnum.TOKEN_ID_REPEATED_IN_TOKEN_LIST),
    TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED),
    EMPTY_TOKEN_TRANSFER_BODY(ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_BODY),
    EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS(ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS),
    INVALID_SCHEDULE_ID(ResponseCodeEnum.INVALID_SCHEDULE_ID),
    SCHEDULE_IS_IMMUTABLE(ResponseCodeEnum.SCHEDULE_IS_IMMUTABLE),
    INVALID_SCHEDULE_PAYER_ID(ResponseCodeEnum.INVALID_SCHEDULE_PAYER_ID),
    INVALID_SCHEDULE_ACCOUNT_ID(ResponseCodeEnum.INVALID_SCHEDULE_ACCOUNT_ID),
    NO_NEW_VALID_SIGNATURES(ResponseCodeEnum.NO_NEW_VALID_SIGNATURES),
    UNRESOLVABLE_REQUIRED_SIGNERS(ResponseCodeEnum.UNRESOLVABLE_REQUIRED_SIGNERS),
    SCHEDULED_TRANSACTION_NOT_IN_WHITELIST(ResponseCodeEnum.SCHEDULED_TRANSACTION_NOT_IN_WHITELIST),
    SOME_SIGNATURES_WERE_INVALID(ResponseCodeEnum.SOME_SIGNATURES_WERE_INVALID),
    TRANSACTION_ID_FIELD_NOT_ALLOWED(ResponseCodeEnum.TRANSACTION_ID_FIELD_NOT_ALLOWED),
    IDENTICAL_SCHEDULE_ALREADY_CREATED(ResponseCodeEnum.IDENTICAL_SCHEDULE_ALREADY_CREATED),
    INVALID_ZERO_BYTE_IN_STRING(ResponseCodeEnum.INVALID_ZERO_BYTE_IN_STRING),
    SCHEDULE_ALREADY_DELETED(ResponseCodeEnum.SCHEDULE_ALREADY_DELETED),
    SCHEDULE_ALREADY_EXECUTED(ResponseCodeEnum.SCHEDULE_ALREADY_EXECUTED),
    MESSAGE_SIZE_TOO_LARGE(ResponseCodeEnum.MESSAGE_SIZE_TOO_LARGE),
    OPERATION_REPEATED_IN_BUCKET_GROUPS(ResponseCodeEnum.OPERATION_REPEATED_IN_BUCKET_GROUPS),
    BUCKET_CAPACITY_OVERFLOW(ResponseCodeEnum.BUCKET_CAPACITY_OVERFLOW),
    NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION(ResponseCodeEnum.NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION),
    BUCKET_HAS_NO_THROTTLE_GROUPS(ResponseCodeEnum.BUCKET_HAS_NO_THROTTLE_GROUPS),
    THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC(ResponseCodeEnum.THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC),
    SUCCESS_BUT_MISSING_EXPECTED_OPERATION(ResponseCodeEnum.SUCCESS_BUT_MISSING_EXPECTED_OPERATION),
    UNPARSEABLE_THROTTLE_DEFINITIONS(ResponseCodeEnum.UNPARSEABLE_THROTTLE_DEFINITIONS),
    INVALID_THROTTLE_DEFINITIONS(ResponseCodeEnum.INVALID_THROTTLE_DEFINITIONS),
    ACCOUNT_EXPIRED_AND_PENDING_REMOVAL(ResponseCodeEnum.ACCOUNT_EXPIRED_AND_PENDING_REMOVAL),
    INVALID_TOKEN_MAX_SUPPLY(ResponseCodeEnum.INVALID_TOKEN_MAX_SUPPLY),
    INVALID_TOKEN_NFT_SERIAL_NUMBER(ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER),
    INVALID_NFT_ID(ResponseCodeEnum.INVALID_NFT_ID),
    METADATA_TOO_LONG(ResponseCodeEnum.METADATA_TOO_LONG),
    BATCH_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED),
    INVALID_QUERY_RANGE(ResponseCodeEnum.INVALID_QUERY_RANGE),
    FRACTION_DIVIDES_BY_ZERO(ResponseCodeEnum.FRACTION_DIVIDES_BY_ZERO),
    INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE),
    CUSTOM_FEES_LIST_TOO_LONG(ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG),
    INVALID_CUSTOM_FEE_COLLECTOR(ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR),
    INVALID_TOKEN_ID_IN_CUSTOM_FEES(ResponseCodeEnum.INVALID_TOKEN_ID_IN_CUSTOM_FEES),
    TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR(ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR),
    TOKEN_MAX_SUPPLY_REACHED(ResponseCodeEnum.TOKEN_MAX_SUPPLY_REACHED),
    SENDER_DOES_NOT_OWN_NFT_SERIAL_NO(ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO),
    CUSTOM_FEE_NOT_FULLY_SPECIFIED(ResponseCodeEnum.CUSTOM_FEE_NOT_FULLY_SPECIFIED),
    CUSTOM_FEE_MUST_BE_POSITIVE(ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE),
    TOKEN_HAS_NO_FEE_SCHEDULE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_FEE_SCHEDULE_KEY),
    CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE),
    ROYALTY_FRACTION_CANNOT_EXCEED_ONE(ResponseCodeEnum.ROYALTY_FRACTION_CANNOT_EXCEED_ONE),
    FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT(ResponseCodeEnum.FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT),
    CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES(ResponseCodeEnum.CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES),
    CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON(ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON),
    CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON(ResponseCodeEnum.CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON),
    INVALID_CUSTOM_FEE_SCHEDULE_KEY(ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY),
    INVALID_TOKEN_MINT_METADATA(ResponseCodeEnum.INVALID_TOKEN_MINT_METADATA),
    INVALID_TOKEN_BURN_METADATA(ResponseCodeEnum.INVALID_TOKEN_BURN_METADATA),
    CURRENT_TREASURY_STILL_OWNS_NFTS(ResponseCodeEnum.CURRENT_TREASURY_STILL_OWNS_NFTS),
    ACCOUNT_STILL_OWNS_NFTS(ResponseCodeEnum.ACCOUNT_STILL_OWNS_NFTS),
    TREASURY_MUST_OWN_BURNED_NFT(ResponseCodeEnum.TREASURY_MUST_OWN_BURNED_NFT),
    ACCOUNT_DOES_NOT_OWN_WIPED_NFT(ResponseCodeEnum.ACCOUNT_DOES_NOT_OWN_WIPED_NFT),
    ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON(ResponseCodeEnum.ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON),
    MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED(ResponseCodeEnum.MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED),
    PAYER_ACCOUNT_DELETED(ResponseCodeEnum.PAYER_ACCOUNT_DELETED),
    CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH(ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH),
    CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS(ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS),
    INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE),
    SERIAL_NUMBER_LIMIT_REACHED(ResponseCodeEnum.SERIAL_NUMBER_LIMIT_REACHED),
    CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE(ResponseCodeEnum.CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE),
    NO_REMAINING_AUTOMATIC_ASSOCIATIONS(ResponseCodeEnum.NO_REMAINING_AUTOMATIC_ASSOCIATIONS),
    EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT(ResponseCodeEnum.EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT),
    REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT(ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT),
    TOKEN_IS_PAUSED(ResponseCodeEnum.TOKEN_IS_PAUSED),
    TOKEN_HAS_NO_PAUSE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_PAUSE_KEY),
    INVALID_PAUSE_KEY(ResponseCodeEnum.INVALID_PAUSE_KEY),
    FREEZE_UPDATE_FILE_DOES_NOT_EXIST(ResponseCodeEnum.FREEZE_UPDATE_FILE_DOES_NOT_EXIST),
    FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH(ResponseCodeEnum.FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH),
    NO_UPGRADE_HAS_BEEN_PREPARED(ResponseCodeEnum.NO_UPGRADE_HAS_BEEN_PREPARED),
    NO_FREEZE_IS_SCHEDULED(ResponseCodeEnum.NO_FREEZE_IS_SCHEDULED),
    UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE(ResponseCodeEnum.UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE),
    FREEZE_START_TIME_MUST_BE_FUTURE(ResponseCodeEnum.FREEZE_START_TIME_MUST_BE_FUTURE),
    PREPARED_UPDATE_FILE_IS_IMMUTABLE(ResponseCodeEnum.PREPARED_UPDATE_FILE_IS_IMMUTABLE),
    FREEZE_ALREADY_SCHEDULED(ResponseCodeEnum.FREEZE_ALREADY_SCHEDULED),
    FREEZE_UPGRADE_IN_PROGRESS(ResponseCodeEnum.FREEZE_UPGRADE_IN_PROGRESS),
    UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED(ResponseCodeEnum.UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED),
    UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED(ResponseCodeEnum.UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED),
    CONSENSUS_GAS_EXHAUSTED(ResponseCodeEnum.CONSENSUS_GAS_EXHAUSTED),
    REVERTED_SUCCESS(ResponseCodeEnum.REVERTED_SUCCESS),
    MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED(ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED),
    INVALID_ALIAS_KEY(ResponseCodeEnum.INVALID_ALIAS_KEY),
    UNEXPECTED_TOKEN_DECIMALS(ResponseCodeEnum.UNEXPECTED_TOKEN_DECIMALS),
    INVALID_PROXY_ACCOUNT_ID(ResponseCodeEnum.INVALID_PROXY_ACCOUNT_ID),
    INVALID_TRANSFER_ACCOUNT_ID(ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID),
    INVALID_FEE_COLLECTOR_ACCOUNT_ID(ResponseCodeEnum.INVALID_FEE_COLLECTOR_ACCOUNT_ID),
    ALIAS_IS_IMMUTABLE(ResponseCodeEnum.ALIAS_IS_IMMUTABLE),
    SPENDER_ACCOUNT_SAME_AS_OWNER(ResponseCodeEnum.SPENDER_ACCOUNT_SAME_AS_OWNER),
    AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY(ResponseCodeEnum.AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY),
    NEGATIVE_ALLOWANCE_AMOUNT(ResponseCodeEnum.NEGATIVE_ALLOWANCE_AMOUNT),
    CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON(ResponseCodeEnum.CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON),
    SPENDER_DOES_NOT_HAVE_ALLOWANCE(ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE),
    AMOUNT_EXCEEDS_ALLOWANCE(ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE),
    MAX_ALLOWANCES_EXCEEDED(ResponseCodeEnum.MAX_ALLOWANCES_EXCEEDED),
    EMPTY_ALLOWANCES(ResponseCodeEnum.EMPTY_ALLOWANCES),
    SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES(ResponseCodeEnum.SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES),
    REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES(ResponseCodeEnum.REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES),
    FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES(ResponseCodeEnum.FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES),
    NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES(ResponseCodeEnum.NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES),
    INVALID_ALLOWANCE_OWNER_ID(ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID),
    INVALID_ALLOWANCE_SPENDER_ID(ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID),
    REPEATED_ALLOWANCES_TO_DELETE(ResponseCodeEnum.REPEATED_ALLOWANCES_TO_DELETE),
    INVALID_DELEGATING_SPENDER(ResponseCodeEnum.INVALID_DELEGATING_SPENDER),
    DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL(ResponseCodeEnum.DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL),
    DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL(ResponseCodeEnum.DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL),
    SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE(ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE),
    SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME(ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME),
    SCHEDULE_FUTURE_THROTTLE_EXCEEDED(ResponseCodeEnum.SCHEDULE_FUTURE_THROTTLE_EXCEEDED),
    SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED(ResponseCodeEnum.SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED),
    INVALID_ETHEREUM_TRANSACTION(ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION),
    WRONG_CHAIN_ID(ResponseCodeEnum.WRONG_CHAIN_ID),
    WRONG_NONCE(ResponseCodeEnum.WRONG_NONCE),
    ACCESS_LIST_UNSUPPORTED(ResponseCodeEnum.ACCESS_LIST_UNSUPPORTED),
    SCHEDULE_PENDING_EXPIRATION(ResponseCodeEnum.SCHEDULE_PENDING_EXPIRATION),
    CONTRACT_IS_TOKEN_TREASURY(ResponseCodeEnum.CONTRACT_IS_TOKEN_TREASURY),
    CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES(ResponseCodeEnum.CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES),
    CONTRACT_EXPIRED_AND_PENDING_REMOVAL(ResponseCodeEnum.CONTRACT_EXPIRED_AND_PENDING_REMOVAL),
    CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT(ResponseCodeEnum.CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT),
    PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION(ResponseCodeEnum.PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION),
    PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED(ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED),
    SELF_STAKING_IS_NOT_ALLOWED(ResponseCodeEnum.SELF_STAKING_IS_NOT_ALLOWED),
    INVALID_STAKING_ID(ResponseCodeEnum.INVALID_STAKING_ID),
    STAKING_NOT_ENABLED(ResponseCodeEnum.STAKING_NOT_ENABLED),
    INVALID_PRNG_RANGE(ResponseCodeEnum.INVALID_PRNG_RANGE),
    MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED(ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED),
    INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE(ResponseCodeEnum.INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE),
    INSUFFICIENT_BALANCES_FOR_STORAGE_RENT(ResponseCodeEnum.INSUFFICIENT_BALANCES_FOR_STORAGE_RENT),
    MAX_CHILD_RECORDS_EXCEEDED(ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED),
    INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES(ResponseCodeEnum.INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES),
    TRANSACTION_HAS_UNKNOWN_FIELDS(ResponseCodeEnum.TRANSACTION_HAS_UNKNOWN_FIELDS),
    ACCOUNT_IS_IMMUTABLE(ResponseCodeEnum.ACCOUNT_IS_IMMUTABLE),
    ALIAS_ALREADY_ASSIGNED(ResponseCodeEnum.ALIAS_ALREADY_ASSIGNED),
    INVALID_METADATA_KEY(ResponseCodeEnum.INVALID_METADATA_KEY),
    TOKEN_HAS_NO_METADATA_KEY(ResponseCodeEnum.TOKEN_HAS_NO_METADATA_KEY),
    MISSING_TOKEN_METADATA(ResponseCodeEnum.MISSING_TOKEN_METADATA),
    MISSING_SERIAL_NUMBERS(ResponseCodeEnum.MISSING_SERIAL_NUMBERS),
    TOKEN_HAS_NO_ADMIN_KEY(ResponseCodeEnum.TOKEN_HAS_NO_ADMIN_KEY),
    NODE_DELETED(ResponseCodeEnum.NODE_DELETED),
    INVALID_NODE_ID(ResponseCodeEnum.INVALID_NODE_ID),
    INVALID_GOSSIP_ENDPOINT(ResponseCodeEnum.INVALID_GOSSIP_ENDPOINT),
    INVALID_NODE_ACCOUNT_ID(ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID),
    INVALID_NODE_DESCRIPTION(ResponseCodeEnum.INVALID_NODE_DESCRIPTION),
    INVALID_SERVICE_ENDPOINT(ResponseCodeEnum.INVALID_SERVICE_ENDPOINT),
    INVALID_GOSSIP_CA_CERTIFICATE(ResponseCodeEnum.INVALID_GOSSIP_CA_CERTIFICATE),
    INVALID_GRPC_CERTIFICATE(ResponseCodeEnum.INVALID_GRPC_CERTIFICATE),
    INVALID_MAX_AUTO_ASSOCIATIONS(ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS),
    MAX_NODES_CREATED(ResponseCodeEnum.MAX_NODES_CREATED),
    IP_FQDN_CANNOT_BE_SET_FOR_SAME_ENDPOINT(ResponseCodeEnum.IP_FQDN_CANNOT_BE_SET_FOR_SAME_ENDPOINT),
    GOSSIP_ENDPOINT_CANNOT_HAVE_FQDN(ResponseCodeEnum.GOSSIP_ENDPOINT_CANNOT_HAVE_FQDN),
    FQDN_SIZE_TOO_LARGE(ResponseCodeEnum.FQDN_SIZE_TOO_LARGE),
    INVALID_ENDPOINT(ResponseCodeEnum.INVALID_ENDPOINT),
    GOSSIP_ENDPOINTS_EXCEEDED_LIMIT(ResponseCodeEnum.GOSSIP_ENDPOINTS_EXCEEDED_LIMIT),
    TOKEN_REFERENCE_REPEATED(ResponseCodeEnum.TOKEN_REFERENCE_REPEATED),
    INVALID_OWNER_ID(ResponseCodeEnum.INVALID_OWNER_ID),
    TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED),
    SERVICE_ENDPOINTS_EXCEEDED_LIMIT(ResponseCodeEnum.SERVICE_ENDPOINTS_EXCEEDED_LIMIT),
    INVALID_IPV4_ADDRESS(ResponseCodeEnum.INVALID_IPV4_ADDRESS),
    EMPTY_TOKEN_REFERENCE_LIST(ResponseCodeEnum.EMPTY_TOKEN_REFERENCE_LIST),
    UPDATE_NODE_ACCOUNT_NOT_ALLOWED(ResponseCodeEnum.UPDATE_NODE_ACCOUNT_NOT_ALLOWED);

    final ResponseCodeEnum code;

    private Status(ResponseCodeEnum code) {
        this.code = code;
    }

    static Status valueOf(ResponseCodeEnum code) {
        return switch (code) {
            default -> throw new IncompatibleClassChangeError();
            case ResponseCodeEnum.OK -> OK;
            case ResponseCodeEnum.INVALID_TRANSACTION -> INVALID_TRANSACTION;
            case ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND -> PAYER_ACCOUNT_NOT_FOUND;
            case ResponseCodeEnum.INVALID_NODE_ACCOUNT -> INVALID_NODE_ACCOUNT;
            case ResponseCodeEnum.TRANSACTION_EXPIRED -> TRANSACTION_EXPIRED;
            case ResponseCodeEnum.INVALID_TRANSACTION_START -> INVALID_TRANSACTION_START;
            case ResponseCodeEnum.INVALID_TRANSACTION_DURATION -> INVALID_TRANSACTION_DURATION;
            case ResponseCodeEnum.INVALID_SIGNATURE -> INVALID_SIGNATURE;
            case ResponseCodeEnum.MEMO_TOO_LONG -> MEMO_TOO_LONG;
            case ResponseCodeEnum.INSUFFICIENT_TX_FEE -> INSUFFICIENT_TX_FEE;
            case ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE -> INSUFFICIENT_PAYER_BALANCE;
            case ResponseCodeEnum.DUPLICATE_TRANSACTION -> DUPLICATE_TRANSACTION;
            case ResponseCodeEnum.BUSY -> BUSY;
            case ResponseCodeEnum.NOT_SUPPORTED -> NOT_SUPPORTED;
            case ResponseCodeEnum.INVALID_FILE_ID -> INVALID_FILE_ID;
            case ResponseCodeEnum.INVALID_ACCOUNT_ID -> INVALID_ACCOUNT_ID;
            case ResponseCodeEnum.INVALID_CONTRACT_ID -> INVALID_CONTRACT_ID;
            case ResponseCodeEnum.INVALID_TRANSACTION_ID -> INVALID_TRANSACTION_ID;
            case ResponseCodeEnum.RECEIPT_NOT_FOUND -> RECEIPT_NOT_FOUND;
            case ResponseCodeEnum.RECORD_NOT_FOUND -> RECORD_NOT_FOUND;
            case ResponseCodeEnum.INVALID_SOLIDITY_ID -> INVALID_SOLIDITY_ID;
            case ResponseCodeEnum.UNKNOWN -> UNKNOWN;
            case ResponseCodeEnum.SUCCESS -> SUCCESS;
            case ResponseCodeEnum.FAIL_INVALID -> FAIL_INVALID;
            case ResponseCodeEnum.FAIL_FEE -> FAIL_FEE;
            case ResponseCodeEnum.FAIL_BALANCE -> FAIL_BALANCE;
            case ResponseCodeEnum.KEY_REQUIRED -> KEY_REQUIRED;
            case ResponseCodeEnum.BAD_ENCODING -> BAD_ENCODING;
            case ResponseCodeEnum.INSUFFICIENT_ACCOUNT_BALANCE -> INSUFFICIENT_ACCOUNT_BALANCE;
            case ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS -> INVALID_SOLIDITY_ADDRESS;
            case ResponseCodeEnum.INSUFFICIENT_GAS -> INSUFFICIENT_GAS;
            case ResponseCodeEnum.CONTRACT_SIZE_LIMIT_EXCEEDED -> CONTRACT_SIZE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.LOCAL_CALL_MODIFICATION_EXCEPTION -> LOCAL_CALL_MODIFICATION_EXCEPTION;
            case ResponseCodeEnum.CONTRACT_REVERT_EXECUTED -> CONTRACT_REVERT_EXECUTED;
            case ResponseCodeEnum.CONTRACT_EXECUTION_EXCEPTION -> CONTRACT_EXECUTION_EXCEPTION;
            case ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT -> INVALID_RECEIVING_NODE_ACCOUNT;
            case ResponseCodeEnum.MISSING_QUERY_HEADER -> MISSING_QUERY_HEADER;
            case ResponseCodeEnum.ACCOUNT_UPDATE_FAILED -> ACCOUNT_UPDATE_FAILED;
            case ResponseCodeEnum.INVALID_KEY_ENCODING -> INVALID_KEY_ENCODING;
            case ResponseCodeEnum.NULL_SOLIDITY_ADDRESS -> NULL_SOLIDITY_ADDRESS;
            case ResponseCodeEnum.CONTRACT_UPDATE_FAILED -> CONTRACT_UPDATE_FAILED;
            case ResponseCodeEnum.INVALID_QUERY_HEADER -> INVALID_QUERY_HEADER;
            case ResponseCodeEnum.INVALID_FEE_SUBMITTED -> INVALID_FEE_SUBMITTED;
            case ResponseCodeEnum.INVALID_PAYER_SIGNATURE -> INVALID_PAYER_SIGNATURE;
            case ResponseCodeEnum.KEY_NOT_PROVIDED -> KEY_NOT_PROVIDED;
            case ResponseCodeEnum.INVALID_EXPIRATION_TIME -> INVALID_EXPIRATION_TIME;
            case ResponseCodeEnum.NO_WACL_KEY -> NO_WACL_KEY;
            case ResponseCodeEnum.FILE_CONTENT_EMPTY -> FILE_CONTENT_EMPTY;
            case ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS -> INVALID_ACCOUNT_AMOUNTS;
            case ResponseCodeEnum.EMPTY_TRANSACTION_BODY -> EMPTY_TRANSACTION_BODY;
            case ResponseCodeEnum.INVALID_TRANSACTION_BODY -> INVALID_TRANSACTION_BODY;
            case ResponseCodeEnum.INVALID_SIGNATURE_TYPE_MISMATCHING_KEY -> INVALID_SIGNATURE_TYPE_MISMATCHING_KEY;
            case ResponseCodeEnum.INVALID_SIGNATURE_COUNT_MISMATCHING_KEY -> INVALID_SIGNATURE_COUNT_MISMATCHING_KEY;
            case ResponseCodeEnum.EMPTY_LIVE_HASH_BODY -> EMPTY_LIVE_HASH_BODY;
            case ResponseCodeEnum.EMPTY_LIVE_HASH -> EMPTY_LIVE_HASH;
            case ResponseCodeEnum.EMPTY_LIVE_HASH_KEYS -> EMPTY_LIVE_HASH_KEYS;
            case ResponseCodeEnum.INVALID_LIVE_HASH_SIZE -> INVALID_LIVE_HASH_SIZE;
            case ResponseCodeEnum.EMPTY_QUERY_BODY -> EMPTY_QUERY_BODY;
            case ResponseCodeEnum.EMPTY_LIVE_HASH_QUERY -> EMPTY_LIVE_HASH_QUERY;
            case ResponseCodeEnum.LIVE_HASH_NOT_FOUND -> LIVE_HASH_NOT_FOUND;
            case ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST -> ACCOUNT_ID_DOES_NOT_EXIST;
            case ResponseCodeEnum.LIVE_HASH_ALREADY_EXISTS -> LIVE_HASH_ALREADY_EXISTS;
            case ResponseCodeEnum.INVALID_FILE_WACL -> INVALID_FILE_WACL;
            case ResponseCodeEnum.SERIALIZATION_FAILED -> SERIALIZATION_FAILED;
            case ResponseCodeEnum.TRANSACTION_OVERSIZE -> TRANSACTION_OVERSIZE;
            case ResponseCodeEnum.TRANSACTION_TOO_MANY_LAYERS -> TRANSACTION_TOO_MANY_LAYERS;
            case ResponseCodeEnum.CONTRACT_DELETED -> CONTRACT_DELETED;
            case ResponseCodeEnum.PLATFORM_NOT_ACTIVE -> PLATFORM_NOT_ACTIVE;
            case ResponseCodeEnum.KEY_PREFIX_MISMATCH -> KEY_PREFIX_MISMATCH;
            case ResponseCodeEnum.PLATFORM_TRANSACTION_NOT_CREATED -> PLATFORM_TRANSACTION_NOT_CREATED;
            case ResponseCodeEnum.INVALID_RENEWAL_PERIOD -> INVALID_RENEWAL_PERIOD;
            case ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID -> INVALID_PAYER_ACCOUNT_ID;
            case ResponseCodeEnum.ACCOUNT_DELETED -> ACCOUNT_DELETED;
            case ResponseCodeEnum.FILE_DELETED -> FILE_DELETED;
            case ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS -> ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS;
            case ResponseCodeEnum.SETTING_NEGATIVE_ACCOUNT_BALANCE -> SETTING_NEGATIVE_ACCOUNT_BALANCE;
            case ResponseCodeEnum.OBTAINER_REQUIRED -> OBTAINER_REQUIRED;
            case ResponseCodeEnum.OBTAINER_SAME_CONTRACT_ID -> OBTAINER_SAME_CONTRACT_ID;
            case ResponseCodeEnum.OBTAINER_DOES_NOT_EXIST -> OBTAINER_DOES_NOT_EXIST;
            case ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT -> MODIFYING_IMMUTABLE_CONTRACT;
            case ResponseCodeEnum.FILE_SYSTEM_EXCEPTION -> FILE_SYSTEM_EXCEPTION;
            case ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE -> AUTORENEW_DURATION_NOT_IN_RANGE;
            case ResponseCodeEnum.ERROR_DECODING_BYTESTRING -> ERROR_DECODING_BYTESTRING;
            case ResponseCodeEnum.CONTRACT_FILE_EMPTY -> CONTRACT_FILE_EMPTY;
            case ResponseCodeEnum.CONTRACT_BYTECODE_EMPTY -> CONTRACT_BYTECODE_EMPTY;
            case ResponseCodeEnum.INVALID_INITIAL_BALANCE -> INVALID_INITIAL_BALANCE;
            case ResponseCodeEnum.INVALID_RECEIVE_RECORD_THRESHOLD -> INVALID_RECEIVE_RECORD_THRESHOLD;
            case ResponseCodeEnum.INVALID_SEND_RECORD_THRESHOLD -> INVALID_SEND_RECORD_THRESHOLD;
            case ResponseCodeEnum.ACCOUNT_IS_NOT_GENESIS_ACCOUNT -> ACCOUNT_IS_NOT_GENESIS_ACCOUNT;
            case ResponseCodeEnum.PAYER_ACCOUNT_UNAUTHORIZED -> PAYER_ACCOUNT_UNAUTHORIZED;
            case ResponseCodeEnum.INVALID_FREEZE_TRANSACTION_BODY -> INVALID_FREEZE_TRANSACTION_BODY;
            case ResponseCodeEnum.FREEZE_TRANSACTION_BODY_NOT_FOUND -> FREEZE_TRANSACTION_BODY_NOT_FOUND;
            case ResponseCodeEnum.TRANSFER_LIST_SIZE_LIMIT_EXCEEDED -> TRANSFER_LIST_SIZE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.RESULT_SIZE_LIMIT_EXCEEDED -> RESULT_SIZE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.NOT_SPECIAL_ACCOUNT -> NOT_SPECIAL_ACCOUNT;
            case ResponseCodeEnum.CONTRACT_NEGATIVE_GAS -> CONTRACT_NEGATIVE_GAS;
            case ResponseCodeEnum.CONTRACT_NEGATIVE_VALUE -> CONTRACT_NEGATIVE_VALUE;
            case ResponseCodeEnum.INVALID_FEE_FILE -> INVALID_FEE_FILE;
            case ResponseCodeEnum.INVALID_EXCHANGE_RATE_FILE -> INVALID_EXCHANGE_RATE_FILE;
            case ResponseCodeEnum.INSUFFICIENT_LOCAL_CALL_GAS -> INSUFFICIENT_LOCAL_CALL_GAS;
            case ResponseCodeEnum.ENTITY_NOT_ALLOWED_TO_DELETE -> ENTITY_NOT_ALLOWED_TO_DELETE;
            case ResponseCodeEnum.AUTHORIZATION_FAILED -> AUTHORIZATION_FAILED;
            case ResponseCodeEnum.FILE_UPLOADED_PROTO_INVALID -> FILE_UPLOADED_PROTO_INVALID;
            case ResponseCodeEnum.FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK -> FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK;
            case ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED -> FEE_SCHEDULE_FILE_PART_UPLOADED;
            case ResponseCodeEnum.EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED -> EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.MAX_CONTRACT_STORAGE_EXCEEDED -> MAX_CONTRACT_STORAGE_EXCEEDED;
            case ResponseCodeEnum.TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT -> TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT;
            case ResponseCodeEnum.TOTAL_LEDGER_BALANCE_INVALID -> TOTAL_LEDGER_BALANCE_INVALID;
            case ResponseCodeEnum.EXPIRATION_REDUCTION_NOT_ALLOWED -> EXPIRATION_REDUCTION_NOT_ALLOWED;
            case ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED -> MAX_GAS_LIMIT_EXCEEDED;
            case ResponseCodeEnum.MAX_FILE_SIZE_EXCEEDED -> MAX_FILE_SIZE_EXCEEDED;
            case ResponseCodeEnum.RECEIVER_SIG_REQUIRED -> RECEIVER_SIG_REQUIRED;
            case ResponseCodeEnum.INVALID_TOPIC_ID -> INVALID_TOPIC_ID;
            case ResponseCodeEnum.INVALID_ADMIN_KEY -> INVALID_ADMIN_KEY;
            case ResponseCodeEnum.INVALID_SUBMIT_KEY -> INVALID_SUBMIT_KEY;
            case ResponseCodeEnum.UNAUTHORIZED -> UNAUTHORIZED;
            case ResponseCodeEnum.INVALID_TOPIC_MESSAGE -> INVALID_TOPIC_MESSAGE;
            case ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT -> INVALID_AUTORENEW_ACCOUNT;
            case ResponseCodeEnum.AUTORENEW_ACCOUNT_NOT_ALLOWED -> AUTORENEW_ACCOUNT_NOT_ALLOWED;
            case ResponseCodeEnum.TOPIC_EXPIRED -> TOPIC_EXPIRED;
            case ResponseCodeEnum.INVALID_CHUNK_NUMBER -> INVALID_CHUNK_NUMBER;
            case ResponseCodeEnum.INVALID_CHUNK_TRANSACTION_ID -> INVALID_CHUNK_TRANSACTION_ID;
            case ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN -> ACCOUNT_FROZEN_FOR_TOKEN;
            case ResponseCodeEnum.TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED -> TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED;
            case ResponseCodeEnum.INVALID_TOKEN_ID -> INVALID_TOKEN_ID;
            case ResponseCodeEnum.INVALID_TOKEN_DECIMALS -> INVALID_TOKEN_DECIMALS;
            case ResponseCodeEnum.INVALID_TOKEN_INITIAL_SUPPLY -> INVALID_TOKEN_INITIAL_SUPPLY;
            case ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN -> INVALID_TREASURY_ACCOUNT_FOR_TOKEN;
            case ResponseCodeEnum.INVALID_TOKEN_SYMBOL -> INVALID_TOKEN_SYMBOL;
            case ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY -> TOKEN_HAS_NO_FREEZE_KEY;
            case ResponseCodeEnum.TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN -> TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN;
            case ResponseCodeEnum.MISSING_TOKEN_SYMBOL -> MISSING_TOKEN_SYMBOL;
            case ResponseCodeEnum.TOKEN_SYMBOL_TOO_LONG -> TOKEN_SYMBOL_TOO_LONG;
            case ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN -> ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN;
            case ResponseCodeEnum.TOKEN_HAS_NO_KYC_KEY -> TOKEN_HAS_NO_KYC_KEY;
            case ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE -> INSUFFICIENT_TOKEN_BALANCE;
            case ResponseCodeEnum.TOKEN_WAS_DELETED -> TOKEN_WAS_DELETED;
            case ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY -> TOKEN_HAS_NO_SUPPLY_KEY;
            case ResponseCodeEnum.TOKEN_HAS_NO_WIPE_KEY -> TOKEN_HAS_NO_WIPE_KEY;
            case ResponseCodeEnum.INVALID_TOKEN_MINT_AMOUNT -> INVALID_TOKEN_MINT_AMOUNT;
            case ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT -> INVALID_TOKEN_BURN_AMOUNT;
            case ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT -> TOKEN_NOT_ASSOCIATED_TO_ACCOUNT;
            case ResponseCodeEnum.CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT -> CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT;
            case ResponseCodeEnum.INVALID_KYC_KEY -> INVALID_KYC_KEY;
            case ResponseCodeEnum.INVALID_WIPE_KEY -> INVALID_WIPE_KEY;
            case ResponseCodeEnum.INVALID_FREEZE_KEY -> INVALID_FREEZE_KEY;
            case ResponseCodeEnum.INVALID_SUPPLY_KEY -> INVALID_SUPPLY_KEY;
            case ResponseCodeEnum.MISSING_TOKEN_NAME -> MISSING_TOKEN_NAME;
            case ResponseCodeEnum.TOKEN_NAME_TOO_LONG -> TOKEN_NAME_TOO_LONG;
            case ResponseCodeEnum.INVALID_WIPING_AMOUNT -> INVALID_WIPING_AMOUNT;
            case ResponseCodeEnum.TOKEN_IS_IMMUTABLE -> TOKEN_IS_IMMUTABLE;
            case ResponseCodeEnum.TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT -> TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT;
            case ResponseCodeEnum.TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES -> TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES;
            case ResponseCodeEnum.ACCOUNT_IS_TREASURY -> ACCOUNT_IS_TREASURY;
            case ResponseCodeEnum.TOKEN_ID_REPEATED_IN_TOKEN_LIST -> TOKEN_ID_REPEATED_IN_TOKEN_LIST;
            case ResponseCodeEnum.TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED -> TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_BODY -> EMPTY_TOKEN_TRANSFER_BODY;
            case ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS -> EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS;
            case ResponseCodeEnum.INVALID_SCHEDULE_ID -> INVALID_SCHEDULE_ID;
            case ResponseCodeEnum.SCHEDULE_IS_IMMUTABLE -> SCHEDULE_IS_IMMUTABLE;
            case ResponseCodeEnum.INVALID_SCHEDULE_PAYER_ID -> INVALID_SCHEDULE_PAYER_ID;
            case ResponseCodeEnum.INVALID_SCHEDULE_ACCOUNT_ID -> INVALID_SCHEDULE_ACCOUNT_ID;
            case ResponseCodeEnum.NO_NEW_VALID_SIGNATURES -> NO_NEW_VALID_SIGNATURES;
            case ResponseCodeEnum.UNRESOLVABLE_REQUIRED_SIGNERS -> UNRESOLVABLE_REQUIRED_SIGNERS;
            case ResponseCodeEnum.SCHEDULED_TRANSACTION_NOT_IN_WHITELIST -> SCHEDULED_TRANSACTION_NOT_IN_WHITELIST;
            case ResponseCodeEnum.SOME_SIGNATURES_WERE_INVALID -> SOME_SIGNATURES_WERE_INVALID;
            case ResponseCodeEnum.TRANSACTION_ID_FIELD_NOT_ALLOWED -> TRANSACTION_ID_FIELD_NOT_ALLOWED;
            case ResponseCodeEnum.IDENTICAL_SCHEDULE_ALREADY_CREATED -> IDENTICAL_SCHEDULE_ALREADY_CREATED;
            case ResponseCodeEnum.INVALID_ZERO_BYTE_IN_STRING -> INVALID_ZERO_BYTE_IN_STRING;
            case ResponseCodeEnum.SCHEDULE_ALREADY_DELETED -> SCHEDULE_ALREADY_DELETED;
            case ResponseCodeEnum.SCHEDULE_ALREADY_EXECUTED -> SCHEDULE_ALREADY_EXECUTED;
            case ResponseCodeEnum.MESSAGE_SIZE_TOO_LARGE -> MESSAGE_SIZE_TOO_LARGE;
            case ResponseCodeEnum.OPERATION_REPEATED_IN_BUCKET_GROUPS -> OPERATION_REPEATED_IN_BUCKET_GROUPS;
            case ResponseCodeEnum.BUCKET_CAPACITY_OVERFLOW -> BUCKET_CAPACITY_OVERFLOW;
            case ResponseCodeEnum.NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION -> NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION;
            case ResponseCodeEnum.BUCKET_HAS_NO_THROTTLE_GROUPS -> BUCKET_HAS_NO_THROTTLE_GROUPS;
            case ResponseCodeEnum.THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC -> THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC;
            case ResponseCodeEnum.SUCCESS_BUT_MISSING_EXPECTED_OPERATION -> SUCCESS_BUT_MISSING_EXPECTED_OPERATION;
            case ResponseCodeEnum.UNPARSEABLE_THROTTLE_DEFINITIONS -> UNPARSEABLE_THROTTLE_DEFINITIONS;
            case ResponseCodeEnum.INVALID_THROTTLE_DEFINITIONS -> INVALID_THROTTLE_DEFINITIONS;
            case ResponseCodeEnum.ACCOUNT_EXPIRED_AND_PENDING_REMOVAL -> ACCOUNT_EXPIRED_AND_PENDING_REMOVAL;
            case ResponseCodeEnum.INVALID_TOKEN_MAX_SUPPLY -> INVALID_TOKEN_MAX_SUPPLY;
            case ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER -> INVALID_TOKEN_NFT_SERIAL_NUMBER;
            case ResponseCodeEnum.INVALID_NFT_ID -> INVALID_NFT_ID;
            case ResponseCodeEnum.METADATA_TOO_LONG -> METADATA_TOO_LONG;
            case ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED -> BATCH_SIZE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.INVALID_QUERY_RANGE -> INVALID_QUERY_RANGE;
            case ResponseCodeEnum.FRACTION_DIVIDES_BY_ZERO -> FRACTION_DIVIDES_BY_ZERO;
            case ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE -> INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE;
            case ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG -> CUSTOM_FEES_LIST_TOO_LONG;
            case ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR -> INVALID_CUSTOM_FEE_COLLECTOR;
            case ResponseCodeEnum.INVALID_TOKEN_ID_IN_CUSTOM_FEES -> INVALID_TOKEN_ID_IN_CUSTOM_FEES;
            case ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR -> TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR;
            case ResponseCodeEnum.TOKEN_MAX_SUPPLY_REACHED -> TOKEN_MAX_SUPPLY_REACHED;
            case ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO -> SENDER_DOES_NOT_OWN_NFT_SERIAL_NO;
            case ResponseCodeEnum.CUSTOM_FEE_NOT_FULLY_SPECIFIED -> CUSTOM_FEE_NOT_FULLY_SPECIFIED;
            case ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE -> CUSTOM_FEE_MUST_BE_POSITIVE;
            case ResponseCodeEnum.TOKEN_HAS_NO_FEE_SCHEDULE_KEY -> TOKEN_HAS_NO_FEE_SCHEDULE_KEY;
            case ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE -> CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE;
            case ResponseCodeEnum.ROYALTY_FRACTION_CANNOT_EXCEED_ONE -> ROYALTY_FRACTION_CANNOT_EXCEED_ONE;
            case ResponseCodeEnum.FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT -> FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT;
            case ResponseCodeEnum.CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES -> CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES;
            case ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON -> CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON;
            case ResponseCodeEnum.CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON -> CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON;
            case ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY -> INVALID_CUSTOM_FEE_SCHEDULE_KEY;
            case ResponseCodeEnum.INVALID_TOKEN_MINT_METADATA -> INVALID_TOKEN_MINT_METADATA;
            case ResponseCodeEnum.INVALID_TOKEN_BURN_METADATA -> INVALID_TOKEN_BURN_METADATA;
            case ResponseCodeEnum.CURRENT_TREASURY_STILL_OWNS_NFTS -> CURRENT_TREASURY_STILL_OWNS_NFTS;
            case ResponseCodeEnum.ACCOUNT_STILL_OWNS_NFTS -> ACCOUNT_STILL_OWNS_NFTS;
            case ResponseCodeEnum.TREASURY_MUST_OWN_BURNED_NFT -> TREASURY_MUST_OWN_BURNED_NFT;
            case ResponseCodeEnum.ACCOUNT_DOES_NOT_OWN_WIPED_NFT -> ACCOUNT_DOES_NOT_OWN_WIPED_NFT;
            case ResponseCodeEnum.ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON -> ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON;
            case ResponseCodeEnum.MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED -> MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED;
            case ResponseCodeEnum.PAYER_ACCOUNT_DELETED -> PAYER_ACCOUNT_DELETED;
            case ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH -> CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH;
            case ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS -> CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS;
            case ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE -> INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE;
            case ResponseCodeEnum.SERIAL_NUMBER_LIMIT_REACHED -> SERIAL_NUMBER_LIMIT_REACHED;
            case ResponseCodeEnum.CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE -> CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE;
            case ResponseCodeEnum.NO_REMAINING_AUTOMATIC_ASSOCIATIONS -> NO_REMAINING_AUTOMATIC_ASSOCIATIONS;
            case ResponseCodeEnum.EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT -> EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT;
            case ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT -> REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT;
            case ResponseCodeEnum.TOKEN_IS_PAUSED -> TOKEN_IS_PAUSED;
            case ResponseCodeEnum.TOKEN_HAS_NO_PAUSE_KEY -> TOKEN_HAS_NO_PAUSE_KEY;
            case ResponseCodeEnum.INVALID_PAUSE_KEY -> INVALID_PAUSE_KEY;
            case ResponseCodeEnum.FREEZE_UPDATE_FILE_DOES_NOT_EXIST -> FREEZE_UPDATE_FILE_DOES_NOT_EXIST;
            case ResponseCodeEnum.FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH -> FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH;
            case ResponseCodeEnum.NO_UPGRADE_HAS_BEEN_PREPARED -> NO_UPGRADE_HAS_BEEN_PREPARED;
            case ResponseCodeEnum.NO_FREEZE_IS_SCHEDULED -> NO_FREEZE_IS_SCHEDULED;
            case ResponseCodeEnum.UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE -> UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE;
            case ResponseCodeEnum.FREEZE_START_TIME_MUST_BE_FUTURE -> FREEZE_START_TIME_MUST_BE_FUTURE;
            case ResponseCodeEnum.PREPARED_UPDATE_FILE_IS_IMMUTABLE -> PREPARED_UPDATE_FILE_IS_IMMUTABLE;
            case ResponseCodeEnum.FREEZE_ALREADY_SCHEDULED -> FREEZE_ALREADY_SCHEDULED;
            case ResponseCodeEnum.FREEZE_UPGRADE_IN_PROGRESS -> FREEZE_UPGRADE_IN_PROGRESS;
            case ResponseCodeEnum.UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED -> UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED;
            case ResponseCodeEnum.UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED -> UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED;
            case ResponseCodeEnum.CONSENSUS_GAS_EXHAUSTED -> CONSENSUS_GAS_EXHAUSTED;
            case ResponseCodeEnum.REVERTED_SUCCESS -> REVERTED_SUCCESS;
            case ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED -> MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED;
            case ResponseCodeEnum.INVALID_ALIAS_KEY -> INVALID_ALIAS_KEY;
            case ResponseCodeEnum.UNEXPECTED_TOKEN_DECIMALS -> UNEXPECTED_TOKEN_DECIMALS;
            case ResponseCodeEnum.INVALID_PROXY_ACCOUNT_ID -> INVALID_PROXY_ACCOUNT_ID;
            case ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID -> INVALID_TRANSFER_ACCOUNT_ID;
            case ResponseCodeEnum.INVALID_FEE_COLLECTOR_ACCOUNT_ID -> INVALID_FEE_COLLECTOR_ACCOUNT_ID;
            case ResponseCodeEnum.ALIAS_IS_IMMUTABLE -> ALIAS_IS_IMMUTABLE;
            case ResponseCodeEnum.SPENDER_ACCOUNT_SAME_AS_OWNER -> SPENDER_ACCOUNT_SAME_AS_OWNER;
            case ResponseCodeEnum.AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY -> AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY;
            case ResponseCodeEnum.NEGATIVE_ALLOWANCE_AMOUNT -> NEGATIVE_ALLOWANCE_AMOUNT;
            case ResponseCodeEnum.CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON -> CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON;
            case ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE -> SPENDER_DOES_NOT_HAVE_ALLOWANCE;
            case ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE -> AMOUNT_EXCEEDS_ALLOWANCE;
            case ResponseCodeEnum.MAX_ALLOWANCES_EXCEEDED -> MAX_ALLOWANCES_EXCEEDED;
            case ResponseCodeEnum.EMPTY_ALLOWANCES -> EMPTY_ALLOWANCES;
            case ResponseCodeEnum.SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES -> SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES;
            case ResponseCodeEnum.REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES -> REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES;
            case ResponseCodeEnum.FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES -> FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES;
            case ResponseCodeEnum.NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES -> NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES;
            case ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID -> INVALID_ALLOWANCE_OWNER_ID;
            case ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID -> INVALID_ALLOWANCE_SPENDER_ID;
            case ResponseCodeEnum.REPEATED_ALLOWANCES_TO_DELETE -> REPEATED_ALLOWANCES_TO_DELETE;
            case ResponseCodeEnum.INVALID_DELEGATING_SPENDER -> INVALID_DELEGATING_SPENDER;
            case ResponseCodeEnum.DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL -> DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL;
            case ResponseCodeEnum.DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL -> DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL;
            case ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE -> SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE;
            case ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME -> SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME;
            case ResponseCodeEnum.SCHEDULE_FUTURE_THROTTLE_EXCEEDED -> SCHEDULE_FUTURE_THROTTLE_EXCEEDED;
            case ResponseCodeEnum.SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED -> SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED;
            case ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION -> INVALID_ETHEREUM_TRANSACTION;
            case ResponseCodeEnum.WRONG_CHAIN_ID -> WRONG_CHAIN_ID;
            case ResponseCodeEnum.WRONG_NONCE -> WRONG_NONCE;
            case ResponseCodeEnum.ACCESS_LIST_UNSUPPORTED -> ACCESS_LIST_UNSUPPORTED;
            case ResponseCodeEnum.SCHEDULE_PENDING_EXPIRATION -> SCHEDULE_PENDING_EXPIRATION;
            case ResponseCodeEnum.CONTRACT_IS_TOKEN_TREASURY -> CONTRACT_IS_TOKEN_TREASURY;
            case ResponseCodeEnum.CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES -> CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES;
            case ResponseCodeEnum.CONTRACT_EXPIRED_AND_PENDING_REMOVAL -> CONTRACT_EXPIRED_AND_PENDING_REMOVAL;
            case ResponseCodeEnum.CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT -> CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT;
            case ResponseCodeEnum.PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION -> PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION;
            case ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED -> PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED;
            case ResponseCodeEnum.SELF_STAKING_IS_NOT_ALLOWED -> SELF_STAKING_IS_NOT_ALLOWED;
            case ResponseCodeEnum.INVALID_STAKING_ID -> INVALID_STAKING_ID;
            case ResponseCodeEnum.STAKING_NOT_ENABLED -> STAKING_NOT_ENABLED;
            case ResponseCodeEnum.INVALID_PRNG_RANGE -> INVALID_PRNG_RANGE;
            case ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED -> MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED;
            case ResponseCodeEnum.INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE -> INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE;
            case ResponseCodeEnum.INSUFFICIENT_BALANCES_FOR_STORAGE_RENT -> INSUFFICIENT_BALANCES_FOR_STORAGE_RENT;
            case ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED -> MAX_CHILD_RECORDS_EXCEEDED;
            case ResponseCodeEnum.INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES -> INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES;
            case ResponseCodeEnum.TRANSACTION_HAS_UNKNOWN_FIELDS -> TRANSACTION_HAS_UNKNOWN_FIELDS;
            case ResponseCodeEnum.ACCOUNT_IS_IMMUTABLE -> ACCOUNT_IS_IMMUTABLE;
            case ResponseCodeEnum.ALIAS_ALREADY_ASSIGNED -> ALIAS_ALREADY_ASSIGNED;
            case ResponseCodeEnum.INVALID_METADATA_KEY -> INVALID_METADATA_KEY;
            case ResponseCodeEnum.TOKEN_HAS_NO_METADATA_KEY -> TOKEN_HAS_NO_METADATA_KEY;
            case ResponseCodeEnum.MISSING_TOKEN_METADATA -> MISSING_TOKEN_METADATA;
            case ResponseCodeEnum.MISSING_SERIAL_NUMBERS -> MISSING_SERIAL_NUMBERS;
            case ResponseCodeEnum.TOKEN_HAS_NO_ADMIN_KEY -> TOKEN_HAS_NO_ADMIN_KEY;
            case ResponseCodeEnum.NODE_DELETED -> NODE_DELETED;
            case ResponseCodeEnum.INVALID_NODE_ID -> INVALID_NODE_ID;
            case ResponseCodeEnum.INVALID_GOSSIP_ENDPOINT -> INVALID_GOSSIP_ENDPOINT;
            case ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID -> INVALID_NODE_ACCOUNT_ID;
            case ResponseCodeEnum.INVALID_NODE_DESCRIPTION -> INVALID_NODE_DESCRIPTION;
            case ResponseCodeEnum.INVALID_SERVICE_ENDPOINT -> INVALID_SERVICE_ENDPOINT;
            case ResponseCodeEnum.INVALID_GOSSIP_CA_CERTIFICATE -> INVALID_GOSSIP_CA_CERTIFICATE;
            case ResponseCodeEnum.INVALID_GRPC_CERTIFICATE -> INVALID_GRPC_CERTIFICATE;
            case ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS -> INVALID_MAX_AUTO_ASSOCIATIONS;
            case ResponseCodeEnum.MAX_NODES_CREATED -> MAX_NODES_CREATED;
            case ResponseCodeEnum.IP_FQDN_CANNOT_BE_SET_FOR_SAME_ENDPOINT -> IP_FQDN_CANNOT_BE_SET_FOR_SAME_ENDPOINT;
            case ResponseCodeEnum.GOSSIP_ENDPOINT_CANNOT_HAVE_FQDN -> GOSSIP_ENDPOINT_CANNOT_HAVE_FQDN;
            case ResponseCodeEnum.FQDN_SIZE_TOO_LARGE -> FQDN_SIZE_TOO_LARGE;
            case ResponseCodeEnum.INVALID_ENDPOINT -> INVALID_ENDPOINT;
            case ResponseCodeEnum.GOSSIP_ENDPOINTS_EXCEEDED_LIMIT -> GOSSIP_ENDPOINTS_EXCEEDED_LIMIT;
            case ResponseCodeEnum.TOKEN_REFERENCE_REPEATED -> TOKEN_REFERENCE_REPEATED;
            case ResponseCodeEnum.INVALID_OWNER_ID -> INVALID_OWNER_ID;
            case ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED -> TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED;
            case ResponseCodeEnum.SERVICE_ENDPOINTS_EXCEEDED_LIMIT -> SERVICE_ENDPOINTS_EXCEEDED_LIMIT;
            case ResponseCodeEnum.INVALID_IPV4_ADDRESS -> INVALID_IPV4_ADDRESS;
            case ResponseCodeEnum.EMPTY_TOKEN_REFERENCE_LIST -> EMPTY_TOKEN_REFERENCE_LIST;
            case ResponseCodeEnum.UPDATE_NODE_ACCOUNT_NOT_ALLOWED -> UPDATE_NODE_ACCOUNT_NOT_ALLOWED;
            case ResponseCodeEnum.UNRECOGNIZED -> throw new IllegalArgumentException("network returned unrecognized response code; your SDK may be out of date");
        };
    }

    public static Status fromResponseCode(int reponseCode) {
        return Status.valueOf(Objects.requireNonNull(ResponseCodeEnum.forNumber(reponseCode)));
    }

    public int toResponseCode() {
        return this.code.getNumber();
    }

    public String toString() {
        return this.code.name();
    }
}

