/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ConsumerHelper;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TokenDissociateTransaction;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenRejectTransaction;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class TokenRejectFlow {
    @Nullable
    private AccountId ownerId = null;
    private List<TokenId> tokenIds = new ArrayList<TokenId>();
    private List<NftId> nftIds = new ArrayList<NftId>();
    @Nullable
    private List<AccountId> nodeAccountIds = null;
    @Nullable
    private Client freezeWithClient = null;
    @Nullable
    private PrivateKey signPrivateKey = null;
    @Nullable
    private PublicKey signPublicKey = null;
    @Nullable
    private UnaryOperator<byte[]> transactionSigner = null;

    public AccountId getOwnerId() {
        return this.ownerId;
    }

    public TokenRejectFlow setOwnerId(AccountId ownerId) {
        Objects.requireNonNull(ownerId);
        this.ownerId = ownerId;
        return this;
    }

    public List<TokenId> getTokenIds() {
        return this.tokenIds;
    }

    public TokenRejectFlow setTokenIds(List<TokenId> tokenIds) {
        Objects.requireNonNull(tokenIds);
        this.tokenIds = new ArrayList<TokenId>(tokenIds);
        return this;
    }

    public TokenRejectFlow addTokenId(TokenId tokenId) {
        this.tokenIds.add(tokenId);
        return this;
    }

    public List<NftId> getNftIds() {
        return this.nftIds;
    }

    public TokenRejectFlow setNftIds(List<NftId> nftIds) {
        Objects.requireNonNull(nftIds);
        this.nftIds = new ArrayList<NftId>(nftIds);
        return this;
    }

    public TokenRejectFlow addNftId(NftId nftId) {
        this.nftIds.add(nftId);
        return this;
    }

    public TokenRejectFlow setNodeAccountIds(List<AccountId> nodeAccountIds) {
        Objects.requireNonNull(nodeAccountIds);
        this.nodeAccountIds = new ArrayList<AccountId>(nodeAccountIds);
        return this;
    }

    public TokenRejectFlow freezeWith(Client client) {
        this.freezeWithClient = client;
        return this;
    }

    public TokenRejectFlow sign(PrivateKey privateKey) {
        this.signPrivateKey = privateKey;
        this.signPublicKey = null;
        this.transactionSigner = null;
        return this;
    }

    public TokenRejectFlow signWith(PublicKey publicKey, UnaryOperator<byte[]> transactionSigner) {
        this.signPublicKey = publicKey;
        this.transactionSigner = transactionSigner;
        this.signPrivateKey = null;
        return this;
    }

    public TokenRejectFlow signWithOperator(Client client) {
        Client.Operator operator = Objects.requireNonNull(client.getOperator());
        this.signPublicKey = operator.publicKey;
        this.transactionSigner = operator.transactionSigner;
        this.signPrivateKey = null;
        return this;
    }

    private void fillOutTransaction(Transaction<?> transaction) {
        if (this.nodeAccountIds != null) {
            transaction.setNodeAccountIds((List)this.nodeAccountIds);
        }
        if (this.freezeWithClient != null) {
            transaction.freezeWith(this.freezeWithClient);
        }
        if (this.signPrivateKey != null) {
            transaction.sign(this.signPrivateKey);
        } else if (this.signPublicKey != null && this.transactionSigner != null) {
            transaction.signWith(this.signPublicKey, this.transactionSigner);
        }
    }

    private TokenRejectTransaction createTokenRejectTransaction() {
        TokenRejectTransaction tokenRejectTransaction = new TokenRejectTransaction().setOwnerId(this.ownerId).setTokenIds(this.tokenIds).setNftIds(this.nftIds);
        this.fillOutTransaction(tokenRejectTransaction);
        return tokenRejectTransaction;
    }

    private TokenDissociateTransaction createTokenDissociateTransaction() {
        List<TokenId> tokenIdsToReject = Stream.concat(this.tokenIds.stream(), this.nftIds.stream().map(nftId -> nftId.tokenId)).distinct().toList();
        TokenDissociateTransaction tokenDissociateTransaction = new TokenDissociateTransaction().setAccountId(this.ownerId).setTokenIds(tokenIdsToReject);
        this.fillOutTransaction(tokenDissociateTransaction);
        return tokenDissociateTransaction;
    }

    public TransactionResponse execute(Client client) throws PrecheckStatusException, TimeoutException {
        return this.execute(client, client.getRequestTimeout());
    }

    public TransactionResponse execute(Client client, Duration timeoutPerTransaction) throws PrecheckStatusException, TimeoutException {
        try {
            TransactionResponse tokenRejectTxResponse = (TransactionResponse)this.createTokenRejectTransaction().execute(client, timeoutPerTransaction);
            tokenRejectTxResponse.getReceipt(client, timeoutPerTransaction);
            TransactionResponse tokenDissociateTxResponse = (TransactionResponse)this.createTokenDissociateTransaction().execute(client, timeoutPerTransaction);
            tokenDissociateTxResponse.getReceipt(client, timeoutPerTransaction);
            return tokenRejectTxResponse;
        }
        catch (ReceiptStatusException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        return this.executeAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionResponse> executeAsync(Client client, Duration timeoutPerTransaction) {
        return ((CompletableFuture)this.createTokenRejectTransaction().executeAsync(client, timeoutPerTransaction).thenCompose(tokenRejectResponse -> tokenRejectResponse.getReceiptQuery().executeAsync(client, timeoutPerTransaction))).thenCompose(receipt -> this.createTokenDissociateTransaction().executeAsync(client, timeoutPerTransaction));
    }

    public void executeAsync(Client client, BiConsumer<TransactionResponse, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client), callback);
    }

    public void executeAsync(Client client, Duration timeoutPerTransaction, BiConsumer<TransactionResponse, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client, timeoutPerTransaction), callback);
    }

    public void executeAsync(Client client, Consumer<TransactionResponse> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client), onSuccess, onFailure);
    }

    public void executeAsync(Client client, Duration timeoutPerTransaction, Consumer<TransactionResponse> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client, timeoutPerTransaction), onSuccess, onFailure);
    }
}

