/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenReference;
import com.hedera.hashgraph.sdk.proto.TokenRejectTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenRejectTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenRejectTransaction> {
    @Nullable
    private AccountId ownerId = null;
    private List<TokenId> tokenIds = new ArrayList<TokenId>();
    private List<NftId> nftIds = new ArrayList<NftId>();

    public TokenRejectTransaction() {
    }

    TokenRejectTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenRejectTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getOwnerId() {
        return this.ownerId;
    }

    public TokenRejectTransaction setOwnerId(AccountId ownerId) {
        Objects.requireNonNull(ownerId);
        this.requireNotFrozen();
        this.ownerId = ownerId;
        return this;
    }

    public List<TokenId> getTokenIds() {
        return this.tokenIds;
    }

    public TokenRejectTransaction setTokenIds(List<TokenId> tokenIds) {
        this.requireNotFrozen();
        Objects.requireNonNull(tokenIds);
        this.tokenIds = new ArrayList<TokenId>(tokenIds);
        return this;
    }

    public TokenRejectTransaction addTokenId(TokenId tokenId) {
        this.requireNotFrozen();
        this.tokenIds.add(tokenId);
        return this;
    }

    public List<NftId> getNftIds() {
        return this.nftIds;
    }

    public TokenRejectTransaction setNftIds(List<NftId> nftIds) {
        this.requireNotFrozen();
        Objects.requireNonNull(nftIds);
        this.nftIds = new ArrayList<NftId>(nftIds);
        return this;
    }

    public TokenRejectTransaction addNftId(NftId nftId) {
        this.requireNotFrozen();
        this.nftIds.add(nftId);
        return this;
    }

    TokenRejectTransactionBody.Builder build() {
        TokenRejectTransactionBody.Builder builder = TokenRejectTransactionBody.newBuilder();
        if (this.ownerId != null) {
            builder.setOwner(this.ownerId.toProtobuf());
        }
        for (TokenId tokenId : this.tokenIds) {
            builder.addRejections((TokenReference)TokenReference.newBuilder().setFungibleToken(tokenId.toProtobuf()).build());
        }
        for (NftId nftId : this.nftIds) {
            builder.addRejections((TokenReference)TokenReference.newBuilder().setNft(nftId.toProtobuf()).build());
        }
        return builder;
    }

    void initFromTransactionBody() {
        TokenRejectTransactionBody body = this.sourceTransactionBody.getTokenReject();
        if (body.hasOwner()) {
            this.ownerId = AccountId.fromProtobuf(body.getOwner());
        }
        for (TokenReference tokenReference : body.getRejectionsList()) {
            if (tokenReference.hasFungibleToken()) {
                this.tokenIds.add(TokenId.fromProtobuf(tokenReference.getFungibleToken()));
                continue;
            }
            if (!tokenReference.hasNft()) continue;
            this.nftIds.add(NftId.fromProtobuf(tokenReference.getNft()));
        }
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.ownerId != null) {
            this.ownerId.validateChecksum(client);
        }
        for (TokenId token : this.tokenIds) {
            if (token == null) continue;
            token.validateChecksum(client);
        }
        for (NftId nftId : this.nftIds) {
            nftId.tokenId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getRejectTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenReject(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenReject(this.build());
    }
}

