/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.TokenUpdateNftsTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class TokenUpdateNftsTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenUpdateNftsTransaction> {
    @Nullable
    private TokenId tokenId = null;
    private List<Long> serials = new ArrayList<Long>();
    private byte[] metadata = null;

    public TokenUpdateNftsTransaction() {
    }

    TokenUpdateNftsTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenUpdateNftsTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenUpdateNftsTransaction setTokenId(@Nullable TokenId tokenId) {
        this.requireNotFrozen();
        Objects.requireNonNull(tokenId);
        this.tokenId = tokenId;
        return this;
    }

    public List<Long> getSerials() {
        return this.serials;
    }

    public TokenUpdateNftsTransaction setSerials(List<Long> serials) {
        this.requireNotFrozen();
        Objects.requireNonNull(serials);
        this.serials = new ArrayList<Long>(serials);
        return this;
    }

    public TokenUpdateNftsTransaction addSerial(@Nonnegative long serial) {
        this.requireNotFrozen();
        this.serials.add(serial);
        return this;
    }

    @Nullable
    public byte[] getMetadata() {
        return this.metadata;
    }

    public TokenUpdateNftsTransaction setMetadata(byte[] metadata) {
        this.requireNotFrozen();
        this.metadata = metadata;
        return this;
    }

    void initFromTransactionBody() {
        TokenUpdateNftsTransactionBody body = this.sourceTransactionBody.getTokenUpdateNfts();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
        this.serials = body.getSerialNumbersList();
        if (body.hasMetadata()) {
            this.metadata = body.getMetadata().getValue().toByteArray();
        }
    }

    TokenUpdateNftsTransactionBody.Builder build() {
        TokenUpdateNftsTransactionBody.Builder builder = TokenUpdateNftsTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        for (Long serial : this.serials) {
            builder.addSerialNumbers(serial);
        }
        if (this.metadata != null) {
            builder.setMetadata(BytesValue.of((ByteString)ByteString.copyFrom((byte[])this.metadata)));
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getUpdateNftsMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenUpdateNfts(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenUpdateNfts(this.build());
    }
}

