/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ConsensusCreateTopicTransactionBody;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TopicCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TopicCreateTransaction> {
    @Nullable
    private AccountId autoRenewAccountId = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    private String topicMemo = "";
    @Nullable
    private Key adminKey = null;
    @Nullable
    private Key submitKey = null;

    public TopicCreateTransaction() {
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
    }

    TopicCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TopicCreateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    public String getTopicMemo() {
        return this.topicMemo;
    }

    public TopicCreateTransaction setTopicMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.topicMemo = memo;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public TopicCreateTransaction setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.requireNotFrozen();
        this.adminKey = adminKey;
        return this;
    }

    @Nullable
    public Key getSubmitKey() {
        return this.submitKey;
    }

    public TopicCreateTransaction setSubmitKey(Key submitKey) {
        Objects.requireNonNull(submitKey);
        this.requireNotFrozen();
        this.submitKey = submitKey;
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A Duration can't actually be mutated")
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A Duration can't actually be mutated")
    public TopicCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.requireNotFrozen();
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public TopicCreateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        Objects.requireNonNull(autoRenewAccountId);
        this.requireNotFrozen();
        this.autoRenewAccountId = autoRenewAccountId;
        return this;
    }

    void initFromTransactionBody() {
        ConsensusCreateTopicTransactionBody body = this.sourceTransactionBody.getConsensusCreateTopic();
        if (body.hasAutoRenewAccount()) {
            this.autoRenewAccountId = AccountId.fromProtobuf(body.getAutoRenewAccount());
        }
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        if (body.hasSubmitKey()) {
            this.submitKey = Key.fromProtobufKey(body.getSubmitKey());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        this.topicMemo = body.getMemo();
    }

    ConsensusCreateTopicTransactionBody.Builder build() {
        ConsensusCreateTopicTransactionBody.Builder builder = ConsensusCreateTopicTransactionBody.newBuilder();
        if (this.autoRenewAccountId != null) {
            builder.setAutoRenewAccount(this.autoRenewAccountId.toProtobuf());
        }
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.submitKey != null) {
            builder.setSubmitKey(this.submitKey.toProtobufKey());
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        builder.setMemo(this.topicMemo);
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.autoRenewAccountId != null) {
            this.autoRenewAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getCreateTopicMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusCreateTopic(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setConsensusCreateTopic(this.build());
    }
}

