/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ExecutionState;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseCodeEnum;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.TransactionGetReceiptQuery;
import com.hedera.hashgraph.sdk.proto.TransactionGetReceiptResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TransactionReceiptQuery
extends Query<TransactionReceipt, TransactionReceiptQuery> {
    @Nullable
    private TransactionId transactionId = null;
    private boolean includeChildren = false;
    private boolean includeDuplicates = false;

    @Override
    @Nullable
    public TransactionId getTransactionIdInternal() {
        return this.transactionId;
    }

    public TransactionReceiptQuery setTransactionId(TransactionId transactionId) {
        Objects.requireNonNull(transactionId);
        this.transactionId = transactionId;
        return this;
    }

    public boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public TransactionReceiptQuery setIncludeChildren(boolean value) {
        this.includeChildren = value;
        return this;
    }

    public boolean getIncludeDuplicates() {
        return this.includeDuplicates;
    }

    public TransactionReceiptQuery setIncludeDuplicates(boolean value) {
        this.includeDuplicates = value;
        return this;
    }

    @Override
    boolean isPaymentRequired() {
        return false;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.transactionId != null) {
            Objects.requireNonNull(this.transactionId.accountId).validateChecksum(client);
        }
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        TransactionGetReceiptQuery.Builder builder = TransactionGetReceiptQuery.newBuilder().setIncludeChildReceipts(this.includeChildren).setIncludeDuplicates(this.includeDuplicates);
        if (this.transactionId != null) {
            builder.setTransactionID(this.transactionId.toProtobuf());
        }
        queryBuilder.setTransactionGetReceipt(builder.setHeader(header));
    }

    @Override
    Status mapResponseStatus(Response response) {
        ResponseCodeEnum preCheckCode = response.getTransactionGetReceipt().getHeader().getNodeTransactionPrecheckCode();
        return Status.valueOf(preCheckCode);
    }

    @Override
    TransactionReceipt mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        TransactionGetReceiptResponse receiptResponse = response.getTransactionGetReceipt();
        List<TransactionReceipt> duplicates = TransactionReceiptQuery.mapReceiptList(receiptResponse.getDuplicateTransactionReceiptsList());
        List<TransactionReceipt> children = TransactionReceiptQuery.mapReceiptList(receiptResponse.getChildTransactionReceiptsList());
        return TransactionReceipt.fromProtobuf(response.getTransactionGetReceipt().getReceipt(), duplicates, children, this.transactionId);
    }

    private static List<TransactionReceipt> mapReceiptList(List<com.hedera.hashgraph.sdk.proto.TransactionReceipt> protoReceiptList) {
        ArrayList<TransactionReceipt> outList = new ArrayList<TransactionReceipt>(protoReceiptList.size());
        for (com.hedera.hashgraph.sdk.proto.TransactionReceipt protoReceipt : protoReceiptList) {
            outList.add(TransactionReceipt.fromProtobuf(protoReceipt));
        }
        return outList;
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getTransactionGetReceipt().getHeader();
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getTransactionGetReceipt().getHeader();
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getGetTransactionReceiptsMethod();
    }

    @Override
    ExecutionState getExecutionState(Status status, Response response) {
        switch (status) {
            case BUSY: 
            case UNKNOWN: 
            case RECEIPT_NOT_FOUND: 
            case RECORD_NOT_FOUND: 
            case PLATFORM_NOT_ACTIVE: {
                return ExecutionState.RETRY;
            }
            case OK: {
                break;
            }
            default: {
                return ExecutionState.REQUEST_ERROR;
            }
        }
        Status receiptStatus = Status.valueOf(response.getTransactionGetReceipt().getReceipt().getStatus());
        switch (receiptStatus) {
            case BUSY: 
            case UNKNOWN: 
            case RECEIPT_NOT_FOUND: 
            case RECORD_NOT_FOUND: 
            case PLATFORM_NOT_ACTIVE: 
            case OK: {
                return ExecutionState.RETRY;
            }
        }
        return ExecutionState.SUCCESS;
    }
}

