/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.hedera.hashgraph.sdk.proto.NftID;
import com.hedera.hashgraph.sdk.proto.TokenID;
import com.hedera.hashgraph.sdk.proto.TokenReferenceOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TokenReference
extends GeneratedMessageLite<TokenReference, Builder>
implements TokenReferenceOrBuilder {
    private int tokenIdentifierCase_ = 0;
    private Object tokenIdentifier_;
    public static final int FUNGIBLE_TOKEN_FIELD_NUMBER = 1;
    public static final int NFT_FIELD_NUMBER = 2;
    private static final TokenReference DEFAULT_INSTANCE;
    private static volatile Parser<TokenReference> PARSER;

    private TokenReference() {
    }

    @Override
    public TokenIdentifierCase getTokenIdentifierCase() {
        return TokenIdentifierCase.forNumber(this.tokenIdentifierCase_);
    }

    private void clearTokenIdentifier() {
        this.tokenIdentifierCase_ = 0;
        this.tokenIdentifier_ = null;
    }

    @Override
    public boolean hasFungibleToken() {
        return this.tokenIdentifierCase_ == 1;
    }

    @Override
    public TokenID getFungibleToken() {
        if (this.tokenIdentifierCase_ == 1) {
            return (TokenID)this.tokenIdentifier_;
        }
        return TokenID.getDefaultInstance();
    }

    private void setFungibleToken(TokenID value) {
        value.getClass();
        this.tokenIdentifier_ = value;
        this.tokenIdentifierCase_ = 1;
    }

    private void mergeFungibleToken(TokenID value) {
        value.getClass();
        this.tokenIdentifier_ = this.tokenIdentifierCase_ == 1 && this.tokenIdentifier_ != TokenID.getDefaultInstance() ? ((TokenID.Builder)TokenID.newBuilder((TokenID)this.tokenIdentifier_).mergeFrom(value)).buildPartial() : value;
        this.tokenIdentifierCase_ = 1;
    }

    private void clearFungibleToken() {
        if (this.tokenIdentifierCase_ == 1) {
            this.tokenIdentifierCase_ = 0;
            this.tokenIdentifier_ = null;
        }
    }

    @Override
    public boolean hasNft() {
        return this.tokenIdentifierCase_ == 2;
    }

    @Override
    public NftID getNft() {
        if (this.tokenIdentifierCase_ == 2) {
            return (NftID)this.tokenIdentifier_;
        }
        return NftID.getDefaultInstance();
    }

    private void setNft(NftID value) {
        value.getClass();
        this.tokenIdentifier_ = value;
        this.tokenIdentifierCase_ = 2;
    }

    private void mergeNft(NftID value) {
        value.getClass();
        this.tokenIdentifier_ = this.tokenIdentifierCase_ == 2 && this.tokenIdentifier_ != NftID.getDefaultInstance() ? ((NftID.Builder)NftID.newBuilder((NftID)this.tokenIdentifier_).mergeFrom(value)).buildPartial() : value;
        this.tokenIdentifierCase_ = 2;
    }

    private void clearNft() {
        if (this.tokenIdentifierCase_ == 2) {
            this.tokenIdentifierCase_ = 0;
            this.tokenIdentifier_ = null;
        }
    }

    public static TokenReference parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data);
    }

    public static TokenReference parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TokenReference parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static TokenReference parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TokenReference parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static TokenReference parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TokenReference parseFrom(InputStream input) throws IOException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static TokenReference parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TokenReference parseDelimitedFrom(InputStream input) throws IOException {
        return (TokenReference)TokenReference.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static TokenReference parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TokenReference)TokenReference.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TokenReference parseFrom(CodedInputStream input) throws IOException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static TokenReference parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TokenReference)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(TokenReference prototype) {
        return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new TokenReference();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Object[] objects = new Object[]{"tokenIdentifier_", "tokenIdentifierCase_", TokenID.class, NftID.class};
                String info = "\u0000\u0002\u0001\u0000\u0001\u0002\u0002\u0000\u0000\u0000\u0001<\u0000\u0002<\u0000";
                return TokenReference.newMessageInfo((MessageLite)DEFAULT_INSTANCE, (String)info, (Object[])objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                GeneratedMessageLite.DefaultInstanceBasedParser parser = PARSER;
                if (parser != null) return parser;
                Class<TokenReference> clazz = TokenReference.class;
                synchronized (TokenReference.class) {
                    parser = PARSER;
                    if (parser != null) return parser;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return parser;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static TokenReference getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TokenReference> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        TokenReference defaultInstance;
        DEFAULT_INSTANCE = defaultInstance = new TokenReference();
        GeneratedMessageLite.registerDefaultInstance(TokenReference.class, (GeneratedMessageLite)defaultInstance);
    }

    public static enum TokenIdentifierCase {
        FUNGIBLE_TOKEN(1),
        NFT(2),
        TOKENIDENTIFIER_NOT_SET(0);

        private final int value;

        private TokenIdentifierCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static TokenIdentifierCase valueOf(int value) {
            return TokenIdentifierCase.forNumber(value);
        }

        public static TokenIdentifierCase forNumber(int value) {
            switch (value) {
                case 1: {
                    return FUNGIBLE_TOKEN;
                }
                case 2: {
                    return NFT;
                }
                case 0: {
                    return TOKENIDENTIFIER_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<TokenReference, Builder>
    implements TokenReferenceOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public TokenIdentifierCase getTokenIdentifierCase() {
            return ((TokenReference)this.instance).getTokenIdentifierCase();
        }

        public Builder clearTokenIdentifier() {
            this.copyOnWrite();
            ((TokenReference)this.instance).clearTokenIdentifier();
            return this;
        }

        @Override
        public boolean hasFungibleToken() {
            return ((TokenReference)this.instance).hasFungibleToken();
        }

        @Override
        public TokenID getFungibleToken() {
            return ((TokenReference)this.instance).getFungibleToken();
        }

        public Builder setFungibleToken(TokenID value) {
            this.copyOnWrite();
            ((TokenReference)this.instance).setFungibleToken(value);
            return this;
        }

        public Builder setFungibleToken(TokenID.Builder builderForValue) {
            this.copyOnWrite();
            ((TokenReference)this.instance).setFungibleToken((TokenID)builderForValue.build());
            return this;
        }

        public Builder mergeFungibleToken(TokenID value) {
            this.copyOnWrite();
            ((TokenReference)this.instance).mergeFungibleToken(value);
            return this;
        }

        public Builder clearFungibleToken() {
            this.copyOnWrite();
            ((TokenReference)this.instance).clearFungibleToken();
            return this;
        }

        @Override
        public boolean hasNft() {
            return ((TokenReference)this.instance).hasNft();
        }

        @Override
        public NftID getNft() {
            return ((TokenReference)this.instance).getNft();
        }

        public Builder setNft(NftID value) {
            this.copyOnWrite();
            ((TokenReference)this.instance).setNft(value);
            return this;
        }

        public Builder setNft(NftID.Builder builderForValue) {
            this.copyOnWrite();
            ((TokenReference)this.instance).setNft((NftID)builderForValue.build());
            return this;
        }

        public Builder mergeNft(NftID value) {
            this.copyOnWrite();
            ((TokenReference)this.instance).mergeNft(value);
            return this;
        }

        public Builder clearNft() {
            this.copyOnWrite();
            ((TokenReference)this.instance).clearNft();
            return this;
        }
    }
}

