/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ContractUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractUpdateTransaction> {
    @Nullable
    private ContractId contractId = null;
    @Nullable
    private AccountId proxyAccountId = null;
    @Nullable
    private FileId bytecodeFileId = null;
    @Nullable
    private Instant expirationTime = null;
    @Nullable
    private Key adminKey = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    @Nullable
    private String contractMemo = null;

    public ContractUpdateTransaction() {
    }

    ContractUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    ContractUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public ContractId getContractId() {
        return this.contractId;
    }

    public ContractUpdateTransaction setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.requireNotFrozen();
        this.contractId = contractId;
        return this;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public ContractUpdateTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public ContractUpdateTransaction setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.requireNotFrozen();
        this.adminKey = adminKey;
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    public ContractUpdateTransaction setProxyAccountId(AccountId proxyAccountId) {
        Objects.requireNonNull(proxyAccountId);
        this.requireNotFrozen();
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public ContractUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.requireNotFrozen();
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    @Nullable
    @Deprecated
    public FileId getBytecodeFileId() {
        return this.bytecodeFileId;
    }

    @Deprecated
    public ContractUpdateTransaction setBytecodeFileId(FileId bytecodeFileId) {
        Objects.requireNonNull(bytecodeFileId);
        this.requireNotFrozen();
        this.bytecodeFileId = bytecodeFileId;
        return this;
    }

    @Nullable
    public String getContractMemo() {
        return this.contractMemo;
    }

    public ContractUpdateTransaction setContractMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.contractMemo = memo;
        return this;
    }

    public ContractUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.contractMemo = "";
        return this;
    }

    void initFromTransactionBody() {
        ContractUpdateTransactionBody body = this.sourceTransactionBody.getContractUpdateInstance();
        if (body.hasContractID()) {
            this.contractId = ContractId.fromProtobuf(body.getContractID());
        }
        if (body.hasProxyAccountID()) {
            this.proxyAccountId = AccountId.fromProtobuf(body.getProxyAccountID());
        }
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        if (body.hasMemoWrapper()) {
            this.contractMemo = body.getMemoWrapper().getValue();
        }
    }

    ContractUpdateTransactionBody.Builder build() {
        ContractUpdateTransactionBody.Builder builder = ContractUpdateTransactionBody.newBuilder();
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        if (this.proxyAccountId != null) {
            builder.setProxyAccountID(this.proxyAccountId.toProtobuf());
        }
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        if (this.contractMemo != null) {
            builder.setMemoWrapper(StringValue.of((String)this.contractMemo));
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
        if (this.proxyAccountId != null) {
            this.proxyAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getUpdateContractMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractUpdateInstance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setContractUpdateInstance(this.build());
    }
}

