/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.errorprone.annotations.Var;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

class EntityIdHelper {
    static final int SOLIDITY_ADDRESS_LEN = 20;
    static final int SOLIDITY_ADDRESS_LEN_HEX = 40;
    private static final Pattern ENTITY_ID_REGEX = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-([a-z]{5}))?$");

    private EntityIdHelper() {
    }

    static <R> R fromString(String idString, WithIdNums<R> constructObjectWithIdNums) {
        Matcher match = ENTITY_ID_REGEX.matcher(idString);
        if (!match.find()) {
            throw new IllegalArgumentException("Invalid ID \"" + idString + "\": format should look like 0.0.123 or 0.0.123-vfmkw");
        }
        return constructObjectWithIdNums.apply(Long.parseLong(match.group(1)), Long.parseLong(match.group(2)), Long.parseLong(match.group(3)), match.group(4));
    }

    static <R> R fromSolidityAddress(String address, WithIdNums<R> withAddress) {
        return EntityIdHelper.fromSolidityAddress(EntityIdHelper.decodeSolidityAddress(address), withAddress);
    }

    private static <R> R fromSolidityAddress(byte[] address, WithIdNums<R> withAddress) {
        if (address.length != 20) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
        ByteBuffer buf = ByteBuffer.wrap(address);
        return withAddress.apply(buf.getInt(), buf.getLong(), buf.getLong(), null);
    }

    private static byte[] decodeSolidityAddress(@Var String address) {
        String string = address = address.startsWith("0x") ? address.substring(2) : address;
        if (address.length() != 40) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
        try {
            return Hex.decode((String)address);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("failed to decode Solidity address as hex", e);
        }
    }

    static String toSolidityAddress(long shard, long realm, long num) {
        if (Long.highestOneBit(shard) > 32L) {
            throw new IllegalStateException("shard out of 32-bit range " + shard);
        }
        return Hex.toHexString((byte[])ByteBuffer.allocate(20).putInt((int)shard).putLong(realm).putLong(num).array());
    }

    static String checksum(String ledgerId, String addr) {
        int i;
        StringBuilder answer = new StringBuilder();
        ArrayList<Integer> d = new ArrayList<Integer>();
        long s0 = 0L;
        long s1 = 0L;
        long s = 0L;
        long sh = 0L;
        long c = 0L;
        long p3 = 17576L;
        long p5 = 11881376L;
        long asciiA = Character.codePointAt("a", 0);
        long m = 1000003L;
        long w = 31L;
        String id = ledgerId + "000000000000";
        ArrayList<Integer> h = new ArrayList<Integer>();
        for (i = 0; i < id.length(); i += 2) {
            h.add(Integer.parseInt(id.substring(i, Math.min(i + 2, id.length())), 16));
        }
        for (i = 0; i < addr.length(); ++i) {
            d.add(addr.charAt(i) == '.' ? 10 : Integer.parseInt(String.valueOf(addr.charAt(i)), 10));
        }
        for (i = 0; i < d.size(); ++i) {
            s = (w * s + (long)((Integer)d.get(i)).intValue()) % p3;
            if (i % 2 == 0) {
                s0 = (s0 + (long)((Integer)d.get(i)).intValue()) % 11L;
                continue;
            }
            s1 = (s1 + (long)((Integer)d.get(i)).intValue()) % 11L;
        }
        for (Integer integer : h) {
            sh = (w * sh + (long)integer.intValue()) % p5;
        }
        c = ((((long)(addr.length() % 5 * 11) + s0) * 11L + s1) * p3 + s + sh) % p5;
        c = c * m % p5;
        for (int i2 = 0; i2 < 5; ++i2) {
            answer.append((char)(asciiA + c % 26L));
            c /= 26L;
        }
        return answer.reverse().toString();
    }

    static void validate(long shard, long realm, long num, Client client, @Nullable String checksum) throws BadEntityIdException {
        String expectedChecksum;
        if (client.getNetworkName() == null) {
            throw new IllegalStateException("Can't validate checksum without knowing which network the ID is for.  Ensure client's network name is set.");
        }
        if (checksum != null && !checksum.equals(expectedChecksum = EntityIdHelper.checksum(Integer.toString(client.getNetworkName().id), EntityIdHelper.toString(shard, realm, num)))) {
            throw new BadEntityIdException(shard, realm, num, checksum, expectedChecksum);
        }
    }

    static String toString(long shard, long realm, long num) {
        return shard + "." + realm + "." + num;
    }

    static String toStringWithChecksum(long shard, long realm, long num, Client client, @Nullable String checksum) {
        if (client.getNetworkName() != null) {
            return shard + "." + realm + "." + num + "-" + EntityIdHelper.checksum(Integer.toString(client.getNetworkName().id), EntityIdHelper.toString(shard, realm, num));
        }
        throw new IllegalStateException("Can't derive checksum for ID without knowing which network the ID is for.  Ensure client's network name is set.");
    }

    @FunctionalInterface
    static interface WithIdNums<R> {
        public R apply(long var1, long var3, long var5, @Nullable String var7);
    }
}

