/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Delayer;
import com.hedera.hashgraph.sdk.ExecutionState;
import com.hedera.hashgraph.sdk.MaxAttemptsExceededException;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.WithExecute;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.guavacommon.GuavaFutureUtils;
import net.javacrumbs.futureconverter.java8common.Java8FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Executable<SdkRequestT, ProtoRequestT, ResponseT, O>
implements WithExecute<O> {
    static final Pattern RST_STREAM = Pattern.compile(".*\\brst[^0-9a-zA-Z]stream\\b.*", 34);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    protected Integer maxAttempts = null;
    @Nullable
    protected Duration maxBackoff = null;
    @Nullable
    protected Duration minBackoff = null;
    protected int nextNodeIndex = 0;
    protected List<AccountId> nodeAccountIds = Collections.emptyList();
    protected List<Node> nodes = new ArrayList<Node>();
    @VisibleForTesting
    Function<GrpcRequest, ResponseT> blockingUnaryCall = grpcRequest -> ClientCalls.blockingUnaryCall(grpcRequest.createCall(), grpcRequest.getRequest());

    Executable() {
    }

    public final Duration getMaxBackoff() {
        return this.maxBackoff != null ? this.maxBackoff : Client.DEFAULT_MAX_BACKOFF;
    }

    public final SdkRequestT setMaxBackoff(Duration maxBackoff) {
        if (maxBackoff == null || maxBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("maxBackoff must be a positive duration");
        }
        if (maxBackoff.compareTo(this.getMinBackoff()) < 0) {
            throw new IllegalArgumentException("maxBackoff must be greater than or equal to minBackoff");
        }
        this.maxBackoff = maxBackoff;
        return (SdkRequestT)this;
    }

    public final Duration getMinBackoff() {
        return this.minBackoff != null ? this.minBackoff : Client.DEFAULT_MIN_BACKOFF;
    }

    public final SdkRequestT setMinBackoff(Duration minBackoff) {
        if (minBackoff == null || minBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("minBackoff must be a positive duration");
        }
        if (minBackoff.compareTo(this.getMaxBackoff()) > 0) {
            throw new IllegalArgumentException("minBackoff must be less than or equal to maxBackoff");
        }
        this.minBackoff = minBackoff;
        return (SdkRequestT)this;
    }

    @Deprecated
    public final int getMaxRetry() {
        return this.getMaxAttempts();
    }

    @Deprecated
    public final SdkRequestT setMaxRetry(int count) {
        return this.setMaxAttempts(count);
    }

    public final int getMaxAttempts() {
        return this.maxAttempts != null ? this.maxAttempts : 10;
    }

    public final SdkRequestT setMaxAttempts(int maxAttempts) {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be greater than zero");
        }
        this.maxAttempts = maxAttempts;
        return (SdkRequestT)this;
    }

    @Nullable
    public final List<AccountId> getNodeAccountIds() {
        if (!this.nodeAccountIds.isEmpty()) {
            return new ArrayList<AccountId>(this.nodeAccountIds);
        }
        return null;
    }

    public SdkRequestT setNodeAccountIds(List<AccountId> nodeAccountIds) {
        this.nodeAccountIds = new ArrayList<AccountId>(nodeAccountIds);
        return (SdkRequestT)this;
    }

    void checkNodeAccountIds() {
        if (this.nodeAccountIds.isEmpty()) {
            throw new IllegalStateException("Request node account IDs were not set before executing");
        }
    }

    abstract void onExecute(Client var1) throws TimeoutException, PrecheckStatusException;

    abstract CompletableFuture<Void> onExecuteAsync(Client var1);

    void mergeFromClient(Client client) {
        if (this.maxAttempts == null) {
            this.maxAttempts = client.getMaxAttempts();
        }
        if (this.maxBackoff == null) {
            this.maxBackoff = client.getMaxBackoff();
        }
        if (this.minBackoff == null) {
            this.minBackoff = client.getMinBackoff();
        }
    }

    private void delay(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public O execute(Client client) throws TimeoutException, PrecheckStatusException {
        return this.execute(client, client.getRequestTimeout());
    }

    @Override
    public O execute(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException {
        Throwable lastException = null;
        this.mergeFromClient(client);
        this.onExecute(client);
        this.checkNodeAccountIds();
        this.setNodesFromNodeAccountIds(client);
        int attempt = 1;
        while (true) {
            if (attempt > this.maxAttempts) {
                throw new MaxAttemptsExceededException(lastException);
            }
            GrpcRequest grpcRequest = new GrpcRequest(attempt);
            Node node = grpcRequest.getNode();
            Object response = null;
            if (!node.isHealthy()) {
                this.delay(node.getRemainingTimeForBackoff());
            }
            if (node.channelFailedToConnect()) {
                this.logger.trace("Failed to connect channel for node {} for request #{}", (Object)node.getAccountId(), (Object)attempt);
                lastException = grpcRequest.reactToConnectionFailure();
            } else {
                try {
                    response = this.blockingUnaryCall.apply(grpcRequest);
                }
                catch (Throwable e) {
                    lastException = e;
                }
                if (response == null) {
                    if (!grpcRequest.shouldRetryExceptionally(lastException)) {
                        throw grpcRequest.mapStatusException();
                    }
                } else {
                    switch (grpcRequest.getStatus(response)) {
                        case ServerError: {
                            lastException = grpcRequest.mapStatusException();
                            break;
                        }
                        case Retry: {
                            this.delay(grpcRequest.getDelay());
                            break;
                        }
                        case RequestError: {
                            throw grpcRequest.mapStatusException();
                        }
                        default: {
                            return grpcRequest.mapResponse();
                        }
                    }
                }
            }
            ++attempt;
        }
    }

    @Override
    public CompletableFuture<O> executeAsync(Client client) {
        this.mergeFromClient(client);
        return this.onExecuteAsync(client).thenCompose(v -> {
            this.checkNodeAccountIds();
            this.setNodesFromNodeAccountIds(client);
            return this.executeAsync(client, 1, null);
        });
    }

    @VisibleForTesting
    void setNodesFromNodeAccountIds(Client client) {
        for (AccountId accountId : this.nodeAccountIds) {
            Node node = client.network.getNode(accountId);
            if (node == null) {
                throw new IllegalStateException("Some node account IDs did not map to valid nodes in the client's network");
            }
            this.nodes.add(Objects.requireNonNull(node));
        }
    }

    @VisibleForTesting
    Node getNodeForExecute(int attempt) {
        Node node = null;
        Node candidate = null;
        long smallestDelay = Long.MAX_VALUE;
        for (int i = 0; i < this.nodes.size() && !(node = this.nodes.get(this.nextNodeIndex)).isHealthy(); ++i) {
            long backoff = node.getRemainingTimeForBackoff();
            if (backoff < smallestDelay) {
                candidate = node;
                smallestDelay = backoff;
            }
            node = null;
            this.advanceRequest();
        }
        if (node == null) {
            node = candidate;
            this.nextNodeIndex = Math.max(0, this.nextNodeIndex - 1);
        }
        if (node != null) {
            this.logger.trace("Using node {} for request #{}: {}", new Object[]{node.getAccountId(), attempt, this});
        }
        return node;
    }

    private ProtoRequestT getRequestForExecute() {
        ProtoRequestT request = this.makeRequest();
        this.advanceRequest();
        return request;
    }

    private CompletableFuture<O> executeAsync(Client client, int attempt, @Nullable Throwable lastException) {
        if (attempt > this.maxAttempts) {
            return CompletableFuture.failedFuture(new MaxAttemptsExceededException(lastException));
        }
        GrpcRequest grpcRequest = new GrpcRequest(attempt);
        if (!grpcRequest.getNode().isHealthy()) {
            return Delayer.delayFor(grpcRequest.getNode().getRemainingTimeForBackoff(), client.executor).thenCompose(v -> this.executeAsync(client, attempt, lastException));
        }
        return grpcRequest.getNode().channelFailedToConnectAsync().thenCompose(connectionFailed -> {
            if (connectionFailed.booleanValue()) {
                Throwable connectionException = grpcRequest.reactToConnectionFailure();
                return this.executeAsync(client, attempt + 1, connectionException);
            }
            return ((CompletableFuture)Java8FutureUtils.createCompletableFuture((ValueSource)GuavaFutureUtils.createValueSource((ListenableFuture)ClientCalls.futureUnaryCall(grpcRequest.createCall(), grpcRequest.getRequest()))).handle((response, error) -> {
                if (grpcRequest.shouldRetryExceptionally((Throwable)error)) {
                    return this.executeAsync(client, attempt + 1, (Throwable)error);
                }
                if (error != null) {
                    return CompletableFuture.failedFuture(error);
                }
                switch (grpcRequest.getStatus(response)) {
                    case ServerError: {
                        return this.executeAsync(client, attempt + 1, grpcRequest.mapStatusException());
                    }
                    case Retry: {
                        return Delayer.delayFor(grpcRequest.getDelay(), client.executor).thenCompose(v -> this.executeAsync(client, attempt + 1, grpcRequest.mapStatusException()));
                    }
                    case RequestError: {
                        return CompletableFuture.failedFuture(grpcRequest.mapStatusException());
                    }
                }
                return CompletableFuture.completedFuture(grpcRequest.mapResponse());
            })).thenCompose(x -> x);
        });
    }

    abstract ProtoRequestT makeRequest();

    void advanceRequest() {
        this.nextNodeIndex = (this.nextNodeIndex + 1) % this.nodeAccountIds.size();
    }

    abstract O mapResponse(ResponseT var1, AccountId var2, ProtoRequestT var3);

    abstract Status mapResponseStatus(ResponseT var1);

    abstract MethodDescriptor<ProtoRequestT, ResponseT> getMethodDescriptor();

    @Nullable
    abstract TransactionId getTransactionIdInternal();

    boolean shouldRetryExceptionally(@Nullable Throwable error) {
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            Status.Code status = statusException.getStatus().getCode();
            String description = statusException.getStatus().getDescription();
            return status == Status.Code.UNAVAILABLE || status == Status.Code.RESOURCE_EXHAUSTED || status == Status.Code.INTERNAL && description != null && RST_STREAM.matcher(description).matches();
        }
        return false;
    }

    ExecutionState shouldRetry(Status status, ResponseT response) {
        switch (status) {
            case PLATFORM_TRANSACTION_NOT_CREATED: 
            case PLATFORM_NOT_ACTIVE: 
            case BUSY: {
                return ExecutionState.ServerError;
            }
            case OK: {
                return ExecutionState.Success;
            }
        }
        return ExecutionState.RequestError;
    }

    @VisibleForTesting
    class GrpcRequest {
        private final Node node;
        private final int attempt;
        private final ProtoRequestT request;
        private final long startAt;
        private final long delay;
        private ResponseT response;
        private double latency;
        private Status responseStatus;

        GrpcRequest(int attempt) {
            this.attempt = attempt;
            this.node = Executable.this.getNodeForExecute(attempt);
            this.request = Executable.this.getRequestForExecute();
            this.startAt = System.nanoTime();
            this.delay = (long)Math.min((double)Objects.requireNonNull(Executable.this.minBackoff).toMillis() * Math.pow(2.0, attempt - 1), (double)Objects.requireNonNull(Executable.this.maxBackoff).toMillis());
        }

        public Node getNode() {
            return this.node;
        }

        public ClientCall<ProtoRequestT, ResponseT> createCall() {
            return this.node.getChannel().newCall(Executable.this.getMethodDescriptor(), CallOptions.DEFAULT);
        }

        public ProtoRequestT getRequest() {
            return this.request;
        }

        public long getDelay() {
            return this.delay;
        }

        Throwable reactToConnectionFailure() {
            this.node.increaseDelay();
            Executable.this.logger.warn("Retrying node {} in {} ms after channel connection failure during attempt #{}", new Object[]{this.node.getAccountId(), this.node.getRemainingTimeForBackoff(), this.attempt});
            return new IllegalStateException("Failed to connect to node " + this.node.getAccountId());
        }

        boolean shouldRetryExceptionally(@Nullable Throwable e) {
            this.latency = (double)(System.nanoTime() - this.startAt) / 1.0E9;
            boolean retry = Executable.this.shouldRetryExceptionally(e);
            if (retry) {
                this.node.increaseDelay();
                Executable.this.logger.warn("Retrying node {} in {} ms after failure during attempt #{}: {}", new Object[]{this.node.getAccountId(), this.node.getRemainingTimeForBackoff(), this.attempt, e != null ? e.getMessage() : "NULL"});
            }
            return retry;
        }

        PrecheckStatusException mapStatusException() {
            return new PrecheckStatusException(this.responseStatus, Executable.this.getTransactionIdInternal());
        }

        O mapResponse() {
            return Executable.this.mapResponse(this.response, this.node.getAccountId(), this.request);
        }

        ExecutionState getStatus(ResponseT response) {
            this.node.decreaseDelay();
            this.response = response;
            this.responseStatus = Executable.this.mapResponseStatus(response);
            Executable.this.logger.trace("Received {} response in {} s from node {} during attempt #{}: {}", new Object[]{this.responseStatus, this.latency, this.node.getAccountId(), this.attempt, response});
            ExecutionState executionState = Executable.this.shouldRetry(this.responseStatus, response);
            switch (executionState) {
                case Retry: {
                    Executable.this.logger.warn("Retrying node {} in {} ms after failure during attempt #{}: {}", new Object[]{this.node.getAccountId(), this.delay, this.attempt, this.responseStatus});
                    break;
                }
                case ServerError: {
                    Executable.this.logger.warn("Problem submitting request to node {} for attempt #{}, retry with new node: {}", new Object[]{this.node.getAccountId(), this.attempt, this.responseStatus});
                    break;
                }
            }
            return executionState;
        }
    }
}

