/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.KeyList;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoAddLiveHashTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.LiveHash;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class LiveHashAddTransaction
extends com.hedera.hashgraph.sdk.Transaction<LiveHashAddTransaction> {
    @Nullable
    private AccountId accountId = null;
    private byte[] hash = new byte[0];
    @Nullable
    private KeyList keys = null;
    @Nullable
    private Duration duration = null;

    public LiveHashAddTransaction() {
    }

    LiveHashAddTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public LiveHashAddTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    public ByteString getHash() {
        return ByteString.copyFrom((byte[])this.hash);
    }

    public LiveHashAddTransaction setHash(byte[] hash) {
        this.requireNotFrozen();
        Objects.requireNonNull(hash);
        this.hash = hash;
        return this;
    }

    public LiveHashAddTransaction setHash(ByteString hash) {
        Objects.requireNonNull(hash);
        return this.setHash(hash.toByteArray());
    }

    @Nullable
    public Collection<Key> getKeys() {
        return this.keys;
    }

    public LiveHashAddTransaction setKeys(Key ... keys) {
        this.requireNotFrozen();
        this.keys = KeyList.of(keys);
        return this;
    }

    @Nullable
    public Duration getDuration() {
        return this.duration;
    }

    public LiveHashAddTransaction setDuration(Duration duration) {
        this.requireNotFrozen();
        Objects.requireNonNull(duration);
        this.duration = duration;
        return this;
    }

    void initFromTransactionBody() {
        CryptoAddLiveHashTransactionBody body = this.sourceTransactionBody.getCryptoAddLiveHash();
        LiveHash hashBody = body.getLiveHash();
        if (hashBody.hasAccountId()) {
            this.accountId = AccountId.fromProtobuf(hashBody.getAccountId());
        }
        this.hash = hashBody.getHash().toByteArray();
        if (hashBody.hasKeys()) {
            this.keys = KeyList.fromProtobuf(hashBody.getKeys(), null);
        }
        if (hashBody.hasDuration()) {
            this.duration = DurationConverter.fromProtobuf(hashBody.getDuration());
        }
    }

    CryptoAddLiveHashTransactionBody.Builder build() {
        CryptoAddLiveHashTransactionBody.Builder builder = CryptoAddLiveHashTransactionBody.newBuilder();
        LiveHash.Builder hashBuilder = LiveHash.newBuilder();
        if (this.accountId != null) {
            hashBuilder.setAccountId(this.accountId.toProtobuf());
        }
        hashBuilder.setHash(ByteString.copyFrom((byte[])this.hash));
        if (this.keys != null) {
            hashBuilder.setKeys(this.keys.toProtobuf());
        }
        if (this.duration != null) {
            hashBuilder.setDuration(DurationConverter.toProtobuf(this.duration));
        }
        return builder.setLiveHash(hashBuilder);
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getAddLiveHashMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoAddLiveHash(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        throw new IllegalStateException("Cannot schedule live hash transactions");
    }
}

