/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.LiveHash;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.proto.CryptoGetLiveHashQuery;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import io.grpc.MethodDescriptor;
import java.util.Objects;
import javax.annotation.Nullable;

public final class LiveHashQuery
extends Query<LiveHash, LiveHashQuery> {
    @Nullable
    private AccountId accountId = null;
    private byte[] hash = new byte[0];

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public LiveHashQuery setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.accountId = accountId;
        return this;
    }

    public ByteString getHash() {
        return ByteString.copyFrom((byte[])this.hash);
    }

    public LiveHashQuery setHash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        CryptoGetLiveHashQuery.Builder builder = CryptoGetLiveHashQuery.newBuilder();
        if (this.accountId != null) {
            builder.setAccountID(this.accountId.toProtobuf());
        }
        builder.setHash(ByteString.copyFrom((byte[])this.hash));
        queryBuilder.setCryptoGetLiveHash(builder.setHeader(header));
    }

    @Override
    LiveHash mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        return LiveHash.fromProtobuf(response.getCryptoGetLiveHash().getLiveHash());
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getCryptoGetLiveHash().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getCryptoGetLiveHash().getHeader();
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getCryptoGetBalanceMethod();
    }
}

