/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class ManagedNodeAddress {
    private static final Pattern HOST_AND_PORT = Pattern.compile("^(\\S+):(\\d+)$");
    private static final Pattern IN_PROCESS = Pattern.compile("^in-process:(\\S+)$");
    @Nullable
    private final String name;
    @Nullable
    private final String address;
    private final int port;

    public ManagedNodeAddress(@Nullable String name, @Nullable String address, int port) {
        this.name = name;
        this.address = address;
        this.port = port;
    }

    public static ManagedNodeAddress fromString(String string) {
        Matcher hostAndPortMatcher = HOST_AND_PORT.matcher(string);
        Matcher inProcessMatcher = IN_PROCESS.matcher(string);
        if (hostAndPortMatcher.matches() && hostAndPortMatcher.groupCount() == 2) {
            String address = hostAndPortMatcher.group(1);
            String port = hostAndPortMatcher.group(2);
            return new ManagedNodeAddress(null, address, Integer.parseInt(port));
        }
        if (inProcessMatcher.matches() && inProcessMatcher.groupCount() == 1) {
            return new ManagedNodeAddress(inProcessMatcher.group(1), null, 0);
        }
        throw new IllegalStateException("failed to parse node address");
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isInProcess() {
        return this.name != null;
    }

    public boolean isTransportSecurity() {
        return this.port == 50212 || this.port == 433;
    }

    public ManagedNodeAddress toInsecure() {
        int port = this.port;
        switch (this.port) {
            case 50212: {
                port = 50211;
                break;
            }
            case 433: {
                port = 5600;
            }
        }
        return new ManagedNodeAddress(this.name, this.address, port);
    }

    public ManagedNodeAddress toSecure() {
        int port = this.port;
        switch (this.port) {
            case 50211: {
                port = 50212;
                break;
            }
            case 5600: {
                port = 433;
            }
        }
        return new ManagedNodeAddress(this.name, this.address, port);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.address + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedNodeAddress that = (ManagedNodeAddress)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getAddress(), that.getAddress());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAddress(), this.getPort());
    }
}

