/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.NftID;
import com.hedera.hashgraph.sdk.proto.TokenID;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class NftId
implements Comparable<NftId> {
    public final TokenId tokenId;
    @Nonnegative
    public final long serial;

    public NftId(TokenId tokenId, @Nonnegative long serial) {
        this.tokenId = Objects.requireNonNull(tokenId);
        this.serial = serial;
    }

    public static NftId fromString(String id) {
        String[] parts = id.split("[/@]");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Expecting {shardNum}.{realmNum}.{idNum}-{checksum}/{serialNum}");
        }
        return new NftId(TokenId.fromString(parts[0]), Long.parseLong(parts[1]));
    }

    static NftId fromProtobuf(NftID nftId) {
        Objects.requireNonNull(nftId);
        TokenID tokenId = nftId.getTokenID();
        return new NftId(TokenId.fromProtobuf(tokenId), nftId.getSerialNumber());
    }

    public static NftId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return NftId.fromProtobuf((NftID)((NftID.Builder)NftID.parseFrom(bytes).toBuilder()).build());
    }

    NftID toProtobuf() {
        return (NftID)NftID.newBuilder().setTokenID(this.tokenId.toProtobuf()).setSerialNumber(this.serial).build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.tokenId.toString() + "/" + this.serial;
    }

    public String toStringWithChecksum(Client client) {
        return this.tokenId.toStringWithChecksum(client) + "/" + this.serial;
    }

    public int hashCode() {
        return Objects.hash(this.tokenId.shard, this.tokenId.realm, this.tokenId.num, this.serial);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NftId)) {
            return false;
        }
        NftId otherId = (NftId)o;
        return this.tokenId.equals(otherId.tokenId) && this.serial == otherId.serial;
    }

    @Override
    public int compareTo(NftId o) {
        Objects.requireNonNull(o);
        int tokenComparison = this.tokenId.compareTo(o.tokenId);
        if (tokenComparison != 0) {
            return tokenComparison;
        }
        return Long.compare(this.serial, o.serial);
    }
}

