/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Executable;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.MaxQueryPaymentExceededException;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransferTransaction;
import com.hedera.hashgraph.sdk.WithGetCost;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseCodeEnum;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.ResponseType;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public abstract class Query<O, T extends Query<O, T>>
extends Executable<T, com.hedera.hashgraph.sdk.proto.Query, Response, O>
implements WithGetCost {
    private final Query.Builder builder = com.hedera.hashgraph.sdk.proto.Query.newBuilder();
    private final QueryHeader.Builder headerBuilder = QueryHeader.newBuilder();
    @Nullable
    protected TransactionId paymentTransactionId = null;
    @Nullable
    protected List<Transaction> paymentTransactions = null;
    @Nullable
    private Client.Operator paymentOperator = null;
    @Nullable
    private Hbar queryPayment = null;
    @Nullable
    private Hbar maxQueryPayment = null;
    @Nullable
    private Hbar chosenQueryPayment = null;

    Query() {
    }

    private static Transaction makePaymentTransaction(TransactionId paymentTransactionId, AccountId nodeId, Client.Operator operator, Hbar paymentAmount) {
        return ((TransferTransaction)((TransferTransaction)((TransferTransaction)((TransferTransaction)((TransferTransaction)new TransferTransaction().setTransactionId(paymentTransactionId)).setNodeAccountIds((List)Collections.singletonList(nodeId))).setMaxTransactionFee(new Hbar(1L))).addHbarTransfer(operator.accountId, paymentAmount.negated()).addHbarTransfer(nodeId, paymentAmount).freeze()).signWith(operator.publicKey, operator.transactionSigner)).makeRequest();
    }

    public T setQueryPayment(Hbar queryPayment) {
        this.queryPayment = queryPayment;
        return (T)this;
    }

    public T setMaxQueryPayment(Hbar maxQueryPayment) {
        this.maxQueryPayment = maxQueryPayment;
        return (T)this;
    }

    @Override
    public Hbar getCost(Client client) throws TimeoutException, PrecheckStatusException {
        this.initWithNodeIds(client);
        return (Hbar)((QueryCostQuery)this.getCostExecutable().setNodeAccountIds((List)Objects.requireNonNull(this.getNodeAccountIds()))).execute(client);
    }

    @Override
    public CompletableFuture<Hbar> getCostAsync(Client client) {
        this.initWithNodeIds(client);
        return ((QueryCostQuery)this.getCostExecutable().setNodeAccountIds((List)Objects.requireNonNull(this.getNodeAccountIds()))).executeAsync(client);
    }

    boolean isPaymentRequired() {
        return true;
    }

    abstract void onMakeRequest(Query.Builder var1, QueryHeader var2);

    abstract ResponseHeader mapResponseHeader(Response var1);

    abstract QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query var1);

    private Query<Hbar, QueryCostQuery> getCostExecutable() {
        return new QueryCostQuery();
    }

    abstract void validateChecksums(Client var1) throws BadEntityIdException;

    Client.Operator getOperatorFromClient(Client client) {
        Client.Operator operator = client.getOperator();
        if (operator == null) {
            throw new IllegalStateException("`client` must have an `operator` or an explicit payment transaction must be provided");
        }
        return operator;
    }

    @Override
    void onExecute(Client client) throws TimeoutException, PrecheckStatusException {
        GrpcCostQuery grpcCostQuery = new GrpcCostQuery(client);
        if (grpcCostQuery.isNotRequired()) {
            return;
        }
        if (grpcCostQuery.getCost() == null) {
            grpcCostQuery.setCost(this.getCost(client));
            if (grpcCostQuery.shouldError()) {
                throw grpcCostQuery.mapError();
            }
        }
        grpcCostQuery.finish();
    }

    @Override
    CompletableFuture<Void> onExecuteAsync(Client client) {
        GrpcCostQuery grpcCostQuery = new GrpcCostQuery(client);
        if (grpcCostQuery.isNotRequired()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            if (grpcCostQuery.getCost() == null) {
                return this.getCostAsync(client).thenCompose(cost -> {
                    grpcCostQuery.setCost((Hbar)cost);
                    if (grpcCostQuery.shouldError()) {
                        return CompletableFuture.failedFuture(grpcCostQuery.mapError());
                    }
                    return CompletableFuture.completedFuture(null);
                });
            }
            return CompletableFuture.completedFuture(null);
        }, client.executor).thenCompose(x -> x)).thenAccept(paymentAmount -> grpcCostQuery.finish());
    }

    private void initWithNodeIds(Client client) {
        if (client.isAutoValidateChecksumsEnabled()) {
            try {
                this.validateChecksums(client);
            }
            catch (BadEntityIdException exc) {
                throw new IllegalArgumentException(exc.getMessage());
            }
        }
        if (this.nodeAccountIds.size() == 0) {
            try {
                this.nodeAccountIds = client.network.getNodeAccountIdsForExecute();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    Transaction getPaymentTransaction(int index) {
        Transaction paymentTx = Objects.requireNonNull(this.paymentTransactions).get(index);
        if (paymentTx != null) {
            return paymentTx;
        }
        this.paymentTransactionId = TransactionId.generate(Objects.requireNonNull(this.paymentOperator).accountId);
        Transaction newPaymentTx = Query.makePaymentTransaction(this.paymentTransactionId, (AccountId)this.nodeAccountIds.get(index), this.paymentOperator, Objects.requireNonNull(this.chosenQueryPayment));
        this.paymentTransactions.set(index, newPaymentTx);
        return newPaymentTx;
    }

    @Override
    final com.hedera.hashgraph.sdk.proto.Query makeRequest() {
        if (this.isPaymentRequired() && this.paymentTransactions != null) {
            this.headerBuilder.setPayment(this.getPaymentTransaction(this.nextNodeIndex));
        }
        this.onMakeRequest(this.builder, (QueryHeader)this.headerBuilder.setResponseType(ResponseType.ANSWER_ONLY).build());
        return (com.hedera.hashgraph.sdk.proto.Query)this.builder.build();
    }

    @Override
    Status mapResponseStatus(Response response) {
        ResponseCodeEnum preCheckCode = this.mapResponseHeader(response).getNodeTransactionPrecheckCode();
        return Status.valueOf(preCheckCode);
    }

    @Override
    @Nullable
    TransactionId getTransactionIdInternal() {
        return this.paymentTransactionId;
    }

    public String toString() {
        com.hedera.hashgraph.sdk.proto.Query request = this.makeRequest();
        StringBuilder builder = new StringBuilder(request.toString().replaceAll("(?m)^# com.hedera.hashgraph.sdk.proto.Query.*", ""));
        QueryHeader queryHeader = this.mapRequestHeader(request);
        if (queryHeader.hasPayment()) {
            builder.append("\n");
            try {
                builder.append(TransactionBody.parseFrom(queryHeader.getPayment().getBodyBytes()).toString().replaceAll("(?m)^# com.hedera.hashgraph.sdk.proto.TransactionBuilder.*", ""));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.toString();
    }

    private class QueryCostQuery
    extends Query<Hbar, QueryCostQuery> {
        private QueryCostQuery() {
        }

        @Override
        void validateChecksums(Client client) throws BadEntityIdException {
        }

        @Override
        void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
            Query.this.headerBuilder.setResponseType(ResponseType.COST_ANSWER);
            Query.this.headerBuilder.setPayment(((TransferTransaction)((TransferTransaction)((TransferTransaction)new TransferTransaction().setNodeAccountIds((List)Collections.singletonList(new AccountId(0L)))).setTransactionId(TransactionId.withValidStart(new AccountId(0L), Instant.ofEpochSecond(0L)))).freeze()).makeRequest());
            Query.this.onMakeRequest(queryBuilder, (QueryHeader)Query.this.headerBuilder.build());
        }

        @Override
        ResponseHeader mapResponseHeader(Response response) {
            return Query.this.mapResponseHeader(response);
        }

        @Override
        QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
            return Query.this.mapRequestHeader(request);
        }

        @Override
        Hbar mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
            return Hbar.fromTinybars(this.mapResponseHeader(response).getCost());
        }

        @Override
        MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
            return Query.this.getMethodDescriptor();
        }

        @Override
        boolean isPaymentRequired() {
            return false;
        }
    }

    private class GrpcCostQuery {
        private final Hbar maxCost;
        private final boolean notRequired;
        private Client.Operator operator;
        private Hbar cost;

        GrpcCostQuery(Client client) {
            Query.this.initWithNodeIds(client);
            this.cost = Query.this.queryPayment;
            this.notRequired = Query.this.paymentTransactions != null || !Query.this.isPaymentRequired();
            this.maxCost = (Hbar)MoreObjects.firstNonNull((Object)Query.this.maxQueryPayment, (Object)client.defaultMaxQueryPayment);
            if (!this.notRequired) {
                this.operator = Query.this.getOperatorFromClient(client);
            }
        }

        public Client.Operator getOperator() {
            return this.operator;
        }

        public Hbar getCost() {
            return this.cost;
        }

        public boolean isNotRequired() {
            return this.notRequired;
        }

        GrpcCostQuery setCost(Hbar cost) {
            this.cost = cost;
            return this;
        }

        boolean shouldError() {
            return this.cost.compareTo(this.maxCost) > 0;
        }

        MaxQueryPaymentExceededException mapError() {
            return new MaxQueryPaymentExceededException(Query.this, this.cost, this.maxCost);
        }

        void finish() {
            Query.this.chosenQueryPayment = this.cost;
            Query.this.paymentOperator = this.operator;
            Query.this.paymentTransactions = new ArrayList<Transaction>(Query.this.nodeAccountIds.size());
            for (int i = 0; i < Query.this.nodeAccountIds.size(); ++i) {
                Query.this.paymentTransactions.add(null);
            }
        }
    }
}

