/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.HederaFunctionality;

public enum RequestType {
    NONE(HederaFunctionality.NONE),
    CRYPTO_TRANSFER(HederaFunctionality.CryptoTransfer),
    CRYPTO_UPDATE(HederaFunctionality.CryptoUpdate),
    CRYPTO_DELETE(HederaFunctionality.CryptoDelete),
    CRYPTO_ADD_LIVE_HASH(HederaFunctionality.CryptoAddLiveHash),
    CRYPTO_DELETE_LIVE_HASH(HederaFunctionality.CryptoDeleteLiveHash),
    CONTRACT_CALL(HederaFunctionality.ContractCall),
    CONTRACT_CREATE(HederaFunctionality.ContractCreate),
    CONTRACT_UPDATE(HederaFunctionality.ContractUpdate),
    FILE_CREATE(HederaFunctionality.FileCreate),
    FILE_APPEND(HederaFunctionality.FileAppend),
    FILE_UPDATE(HederaFunctionality.FileUpdate),
    FILE_DELETE(HederaFunctionality.FileDelete),
    CRYPTO_GET_ACCOUNT_BALANCE(HederaFunctionality.CryptoGetAccountBalance),
    CRYPTO_GET_ACCOUNT_RECORDS(HederaFunctionality.CryptoGetAccountRecords),
    CRYPTO_GET_INFO(HederaFunctionality.CryptoGetInfo),
    CONTRACT_CALL_LOCAL(HederaFunctionality.ContractCallLocal),
    CONTRACT_GET_INFO(HederaFunctionality.ContractGetInfo),
    CONTRACT_GET_BYTECODE(HederaFunctionality.ContractGetBytecode),
    GET_BY_SOLIDITY_ID(HederaFunctionality.GetBySolidityID),
    GET_BY_KEY(HederaFunctionality.GetByKey),
    CRYPTO_GET_LIVE_HASH(HederaFunctionality.CryptoGetLiveHash),
    CRYPTO_GET_STAKERS(HederaFunctionality.CryptoGetStakers),
    FILE_GET_CONTENTS(HederaFunctionality.FileGetContents),
    FILE_GET_INFO(HederaFunctionality.FileGetInfo),
    TRANSACTION_GET_RECORD(HederaFunctionality.TransactionGetRecord),
    CONTRACT_GET_RECORDS(HederaFunctionality.ContractGetRecords),
    CRYPTO_CREATE(HederaFunctionality.CryptoCreate),
    SYSTEM_DELETE(HederaFunctionality.SystemDelete),
    SYSTEM_UNDELETE(HederaFunctionality.SystemUndelete),
    CONTRACT_DELETE(HederaFunctionality.ContractDelete),
    FREEZE(HederaFunctionality.Freeze),
    CREATE_TRANSACTION_RECORD(HederaFunctionality.CreateTransactionRecord),
    CRYPTO_ACCOUNT_AUTO_RENEW(HederaFunctionality.CryptoAccountAutoRenew),
    CONTRACT_AUTO_RENEW(HederaFunctionality.ContractAutoRenew),
    GET_VERSION_INFO(HederaFunctionality.GetVersionInfo),
    TRANSACTION_GET_RECEIPT(HederaFunctionality.TransactionGetReceipt),
    CONSENSUS_CREATE_TOPIC(HederaFunctionality.ConsensusCreateTopic),
    CONSENSUS_UPDATE_TOPIC(HederaFunctionality.ConsensusUpdateTopic),
    CONSENSUS_DELETE_TOPIC(HederaFunctionality.ConsensusDeleteTopic),
    CONSENSUS_GET_TOPIC_INFO(HederaFunctionality.ConsensusGetTopicInfo),
    CONSENSUS_SUBMIT_MESSAGE(HederaFunctionality.ConsensusSubmitMessage),
    UNCHECKED_SUBMIT(HederaFunctionality.UncheckedSubmit),
    TOKEN_CREATE(HederaFunctionality.TokenCreate),
    TOKEN_GET_INFO(HederaFunctionality.TokenGetInfo),
    TOKEN_FREEZE_ACCOUNT(HederaFunctionality.TokenFreezeAccount),
    TOKEN_UNFREEZE_ACCOUNT(HederaFunctionality.TokenUnfreezeAccount),
    TOKEN_GRANT_KYC_TO_ACCOUNT(HederaFunctionality.TokenGrantKycToAccount),
    TOKEN_REVOKE_KYC_FROM_ACCOUNT(HederaFunctionality.TokenRevokeKycFromAccount),
    TOKEN_DELETE(HederaFunctionality.TokenDelete),
    TOKEN_UPDATE(HederaFunctionality.TokenUpdate),
    TOKEN_MINT(HederaFunctionality.TokenMint),
    TOKEN_BURN(HederaFunctionality.TokenBurn),
    TOKEN_ACCOUNT_WIPE(HederaFunctionality.TokenAccountWipe),
    TOKEN_ASSOCIATE_TO_ACCOUNT(HederaFunctionality.TokenAssociateToAccount),
    TOKEN_DISSOCIATE_FROM_ACCOUNT(HederaFunctionality.TokenDissociateFromAccount),
    SCHEDULE_CREATE(HederaFunctionality.ScheduleCreate),
    SCHEDULE_DELETE(HederaFunctionality.ScheduleDelete),
    SCHEDULE_SIGN(HederaFunctionality.ScheduleSign),
    SCHEDULE_GET_INFO(HederaFunctionality.ScheduleGetInfo),
    TOKEN_GET_ACCOUNT_NFT_INFOS(HederaFunctionality.TokenGetAccountNftInfos),
    TOKEN_GET_NFT_INFO(HederaFunctionality.TokenGetNftInfo),
    TOKEN_GET_NFT_INFOS(HederaFunctionality.TokenGetNftInfos),
    TOKEN_FEE_SCHEDULE_UPDATE(HederaFunctionality.TokenFeeScheduleUpdate),
    NETWORK_GET_EXECUTION_TIME(HederaFunctionality.NetworkGetExecutionTime),
    TOKEN_PAUSE(HederaFunctionality.TokenPause),
    TOKEN_UNPAUSE(HederaFunctionality.TokenUnpause);

    final HederaFunctionality code;

    private RequestType(HederaFunctionality code) {
        this.code = code;
    }

    static RequestType valueOf(HederaFunctionality code) {
        switch (code) {
            case NONE: {
                return NONE;
            }
            case CryptoTransfer: {
                return CRYPTO_TRANSFER;
            }
            case CryptoUpdate: {
                return CRYPTO_UPDATE;
            }
            case CryptoDelete: {
                return CRYPTO_DELETE;
            }
            case CryptoAddLiveHash: {
                return CRYPTO_ADD_LIVE_HASH;
            }
            case CryptoDeleteLiveHash: {
                return CRYPTO_DELETE_LIVE_HASH;
            }
            case ContractCall: {
                return CONTRACT_CALL;
            }
            case ContractCreate: {
                return CONTRACT_CREATE;
            }
            case ContractUpdate: {
                return CONTRACT_UPDATE;
            }
            case FileCreate: {
                return FILE_CREATE;
            }
            case FileAppend: {
                return FILE_APPEND;
            }
            case FileUpdate: {
                return FILE_UPDATE;
            }
            case FileDelete: {
                return FILE_DELETE;
            }
            case CryptoGetAccountBalance: {
                return CRYPTO_GET_ACCOUNT_BALANCE;
            }
            case CryptoGetAccountRecords: {
                return CRYPTO_GET_ACCOUNT_RECORDS;
            }
            case CryptoGetInfo: {
                return CRYPTO_GET_INFO;
            }
            case ContractCallLocal: {
                return CONTRACT_CALL_LOCAL;
            }
            case ContractGetInfo: {
                return CONTRACT_GET_INFO;
            }
            case ContractGetBytecode: {
                return CONTRACT_GET_BYTECODE;
            }
            case GetBySolidityID: {
                return GET_BY_SOLIDITY_ID;
            }
            case GetByKey: {
                return GET_BY_KEY;
            }
            case CryptoGetLiveHash: {
                return CRYPTO_GET_LIVE_HASH;
            }
            case CryptoGetStakers: {
                return CRYPTO_GET_STAKERS;
            }
            case FileGetContents: {
                return FILE_GET_CONTENTS;
            }
            case FileGetInfo: {
                return FILE_GET_INFO;
            }
            case TransactionGetRecord: {
                return TRANSACTION_GET_RECORD;
            }
            case ContractGetRecords: {
                return CONTRACT_GET_RECORDS;
            }
            case CryptoCreate: {
                return CRYPTO_CREATE;
            }
            case SystemDelete: {
                return SYSTEM_DELETE;
            }
            case SystemUndelete: {
                return SYSTEM_UNDELETE;
            }
            case ContractDelete: {
                return CONTRACT_DELETE;
            }
            case Freeze: {
                return FREEZE;
            }
            case CreateTransactionRecord: {
                return CREATE_TRANSACTION_RECORD;
            }
            case CryptoAccountAutoRenew: {
                return CRYPTO_ACCOUNT_AUTO_RENEW;
            }
            case ContractAutoRenew: {
                return CONTRACT_AUTO_RENEW;
            }
            case GetVersionInfo: {
                return GET_VERSION_INFO;
            }
            case TransactionGetReceipt: {
                return TRANSACTION_GET_RECEIPT;
            }
            case ConsensusCreateTopic: {
                return CONSENSUS_CREATE_TOPIC;
            }
            case ConsensusUpdateTopic: {
                return CONSENSUS_UPDATE_TOPIC;
            }
            case ConsensusDeleteTopic: {
                return CONSENSUS_DELETE_TOPIC;
            }
            case ConsensusGetTopicInfo: {
                return CONSENSUS_GET_TOPIC_INFO;
            }
            case ConsensusSubmitMessage: {
                return CONSENSUS_SUBMIT_MESSAGE;
            }
            case UncheckedSubmit: {
                return UNCHECKED_SUBMIT;
            }
            case TokenCreate: {
                return TOKEN_CREATE;
            }
            case TokenGetInfo: {
                return TOKEN_GET_INFO;
            }
            case TokenFreezeAccount: {
                return TOKEN_FREEZE_ACCOUNT;
            }
            case TokenUnfreezeAccount: {
                return TOKEN_UNFREEZE_ACCOUNT;
            }
            case TokenGrantKycToAccount: {
                return TOKEN_GRANT_KYC_TO_ACCOUNT;
            }
            case TokenRevokeKycFromAccount: {
                return TOKEN_REVOKE_KYC_FROM_ACCOUNT;
            }
            case TokenDelete: {
                return TOKEN_DELETE;
            }
            case TokenUpdate: {
                return TOKEN_UPDATE;
            }
            case TokenMint: {
                return TOKEN_MINT;
            }
            case TokenBurn: {
                return TOKEN_BURN;
            }
            case TokenAccountWipe: {
                return TOKEN_ACCOUNT_WIPE;
            }
            case TokenAssociateToAccount: {
                return TOKEN_ASSOCIATE_TO_ACCOUNT;
            }
            case TokenDissociateFromAccount: {
                return TOKEN_DISSOCIATE_FROM_ACCOUNT;
            }
            case ScheduleCreate: {
                return SCHEDULE_CREATE;
            }
            case ScheduleDelete: {
                return SCHEDULE_DELETE;
            }
            case ScheduleSign: {
                return SCHEDULE_SIGN;
            }
            case ScheduleGetInfo: {
                return SCHEDULE_GET_INFO;
            }
            case TokenGetAccountNftInfos: {
                return TOKEN_GET_ACCOUNT_NFT_INFOS;
            }
            case TokenGetNftInfo: {
                return TOKEN_GET_NFT_INFO;
            }
            case TokenGetNftInfos: {
                return TOKEN_GET_NFT_INFOS;
            }
            case TokenFeeScheduleUpdate: {
                return TOKEN_FEE_SCHEDULE_UPDATE;
            }
            case NetworkGetExecutionTime: {
                return NETWORK_GET_EXECUTION_TIME;
            }
            case TokenPause: {
                return TOKEN_PAUSE;
            }
            case TokenUnpause: {
                return TOKEN_UNPAUSE;
            }
        }
        throw new IllegalStateException("(BUG) unhandled HederaFunctionality");
    }

    public String toString() {
        switch (this) {
            case NONE: {
                return "NONE";
            }
            case CRYPTO_TRANSFER: {
                return "CRYPTO_TRANSFER";
            }
            case CRYPTO_UPDATE: {
                return "CRYPTO_UPDATE";
            }
            case CRYPTO_DELETE: {
                return "CRYPTO_DELETE";
            }
            case CRYPTO_ADD_LIVE_HASH: {
                return "CRYPTO_ADD_LIVE_HASH";
            }
            case CRYPTO_DELETE_LIVE_HASH: {
                return "CRYPTO_DELETE_LIVE_HASH";
            }
            case CONTRACT_CALL: {
                return "CONTRACT_CALL";
            }
            case CONTRACT_CREATE: {
                return "CONTRACT_CREATE";
            }
            case CONTRACT_UPDATE: {
                return "CONTRACT_UPDATE";
            }
            case FILE_CREATE: {
                return "FILE_CREATE";
            }
            case FILE_APPEND: {
                return "FILE_APPEND";
            }
            case FILE_UPDATE: {
                return "FILE_UPDATE";
            }
            case FILE_DELETE: {
                return "FILE_DELETE";
            }
            case CRYPTO_GET_ACCOUNT_BALANCE: {
                return "CRYPTO_GET_ACCOUNT_BALANCE";
            }
            case CRYPTO_GET_ACCOUNT_RECORDS: {
                return "CRYPTO_GET_ACCOUNT_RECORDS";
            }
            case CRYPTO_GET_INFO: {
                return "CRYPTO_GET_INFO";
            }
            case CONTRACT_CALL_LOCAL: {
                return "CONTRACT_CALL_LOCAL";
            }
            case CONTRACT_GET_INFO: {
                return "CONTRACT_GET_INFO";
            }
            case CONTRACT_GET_BYTECODE: {
                return "CONTRACT_GET_BYTECODE";
            }
            case GET_BY_SOLIDITY_ID: {
                return "GET_BY_SOLIDITY_ID";
            }
            case GET_BY_KEY: {
                return "GET_BY_KEY";
            }
            case CRYPTO_GET_LIVE_HASH: {
                return "CRYPTO_GET_LIVE_HASH";
            }
            case CRYPTO_GET_STAKERS: {
                return "CRYPTO_GET_STAKERS";
            }
            case FILE_GET_CONTENTS: {
                return "FILE_GET_CONTENTS";
            }
            case FILE_GET_INFO: {
                return "FILE_GET_INFO";
            }
            case TRANSACTION_GET_RECORD: {
                return "TRANSACTION_GET_RECORD";
            }
            case CONTRACT_GET_RECORDS: {
                return "CONTRACT_GET_RECORDS";
            }
            case CRYPTO_CREATE: {
                return "CRYPTO_CREATE";
            }
            case SYSTEM_DELETE: {
                return "SYSTEM_DELETE";
            }
            case SYSTEM_UNDELETE: {
                return "SYSTEM_UNDELETE";
            }
            case CONTRACT_DELETE: {
                return "CONTRACT_DELETE";
            }
            case FREEZE: {
                return "FREEZE";
            }
            case CREATE_TRANSACTION_RECORD: {
                return "CREATE_TRANSACTION_RECORD";
            }
            case CRYPTO_ACCOUNT_AUTO_RENEW: {
                return "CRYPTO_ACCOUNT_AUTO_RENEW";
            }
            case CONTRACT_AUTO_RENEW: {
                return "CONTRACT_AUTO_RENEW";
            }
            case GET_VERSION_INFO: {
                return "GET_VERSION_INFO";
            }
            case TRANSACTION_GET_RECEIPT: {
                return "TRANSACTION_GET_RECEIPT";
            }
            case CONSENSUS_CREATE_TOPIC: {
                return "CONSENSUS_CREATE_TOPIC";
            }
            case CONSENSUS_UPDATE_TOPIC: {
                return "CONSENSUS_UPDATE_TOPIC";
            }
            case CONSENSUS_DELETE_TOPIC: {
                return "CONSENSUS_DELETE_TOPIC";
            }
            case CONSENSUS_GET_TOPIC_INFO: {
                return "CONSENSUS_GET_TOPIC_INFO";
            }
            case CONSENSUS_SUBMIT_MESSAGE: {
                return "CONSENSUS_SUBMIT_MESSAGE";
            }
            case UNCHECKED_SUBMIT: {
                return "UNCHECKED_SUBMIT";
            }
            case TOKEN_CREATE: {
                return "TOKEN_CREATE";
            }
            case TOKEN_GET_INFO: {
                return "TOKEN_GET_INFO";
            }
            case TOKEN_FREEZE_ACCOUNT: {
                return "TOKEN_FREEZE_ACCOUNT";
            }
            case TOKEN_UNFREEZE_ACCOUNT: {
                return "TOKEN_UNFREEZE_ACCOUNT";
            }
            case TOKEN_GRANT_KYC_TO_ACCOUNT: {
                return "TOKEN_GRANT_KYC_TO_ACCOUNT";
            }
            case TOKEN_REVOKE_KYC_FROM_ACCOUNT: {
                return "TOKEN_REVOKE_KYC_FROM_ACCOUNT";
            }
            case TOKEN_DELETE: {
                return "TOKEN_DELETE";
            }
            case TOKEN_UPDATE: {
                return "TOKEN_UPDATE";
            }
            case TOKEN_MINT: {
                return "TOKEN_MINT";
            }
            case TOKEN_BURN: {
                return "TOKEN_BURN";
            }
            case TOKEN_ACCOUNT_WIPE: {
                return "TOKEN_ACCOUNT_WIPE";
            }
            case TOKEN_ASSOCIATE_TO_ACCOUNT: {
                return "TOKEN_ASSOCIATE_TO_ACCOUNT";
            }
            case TOKEN_DISSOCIATE_FROM_ACCOUNT: {
                return "TOKEN_DISSOCIATE_FROM_ACCOUNT";
            }
            case SCHEDULE_CREATE: {
                return "SCHEDULE_CREATE";
            }
            case SCHEDULE_DELETE: {
                return "SCHEDULE_DELETE";
            }
            case SCHEDULE_SIGN: {
                return "SCHEDULE_SIGN";
            }
            case SCHEDULE_GET_INFO: {
                return "SCHEDULE_GET_INFO";
            }
            case TOKEN_GET_ACCOUNT_NFT_INFOS: {
                return "TOKEN_GET_ACCOUNT_NFT_INFOS";
            }
            case TOKEN_GET_NFT_INFO: {
                return "TOKEN_GET_NFT_INFO";
            }
            case TOKEN_GET_NFT_INFOS: {
                return "TOKEN_GET_NFT_INFOS";
            }
            case TOKEN_FEE_SCHEDULE_UPDATE: {
                return "TOKEN_FEE_SCHEDULE_UPDATE";
            }
            case NETWORK_GET_EXECUTION_TIME: {
                return "NETWORK_GET_EXECUTION_TIME";
            }
            case TOKEN_PAUSE: {
                return "TOKEN_PAUSE";
            }
            case TOKEN_UNPAUSE: {
                return "TOKEN_UNPAUSE";
            }
        }
        return "<UNRECOGNIZED VALUE>";
    }
}

