/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SystemUndeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public final class SystemUndeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<SystemUndeleteTransaction> {
    @Nullable
    private FileId fileId;
    @Nullable
    private ContractId contractId;

    public SystemUndeleteTransaction() {
    }

    SystemUndeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    SystemUndeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public final FileId getFileId() {
        return this.fileId;
    }

    public final SystemUndeleteTransaction setFileId(FileId fileId) {
        Objects.requireNonNull(fileId);
        this.requireNotFrozen();
        this.fileId = fileId;
        return this;
    }

    @Nullable
    public final ContractId getContractId() {
        return this.contractId;
    }

    public final SystemUndeleteTransaction setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.requireNotFrozen();
        this.contractId = contractId;
        return this;
    }

    void initFromTransactionBody() {
        SystemUndeleteTransactionBody body = this.sourceTransactionBody.getSystemUndelete();
        if (body.hasFileID()) {
            this.fileId = FileId.fromProtobuf(body.getFileID());
        }
        if (body.hasContractID()) {
            this.contractId = ContractId.fromProtobuf(body.getContractID());
        }
    }

    SystemUndeleteTransactionBody.Builder build() {
        SystemUndeleteTransactionBody.Builder builder = SystemUndeleteTransactionBody.newBuilder();
        if (this.fileId != null) {
            builder.setFileID(this.fileId.toProtobuf());
        }
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.fileId != null) {
            this.fileId.validateChecksum(client);
        }
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
    }

    @Override
    CompletableFuture<Void> onExecuteAsync(Client client) {
        int modesEnabled = (this.fileId != null ? 1 : 0) + (this.contractId != null ? 1 : 0);
        if (modesEnabled != 1) {
            throw new IllegalStateException("SystemDeleteTransaction must have exactly 1 of the following fields set: contractId, fileId");
        }
        return super.onExecuteAsync(client);
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        if (this.fileId != null) {
            return FileServiceGrpc.getSystemUndeleteMethod();
        }
        return SmartContractServiceGrpc.getSystemUndeleteMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setSystemUndelete(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setSystemUndelete(this.build());
    }
}

