/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.proto.TokenGetNftInfoResponse;
import java.time.Instant;
import java.util.Objects;

public class TokenNftInfo {
    public final NftId nftId;
    public final AccountId accountId;
    public final Instant creationTime;
    public final byte[] metadata;
    public final LedgerId ledgerId;

    private TokenNftInfo(NftId nftId, AccountId accountId, Instant creationTime, byte[] metadata, LedgerId ledgerId) {
        this.nftId = nftId;
        this.accountId = accountId;
        this.creationTime = Objects.requireNonNull(creationTime);
        this.metadata = metadata;
        this.ledgerId = ledgerId;
    }

    static TokenNftInfo fromProtobuf(com.hedera.hashgraph.sdk.proto.TokenNftInfo info) {
        return new TokenNftInfo(NftId.fromProtobuf(info.getNftID()), AccountId.fromProtobuf(info.getAccountID()), InstantConverter.fromProtobuf(info.getCreationTime()), info.getMetadata().toByteArray(), LedgerId.fromByteString(info.getLedgerId()));
    }

    public static TokenNftInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenNftInfo.fromProtobuf(((TokenGetNftInfoResponse)((TokenGetNftInfoResponse.Builder)TokenGetNftInfoResponse.parseFrom(bytes).toBuilder()).build()).getNft());
    }

    TokenGetNftInfoResponse toProtobuf() {
        return (TokenGetNftInfoResponse)TokenGetNftInfoResponse.newBuilder().setNft(com.hedera.hashgraph.sdk.proto.TokenNftInfo.newBuilder().setNftID(this.nftId.toProtobuf()).setAccountID(this.accountId.toProtobuf()).setCreationTime(InstantConverter.toProtobuf(this.creationTime)).setMetadata(ByteString.copyFrom((byte[])this.metadata)).setLedgerId(this.ledgerId.toByteString())).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nftId", (Object)this.nftId).add("accountId", (Object)this.accountId).add("creationTime", (Object)this.creationTime).add("metadata", (Object)this.metadata).add("ledgerId", (Object)this.ledgerId).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

