/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.proto.NftTransfer;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenNftTransfer
implements Comparable<TokenNftTransfer> {
    public final AccountId sender;
    public final AccountId receiver;
    public final long serial;

    TokenNftTransfer(AccountId sender, AccountId receiver, long serial) {
        this.sender = sender;
        this.receiver = receiver;
        this.serial = serial;
    }

    static TokenNftTransfer fromProtobuf(NftTransfer nftTransfer) {
        return new TokenNftTransfer(AccountId.fromProtobuf(nftTransfer.getSenderAccountID()), AccountId.fromProtobuf(nftTransfer.getReceiverAccountID()), nftTransfer.getSerialNumber());
    }

    public static TokenNftTransfer fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenNftTransfer.fromProtobuf((NftTransfer)((NftTransfer.Builder)NftTransfer.parseFrom(bytes).toBuilder()).build());
    }

    NftTransfer toProtobuf() {
        return (NftTransfer)NftTransfer.newBuilder().setSenderAccountID(this.sender.toProtobuf()).setReceiverAccountID(this.receiver.toProtobuf()).setSerialNumber(this.serial).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sender", (Object)this.sender).add("receiver", (Object)this.receiver).add("serial", this.serial).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    @Override
    public int compareTo(TokenNftTransfer o) {
        int senderComparison = this.sender.compareTo(o.sender);
        if (senderComparison != 0) {
            return senderComparison;
        }
        int receiverComparison = this.receiver.compareTo(o.receiver);
        if (receiverComparison != 0) {
            return receiverComparison;
        }
        return Long.compare(this.serial, o.serial);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenNftTransfer)) {
            return false;
        }
        TokenNftTransfer otherTransfer = (TokenNftTransfer)o;
        return this.sender.equals(otherTransfer.sender) && this.receiver.equals(otherTransfer.receiver) && this.serial == otherTransfer.serial;
    }

    public int hashCode() {
        return Objects.hash(this.sender.hashCode(), this.receiver.hashCode(), this.serial);
    }
}

