/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UInt32Value;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftTransfer;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.AccountAmount;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.CryptoTransferTransactionBody;
import com.hedera.hashgraph.sdk.proto.NftTransfer;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenTransferList;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.proto.TransferList;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TransferTransaction
extends com.hedera.hashgraph.sdk.Transaction<TransferTransaction> {
    private final Map<TokenId, TokenTransferMap> tokenTransfers = new HashMap<TokenId, TokenTransferMap>();
    private final Map<TokenId, List<TokenNftTransfer>> nftTransfers = new HashMap<TokenId, List<TokenNftTransfer>>();
    private final Map<AccountId, Hbar> hbarTransfers = new HashMap<AccountId, Hbar>();

    public TransferTransaction() {
        this.defaultMaxTransactionFee = new Hbar(1L);
    }

    TransferTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TransferTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    public Map<TokenId, Integer> getTokenIdDecimals() {
        HashMap<TokenId, Integer> decimalsMap = new HashMap<TokenId, Integer>();
        for (Map.Entry<TokenId, TokenTransferMap> tokenEntry : this.tokenTransfers.entrySet()) {
            UInt32Value decimals;
            if (tokenEntry.getValue() == null || (decimals = tokenEntry.getValue().getExpectedDecimals()) == null) continue;
            decimalsMap.put(tokenEntry.getKey(), decimals.getValue());
        }
        return decimalsMap;
    }

    private static void doAddTokenTransfer(Map<AccountId, Long> tokenTransferMap, AccountId accountId, long amount) {
        Objects.requireNonNull(tokenTransferMap);
        Objects.requireNonNull(accountId);
        long current = tokenTransferMap.containsKey(accountId) ? Objects.requireNonNull(tokenTransferMap.get(accountId)) : 0L;
        tokenTransferMap.put(accountId, current + amount);
    }

    public Map<TokenId, Map<AccountId, Long>> getTokenTransfers() {
        HashMap<TokenId, Map<AccountId, Long>> retval = new HashMap<TokenId, Map<AccountId, Long>>();
        for (Map.Entry<TokenId, TokenTransferMap> entry : this.tokenTransfers.entrySet()) {
            retval.put(entry.getKey(), entry.getValue().transfers);
        }
        return retval;
    }

    public TransferTransaction addTokenTransfer(TokenId tokenId, AccountId accountId, long value) {
        this.requireNotFrozen();
        TransferTransaction.doAddTokenTransfer(this.getTokenTransferMap((TokenId)tokenId).transfers, accountId, value);
        return this;
    }

    public TransferTransaction addTokenTransferWithDecimals(TokenId tokenId, AccountId accountId, long value, int decimals) {
        this.requireNotFrozen();
        TransferTransaction.doAddTokenTransfer(this.getTokenTransferMap((TokenId)tokenId).setExpectedDecimals((UInt32Value)UInt32Value.of((int)decimals)).transfers, accountId, value);
        return this;
    }

    public Map<TokenId, List<TokenNftTransfer>> getTokenNftTransfers() {
        return new HashMap<TokenId, List<TokenNftTransfer>>(this.nftTransfers);
    }

    public TransferTransaction addNftTransfer(NftId nftId, AccountId sender, AccountId receiver) {
        this.requireNotFrozen();
        this.getNftTransferList(nftId.tokenId).add(new TokenNftTransfer(sender, receiver, nftId.serial));
        return this;
    }

    public Map<AccountId, Hbar> getHbarTransfers() {
        return new HashMap<AccountId, Hbar>(this.hbarTransfers);
    }

    public TransferTransaction addHbarTransfer(AccountId accountId, Hbar value) {
        this.requireNotFrozen();
        this.doAddHbarTransfer(accountId, value.toTinybars());
        return this;
    }

    CryptoTransferTransactionBody.Builder build() {
        ArrayList<SortableTokenTransferList> transferLists = new ArrayList<SortableTokenTransferList>();
        for (Map.Entry<TokenId, TokenTransferMap> entry : this.tokenTransfers.entrySet()) {
            transferLists.add(SortableTokenTransferList.forTransfers(entry));
        }
        for (Map.Entry<TokenId, Object> entry : this.nftTransfers.entrySet()) {
            transferLists.add(SortableTokenTransferList.forNftTransfers(entry));
        }
        Collections.sort(transferLists);
        ArrayList<Map.Entry<AccountId, Hbar>> hbarTransferList = new ArrayList<Map.Entry<AccountId, Hbar>>();
        hbarTransferList.addAll(this.hbarTransfers.entrySet());
        Collections.sort(hbarTransferList, (o1, o2) -> ((AccountId)o1.getKey()).compareTo((AccountId)o2.getKey()));
        CryptoTransferTransactionBody.Builder builder = CryptoTransferTransactionBody.newBuilder();
        for (SortableTokenTransferList list : transferLists) {
            TokenTransferList.Builder builder2 = TokenTransferList.newBuilder().setToken(list.tokenId.toProtobuf());
            if (list.expectedDecimals != null) {
                builder2.setExpectedDecimals(list.expectedDecimals);
            }
            for (Map.Entry<AccountId, Long> transfer : list.transfers) {
                builder2.addTransfers(AccountAmount.newBuilder().setAccountID(transfer.getKey().toProtobuf()).setAmount(transfer.getValue()));
            }
            for (TokenNftTransfer nftTransfer : list.nftTransfers) {
                builder2.addNftTransfers(nftTransfer.toProtobuf());
            }
            builder.addTokenTransfers(builder2);
        }
        TransferList.Builder list = TransferList.newBuilder();
        for (Map.Entry entry : hbarTransferList) {
            list.addAccountAmounts(AccountAmount.newBuilder().setAccountID(((AccountId)entry.getKey()).toProtobuf()).setAmount(((Hbar)entry.getValue()).toTinybars()));
        }
        builder.setTransfers(list);
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        for (AccountId accountId : this.hbarTransfers.keySet()) {
            accountId.validateChecksum(client);
        }
        for (Map.Entry entry : this.nftTransfers.entrySet()) {
            ((TokenId)entry.getKey()).validateChecksum(client);
            for (TokenNftTransfer nftTransfer : (List)entry.getValue()) {
                nftTransfer.sender.validateChecksum(client);
                nftTransfer.receiver.validateChecksum(client);
            }
        }
        for (Map.Entry entry : this.tokenTransfers.entrySet()) {
            ((TokenId)entry.getKey()).validateChecksum(client);
            for (AccountId a : ((TokenTransferMap)entry.getValue()).transfers.keySet()) {
                a.validateChecksum(client);
            }
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getCryptoTransferMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoTransfer(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoTransfer(this.build());
    }

    private TokenTransferMap getTokenTransferMap(TokenId tokenId) {
        TokenTransferMap map = this.tokenTransfers.containsKey(tokenId) ? Objects.requireNonNull(this.tokenTransfers.get(tokenId)) : new TokenTransferMap();
        this.tokenTransfers.put(tokenId, map);
        return map;
    }

    private List<TokenNftTransfer> getNftTransferList(TokenId tokenId) {
        ArrayList<TokenNftTransfer> list = this.nftTransfers.containsKey(tokenId) ? Objects.requireNonNull(this.nftTransfers.get(tokenId)) : new ArrayList<TokenNftTransfer>();
        this.nftTransfers.put(tokenId, list);
        return list;
    }

    private void doAddHbarTransfer(AccountId accountId, long amount) {
        Objects.requireNonNull(accountId);
        long current = this.hbarTransfers.containsKey(accountId) ? Objects.requireNonNull(this.hbarTransfers.get(accountId)).toTinybars() : 0L;
        this.hbarTransfers.put(accountId, Hbar.fromTinybars(current + amount));
    }

    void initFromTransactionBody() {
        CryptoTransferTransactionBody body = this.sourceTransactionBody.getCryptoTransfer();
        if (body.hasTransfers()) {
            for (AccountAmount transfer : body.getTransfers().getAccountAmountsList()) {
                this.doAddHbarTransfer(AccountId.fromProtobuf(transfer.getAccountID()), transfer.getAmount());
            }
        }
        for (TokenTransferList tokenTransferList : body.getTokenTransfersList()) {
            TokenId token = TokenId.fromProtobuf(tokenTransferList.getToken());
            if (tokenTransferList.getTransfersCount() > 0) {
                TokenTransferMap map = this.getTokenTransferMap(token);
                if (tokenTransferList.hasExpectedDecimals()) {
                    map.setExpectedDecimals(tokenTransferList.getExpectedDecimals());
                }
                for (AccountAmount aa : tokenTransferList.getTransfersList()) {
                    TransferTransaction.doAddTokenTransfer(map.transfers, AccountId.fromProtobuf(aa.getAccountID()), aa.getAmount());
                }
            }
            if (tokenTransferList.getNftTransfersCount() <= 0) continue;
            List<TokenNftTransfer> list = this.getNftTransferList(token);
            for (NftTransfer nftTransfer : tokenTransferList.getNftTransfersList()) {
                list.add(TokenNftTransfer.fromProtobuf(nftTransfer));
            }
        }
    }

    private static class TokenTransferMap {
        public final Map<AccountId, Long> transfers = new HashMap<AccountId, Long>();
        @Nullable
        private UInt32Value expectedDecimals = null;

        private TokenTransferMap() {
        }

        @Nullable
        public UInt32Value getExpectedDecimals() {
            return this.expectedDecimals;
        }

        public TokenTransferMap setExpectedDecimals(UInt32Value amount) {
            if (this.expectedDecimals != null && !amount.equals((Object)this.expectedDecimals)) {
                throw new IllegalArgumentException("expected decimals for a token in a token transfer cannot be changed after being set");
            }
            this.expectedDecimals = amount;
            return this;
        }
    }

    private static class SortableTokenTransferList
    implements Comparable<SortableTokenTransferList> {
        public final TokenId tokenId;
        @Nullable
        public final UInt32Value expectedDecimals;
        public final List<Map.Entry<AccountId, Long>> transfers;
        public final List<TokenNftTransfer> nftTransfers;

        private SortableTokenTransferList(TokenId tokenId, @Nullable UInt32Value expectedDecimals, List<Map.Entry<AccountId, Long>> transfers, List<TokenNftTransfer> nftTransfers) {
            this.tokenId = tokenId;
            this.expectedDecimals = expectedDecimals;
            this.transfers = transfers;
            this.nftTransfers = nftTransfers;
        }

        public static SortableTokenTransferList forTransfers(Map.Entry<TokenId, TokenTransferMap> transfersEntry) {
            SortableTokenTransferList retval = new SortableTokenTransferList(transfersEntry.getKey(), transfersEntry.getValue().getExpectedDecimals(), new ArrayList<Map.Entry<AccountId, Long>>(), Collections.emptyList());
            retval.transfers.addAll(transfersEntry.getValue().transfers.entrySet());
            Collections.sort(retval.transfers, (o1, o2) -> ((AccountId)o1.getKey()).compareTo((AccountId)o2.getKey()));
            return retval;
        }

        public static SortableTokenTransferList forNftTransfers(Map.Entry<TokenId, List<TokenNftTransfer>> nftTransfersEntry) {
            SortableTokenTransferList retval = new SortableTokenTransferList(nftTransfersEntry.getKey(), null, Collections.emptyList(), nftTransfersEntry.getValue());
            Collections.sort(retval.nftTransfers);
            return retval;
        }

        @Override
        public int compareTo(SortableTokenTransferList o) {
            return this.tokenId.compareTo(o.tokenId);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SortableTokenTransferList)) {
                return false;
            }
            SortableTokenTransferList otherTransferList = (SortableTokenTransferList)o;
            return this.tokenId.equals(otherTransferList.tokenId);
        }

        public int hashCode() {
            return this.tokenId.hashCode();
        }
    }
}

