/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.PrecheckStatusException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface WithPingAll {
    public Duration getRequestTimeout();

    public CompletableFuture<Void> pingAllAsync();

    default public void pingAllAsync(BiConsumer<Void, Throwable> callback) {
        this.pingAllAsync(this.getRequestTimeout(), callback);
    }

    default public void pingAllAsync(Duration timeout, BiConsumer<Void, Throwable> callback) {
        this.pingAllAsync().orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void pingAllAsync(Consumer<Void> onSuccess, Consumer<Throwable> onFailure) {
        this.pingAllAsync(this.getRequestTimeout(), onSuccess, onFailure);
    }

    default public void pingAllAsync(Duration timeout, Consumer<Void> onSuccess, Consumer<Throwable> onFailure) {
        this.pingAllAsync().orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept((Void)output);
            }
        });
    }

    default public Void pingAll() throws TimeoutException, PrecheckStatusException {
        return this.pingAll(this.getRequestTimeout());
    }

    default public Void pingAll(Duration timeout) throws TimeoutException, PrecheckStatusException {
        try {
            return this.pingAllAsync().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

