/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.AccountID;
import com.hedera.hashgraph.sdk.proto.AssessedCustomFee;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AssessedCustomFee {
    public final long amount;
    @Nullable
    public final TokenId tokenId;
    @Nullable
    public final AccountId feeCollectorAccountId;
    public final List<AccountId> payerAccountIdList;

    private AssessedCustomFee(long amount, @Nullable TokenId tokenId, @Nullable AccountId feeCollectorAccountId, List<AccountId> payerAccountIdList) {
        this.amount = amount;
        this.tokenId = tokenId;
        this.feeCollectorAccountId = feeCollectorAccountId;
        this.payerAccountIdList = payerAccountIdList;
    }

    static AssessedCustomFee fromProtobuf(com.hedera.hashgraph.sdk.proto.AssessedCustomFee assessedCustomFee) {
        ArrayList<AccountId> payerList = new ArrayList<AccountId>(assessedCustomFee.getEffectivePayerAccountIdCount());
        for (AccountID payerId : assessedCustomFee.getEffectivePayerAccountIdList()) {
            payerList.add(AccountId.fromProtobuf(payerId));
        }
        return new AssessedCustomFee(assessedCustomFee.getAmount(), assessedCustomFee.hasTokenId() ? TokenId.fromProtobuf(assessedCustomFee.getTokenId()) : null, assessedCustomFee.hasFeeCollectorAccountId() ? AccountId.fromProtobuf(assessedCustomFee.getFeeCollectorAccountId()) : null, payerList);
    }

    public static AssessedCustomFee fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return AssessedCustomFee.fromProtobuf((com.hedera.hashgraph.sdk.proto.AssessedCustomFee)((AssessedCustomFee.Builder)com.hedera.hashgraph.sdk.proto.AssessedCustomFee.parseFrom(bytes).toBuilder()).build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("amount", this.amount).add("tokenId", (Object)this.tokenId).add("feeCollectorAccountId", (Object)this.feeCollectorAccountId).add("payerAccountIdList", this.payerAccountIdList).toString();
    }

    com.hedera.hashgraph.sdk.proto.AssessedCustomFee toProtobuf() {
        AssessedCustomFee.Builder builder = com.hedera.hashgraph.sdk.proto.AssessedCustomFee.newBuilder().setAmount(this.amount);
        if (this.tokenId != null) {
            builder.setTokenId(this.tokenId.toProtobuf());
        }
        if (this.feeCollectorAccountId != null) {
            builder.setFeeCollectorAccountId(this.feeCollectorAccountId.toProtobuf());
        }
        for (AccountId payerId : this.payerAccountIdList) {
            builder.addEffectivePayerAccountId(payerId.toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.AssessedCustomFee)builder.build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

