/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ScheduleCreateTransaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionResponse;
import com.hedera.hashgraph.sdk.WithExecuteAll;
import com.hedera.hashgraph.sdk.proto.SignatureMap;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class ChunkedTransaction<T extends ChunkedTransaction<T>>
extends com.hedera.hashgraph.sdk.Transaction<T>
implements WithExecuteAll {
    private static final int CHUNK_SIZE = 1024;
    protected ByteString data = ByteString.EMPTY;
    private int maxChunks = 20;

    ChunkedTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
    }

    ChunkedTransaction(TransactionBody txBody) {
        super(txBody);
    }

    ChunkedTransaction() {
    }

    ByteString getData() {
        return this.data;
    }

    T setData(byte[] data) {
        this.requireNotFrozen();
        this.data = ByteString.copyFrom((byte[])data);
        return (T)this;
    }

    T setData(ByteString data) {
        this.requireNotFrozen();
        this.data = data;
        return (T)this;
    }

    T setData(String text) {
        this.requireNotFrozen();
        this.data = ByteString.copyFromUtf8((String)text);
        return (T)this;
    }

    public int getMaxChunks() {
        return this.maxChunks;
    }

    public T setMaxChunks(int maxChunks) {
        this.requireNotFrozen();
        this.maxChunks = maxChunks;
        return (T)this;
    }

    @Override
    public byte[] getTransactionHash() {
        if (this.outerTransactions.size() > this.nodeAccountIds.size()) {
            throw new IllegalStateException("a single transaction hash can not be calculated for a chunked transaction, try calling `getAllTransactionHashesPerNode`");
        }
        return super.getTransactionHash();
    }

    @Override
    public Map<AccountId, byte[]> getTransactionHashPerNode() {
        if (this.outerTransactions.size() > this.nodeAccountIds.size()) {
            throw new IllegalStateException("a single transaction hash can not be calculated for a chunked transaction, try calling `getAllTransactionHashesPerNode`");
        }
        return super.getTransactionHashPerNode();
    }

    public final List<Map<AccountId, byte[]>> getAllTransactionHashesPerNode() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        this.transactionIdsLocked = true;
        this.buildAllTransactions();
        int txCount = this.transactionIds.size();
        int nodeCount = this.nodeAccountIds.size();
        ArrayList<Map<AccountId, byte[]>> transactionHashes = new ArrayList<Map<AccountId, byte[]>>(txCount);
        for (int txIndex = 0; txIndex < txCount; ++txIndex) {
            HashMap<AccountId, byte[]> hashes = new HashMap<AccountId, byte[]>();
            int offset = txIndex * nodeCount;
            for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
                hashes.put((AccountId)this.nodeAccountIds.get(nodeIndex), ChunkedTransaction.hash(((Transaction)this.outerTransactions.get(offset + nodeIndex)).getSignedTransactionBytes().toByteArray()));
            }
            transactionHashes.add(hashes);
        }
        return transactionHashes;
    }

    @Override
    public T addSignature(PublicKey publicKey, byte[] signature) {
        if (this.data.size() > 1024) {
            throw new IllegalStateException("Cannot manually add signature to chunked transaction with length greater than 1024");
        }
        return (T)((ChunkedTransaction)super.addSignature(publicKey, signature));
    }

    @Override
    public Map<AccountId, Map<PublicKey, byte[]>> getSignatures() {
        if (this.data.size() > 1024) {
            throw new IllegalStateException("Cannot call getSignatures() on a chunked transaction with length greater than 1024");
        }
        return super.getSignatures();
    }

    public List<Map<AccountId, Map<PublicKey, byte[]>>> getAllSignatures() {
        if (this.publicKeys.isEmpty()) {
            return new ArrayList<Map<AccountId, Map<PublicKey, byte[]>>>();
        }
        this.buildAllTransactions();
        int txCount = this.transactionIds.size();
        int nodeCount = this.nodeAccountIds.size();
        ArrayList<Map<AccountId, Map<PublicKey, byte[]>>> retval = new ArrayList<Map<AccountId, Map<PublicKey, byte[]>>>(txCount);
        for (int i = 0; i < txCount; ++i) {
            retval.add(this.getSignaturesAtOffset(i * nodeCount));
        }
        return retval;
    }

    private void freezeAndSign(Client client) {
        AccountId operatorId;
        if (!this.isFrozen()) {
            this.freezeWith(client);
        }
        if ((operatorId = client.getOperatorAccountId()) != null && operatorId.equals(Objects.requireNonNull(this.getTransactionIdInternal().accountId))) {
            this.signWithOperator(client);
        }
    }

    @Override
    public TransactionResponse execute(Client client) throws PrecheckStatusException, TimeoutException {
        return this.executeAll(client).get(0);
    }

    @Override
    public List<TransactionResponse> executeAll(Client client) throws PrecheckStatusException, TimeoutException {
        this.freezeAndSign(client);
        ArrayList<TransactionResponse> responses = new ArrayList<TransactionResponse>(this.transactionIds.size());
        for (int i = 0; i < this.transactionIds.size(); ++i) {
            TransactionResponse response = (TransactionResponse)super.execute(client);
            if (this.shouldGetReceipt()) {
                ((TransactionReceiptQuery)new TransactionReceiptQuery().setNodeAccountIds((List)Collections.singletonList(response.nodeId))).setTransactionId(response.transactionId).execute(client);
            }
            responses.add(response);
        }
        return responses;
    }

    @Override
    public CompletableFuture<List<TransactionResponse>> executeAllAsync(Client client) {
        this.freezeAndSign(client);
        CompletionStage<List<TransactionResponse>> future = CompletableFuture.supplyAsync(() -> new ArrayList(this.transactionIds.size()));
        for (int i = 0; i < this.transactionIds.size(); ++i) {
            future = future.thenCompose(list -> {
                CompletableFuture responseFuture = super.executeAsync(client);
                Function<TransactionResponse, CompletionStage> receiptFuture = response -> response.getReceiptAsync(client).thenApply(receipt -> response);
                Function<TransactionResponse, List> addToList = response -> {
                    list.add(response);
                    return list;
                };
                if (this.shouldGetReceipt()) {
                    return ((CompletableFuture)responseFuture.thenCompose(receiptFuture)).thenApply(addToList);
                }
                return responseFuture.thenApply(addToList);
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        return this.executeAllAsync(client).thenApply(responses -> (TransactionResponse)responses.get(0));
    }

    @Override
    public ScheduleCreateTransaction schedule() {
        this.requireNotFrozen();
        if (!this.nodeAccountIds.isEmpty()) {
            throw new IllegalStateException("The underlying transaction for a scheduled transaction cannot have node account IDs set");
        }
        if (this.data.size() > 1024) {
            throw new IllegalStateException("Cannot schedule a chunked transaction with length greater than 1024");
        }
        TransactionBody.Builder bodyBuilder = this.spawnBodyBuilder(null);
        this.onFreeze(bodyBuilder);
        this.onFreezeChunk(bodyBuilder, null, 0, this.data.size(), 1, 1);
        return this.doSchedule(bodyBuilder);
    }

    @Override
    int getRequiredChunks() {
        int requiredChunks = (this.data.size() + 1023) / 1024;
        if (requiredChunks == 0) {
            requiredChunks = 1;
        }
        if (requiredChunks > this.maxChunks) {
            throw new IllegalArgumentException("message of " + this.data.size() + " bytes requires " + requiredChunks + " chunks but the maximum allowed chunks is " + this.maxChunks + ", try using setMaxChunks");
        }
        return requiredChunks;
    }

    @Override
    void wipeTransactionLists(int requiredChunks) {
        this.sigPairLists = new ArrayList(requiredChunks * this.nodeAccountIds.size());
        this.outerTransactions = new ArrayList(requiredChunks * this.nodeAccountIds.size());
        this.innerSignedTransactions = new ArrayList(requiredChunks * this.nodeAccountIds.size());
        for (int i = 0; i < requiredChunks; ++i) {
            int startIndex = i * 1024;
            int endIndex = startIndex + 1024;
            if (endIndex > this.data.size()) {
                endIndex = this.data.size();
            }
            this.onFreezeChunk(Objects.requireNonNull(this.frozenBodyBuilder).setTransactionID(((TransactionId)this.transactionIds.get(i)).toProtobuf()), ((TransactionId)this.transactionIds.get(0)).toProtobuf(), startIndex, endIndex, i, requiredChunks);
            for (AccountId nodeId : this.nodeAccountIds) {
                this.sigPairLists.add(SignatureMap.newBuilder());
                this.innerSignedTransactions.add(SignedTransaction.newBuilder().setBodyBytes(((TransactionBody)this.frozenBodyBuilder.setNodeAccountID(nodeId.toProtobuf()).build()).toByteString()));
                this.outerTransactions.add(null);
            }
        }
    }

    abstract void onFreezeChunk(TransactionBody.Builder var1, @Nullable TransactionID var2, int var3, int var4, int var5, int var6);

    boolean shouldGetReceipt() {
        return false;
    }
}

