/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.ContractLogInfo;
import com.hedera.hashgraph.sdk.proto.ContractFunctionResult;
import com.hedera.hashgraph.sdk.proto.ContractFunctionResultOrBuilder;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class ContractFunctionResult {
    private static final ByteString errorPrefix = ByteString.copyFrom((byte[])new byte[]{8, -61, 121, -96});
    public final ContractId contractId;
    @Nullable
    public final String errorMessage;
    public final ByteString bloom;
    public final long gasUsed;
    public final List<ContractLogInfo> logs;
    public final List<ContractId> createdContractIds;
    private final ByteString rawResult;

    ContractFunctionResult(ContractFunctionResultOrBuilder inner) {
        this.contractId = ContractId.fromProtobuf(inner.getContractID());
        String errMsg = inner.getErrorMessage();
        this.errorMessage = !errMsg.isEmpty() ? errMsg : null;
        ByteString callResult = inner.getContractCallResult();
        this.rawResult = this.errorMessage != null && callResult.startsWith(errorPrefix) ? callResult.substring(4) : callResult;
        this.bloom = inner.getBloom();
        this.gasUsed = inner.getGasUsed();
        this.logs = inner.getLogInfoList().stream().map(ContractLogInfo::fromProtobuf).collect(Collectors.toList());
        this.createdContractIds = inner.getCreatedContractIDsList().stream().map(ContractId::fromProtobuf).collect(Collectors.toList());
    }

    public byte[] asBytes() {
        return this.rawResult.toByteArray();
    }

    public String getString(int valIndex) {
        return this.getDynamicBytes(valIndex).toStringUtf8();
    }

    public List<String> getStringArray(int index) {
        int offset = this.getInt32(index);
        int count = this.getIntValueAt(offset);
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            int strOffset = this.getIntValueAt(offset + 32 + i * 32);
            int len = this.getIntValueAt(offset + strOffset + 32);
            String str = this.getByteString(offset + strOffset + 32 + 32, offset + strOffset + 32 + 32 + len).toStringUtf8();
            strings.add(str);
        }
        return strings;
    }

    public byte[] getBytes(int valIndex) {
        return this.getDynamicBytes(valIndex).toByteArray();
    }

    public byte[] getBytes32(int valIndex) {
        return this.getByteString(valIndex * 32, (valIndex + 1) * 32).toByteArray();
    }

    private ByteString getDynamicBytes(int valIndex) {
        int offset = this.getInt32(valIndex);
        int len = this.getIntValueAt(offset);
        return this.getByteString(offset + 32, offset + 32 + len);
    }

    public boolean getBool(int valIndex) {
        return this.getInt8(valIndex) != 0;
    }

    public byte getInt8(int valIndex) {
        return this.getByteBuffer(valIndex * 32 + 31).get();
    }

    public int getInt32(int valIndex) {
        return this.getIntValueAt(valIndex * 32);
    }

    public long getInt64(int valIndex) {
        return this.getByteBuffer(valIndex * 32 + 24).getLong();
    }

    public BigInteger getInt256(int valIndex) {
        return new BigInteger(this.getBytes32(valIndex));
    }

    public byte getUint8(int valIndex) {
        return this.getInt8(valIndex);
    }

    public int getUint32(int valIndex) {
        return this.getInt32(valIndex);
    }

    public long getUint64(int valIndex) {
        return this.getInt64(valIndex);
    }

    public BigInteger getUint256(int valIndex) {
        byte[] bytes = new byte[33];
        this.getByteString(valIndex * 32, (valIndex + 1) * 32).copyTo(bytes, 1);
        return new BigInteger(bytes);
    }

    public String getAddress(int valIndex) {
        int offset = valIndex * 32;
        return Hex.toHexString((byte[])this.getByteString(offset + 12, offset + 32).toByteArray());
    }

    private int getIntValueAt(int valueOffset) {
        return this.getByteBuffer(valueOffset + 28).getInt();
    }

    private ByteBuffer getByteBuffer(int offset) {
        ByteBuffer byteBuffer = this.rawResult.asReadOnlyByteBuffer();
        byteBuffer.position(byteBuffer.position() + offset);
        return byteBuffer;
    }

    private ByteString getByteString(int startIndex, int endIndex) {
        return this.rawResult.substring(startIndex, endIndex);
    }

    com.hedera.hashgraph.sdk.proto.ContractFunctionResult toProtobuf() {
        ContractFunctionResult.Builder contractFunctionResult = com.hedera.hashgraph.sdk.proto.ContractFunctionResult.newBuilder().setContractID(this.contractId.toProtobuf()).setContractCallResult(this.rawResult).setBloom(this.bloom).setGasUsed(this.gasUsed);
        if (this.errorMessage != null) {
            contractFunctionResult.setErrorMessage(this.errorMessage);
        }
        for (ContractLogInfo log : this.logs) {
            contractFunctionResult.addLogInfo(log.toProtobuf());
        }
        for (ContractId contractId : this.createdContractIds) {
            contractFunctionResult.addCreatedContractIDs(contractId.toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.ContractFunctionResult)contractFunctionResult.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("contractId", (Object)this.contractId).add("rawResult", (Object)Hex.toHexString((byte[])this.rawResult.toByteArray())).add("bloom", (Object)Hex.toHexString((byte[])this.bloom.toByteArray())).add("gasUsed", this.gasUsed).add("errorMessage", (Object)this.errorMessage).add("logs", this.logs).add("createdContractIds", this.createdContractIds).toString();
    }
}

