/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.IPv4Address;
import com.hedera.hashgraph.sdk.proto.ServiceEndpoint;
import java.util.Objects;
import javax.annotation.Nullable;

class Endpoint {
    @Nullable
    IPv4Address address = null;
    int port;

    Endpoint() {
    }

    static Endpoint fromProtobuf(ServiceEndpoint serviceEndpoint) {
        int port = (int)((long)serviceEndpoint.getPort() & 0xFFFFFFFFL);
        if (port == 0 || port == 50111) {
            port = 50211;
        }
        return new Endpoint().setAddress(IPv4Address.fromProtobuf(serviceEndpoint.getIpAddressV4())).setPort(port);
    }

    @Nullable
    IPv4Address getAddress() {
        return this.address;
    }

    Endpoint setAddress(IPv4Address address) {
        this.address = address;
        return this;
    }

    int getPort() {
        return this.port;
    }

    Endpoint setPort(int port) {
        this.port = port;
        return this;
    }

    ServiceEndpoint toProtobuf() {
        ServiceEndpoint.Builder builder = ServiceEndpoint.newBuilder();
        if (this.address != null) {
            builder.setIpAddressV4(this.address.toProtobuf());
        }
        return (ServiceEndpoint)builder.setPort(this.port).build();
    }

    public String toString() {
        return Objects.requireNonNull(this.address) + ":" + this.port;
    }
}

