/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.SubType;

public enum FeeDataType {
    DEFAULT(SubType.DEFAULT),
    TOKEN_FUNGIBLE_COMMON(SubType.TOKEN_FUNGIBLE_COMMON),
    TOKEN_NON_FUNGIBLE_UNIQUE(SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES(SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES),
    TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES(SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES);

    final SubType code;

    private FeeDataType(SubType code) {
        this.code = code;
    }

    static FeeDataType valueOf(SubType code) {
        switch (code) {
            case DEFAULT: {
                return DEFAULT;
            }
            case TOKEN_FUNGIBLE_COMMON: {
                return TOKEN_FUNGIBLE_COMMON;
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE: {
                return TOKEN_NON_FUNGIBLE_UNIQUE;
            }
            case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES: {
                return TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES: {
                return TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES;
            }
        }
        throw new IllegalStateException("(BUG) unhandled SubType (FeeDataType)");
    }

    public String toString() {
        switch (this) {
            case DEFAULT: {
                return "DEFAULT";
            }
            case TOKEN_FUNGIBLE_COMMON: {
                return "TOKEN_FUNGIBLE_COMMON";
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE: {
                return "TOKEN_NON_FUNGIBLE_UNIQUE";
            }
            case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES: {
                return "TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES";
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES: {
                return "TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES";
            }
        }
        return "<UNRECOGNIZED VALUE>";
    }
}

