/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FileDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<FileDeleteTransaction> {
    @Nullable
    private FileId fileId = null;

    public FileDeleteTransaction() {
    }

    FileDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    FileDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public FileId getFileId() {
        return this.fileId;
    }

    public FileDeleteTransaction setFileId(FileId fileId) {
        Objects.requireNonNull(fileId);
        this.requireNotFrozen();
        this.fileId = fileId;
        return this;
    }

    void initFromTransactionBody() {
        FileDeleteTransactionBody body = this.sourceTransactionBody.getFileDelete();
        if (body.hasFileID()) {
            this.fileId = FileId.fromProtobuf(body.getFileID());
        }
    }

    FileDeleteTransactionBody.Builder build() {
        FileDeleteTransactionBody.Builder builder = FileDeleteTransactionBody.newBuilder();
        if (this.fileId != null) {
            builder.setFileID(this.fileId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.fileId != null) {
            this.fileId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getDeleteFileMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileDelete(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setFileDelete(this.build());
    }
}

