/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.FreezeType;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FreezeServiceGrpc;
import com.hedera.hashgraph.sdk.proto.FreezeTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FreezeTransaction
extends com.hedera.hashgraph.sdk.Transaction<FreezeTransaction> {
    private int endHour = 0;
    private int endMinute = 0;
    @Nullable
    private Instant startTime = null;
    @Nullable
    private FileId fileId = null;
    private byte[] fileHash = new byte[0];
    private FreezeType freezeType = FreezeType.UNKNOWN_FREEZE_TYPE;

    public FreezeTransaction() {
    }

    FreezeTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    FreezeTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    public Instant getStartTime() {
        return this.startTime != null ? this.startTime : Instant.EPOCH;
    }

    public FreezeTransaction setStartTime(Instant startTime) {
        this.requireNotFrozen();
        Objects.requireNonNull(startTime);
        this.startTime = startTime;
        return this;
    }

    @Deprecated
    public FreezeTransaction setStartTime(int hour, int minute) {
        return this.setStartTime(Instant.ofEpochMilli(((long)hour * 60L * 60L + (long)minute * 60L) * 1000L));
    }

    @Deprecated
    public Instant getEndTime() {
        return Instant.from(OffsetTime.of(this.endHour, this.endMinute, 0, 0, ZoneOffset.UTC));
    }

    @Deprecated
    public FreezeTransaction setEndTime(int hour, int minute) {
        this.requireNotFrozen();
        this.endHour = hour;
        this.endMinute = minute;
        return this;
    }

    @Deprecated
    @Nullable
    public FileId getUpdateFileId() {
        return this.fileId;
    }

    @Deprecated
    public FreezeTransaction setUpdateFileId(FileId updateFileId) {
        return this.setFileId(updateFileId);
    }

    @Deprecated
    public byte[] getUpdateFileHash() {
        return this.fileHash;
    }

    @Deprecated
    public FreezeTransaction setUpdateFileHash(byte[] updateFileHash) {
        return this.setFileHash(updateFileHash);
    }

    @Nullable
    public FileId getFileId() {
        return this.fileId;
    }

    public FreezeTransaction setFileId(FileId fileId) {
        this.requireNotFrozen();
        Objects.requireNonNull(fileId);
        this.fileId = fileId;
        return this;
    }

    public byte[] getFileHash() {
        return this.fileHash;
    }

    public FreezeTransaction setFileHash(byte[] fileHash) {
        this.requireNotFrozen();
        Objects.requireNonNull(fileHash);
        this.fileHash = fileHash;
        return this;
    }

    public FreezeType getFreezeType() {
        return this.freezeType;
    }

    public FreezeTransaction setFreezeType(FreezeType freezeType) {
        this.requireNotFrozen();
        Objects.requireNonNull(freezeType);
        this.freezeType = freezeType;
        return this;
    }

    @Override
    void validateChecksums(Client client) {
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FreezeServiceGrpc.getFreezeMethod();
    }

    void initFromTransactionBody() {
        FreezeTransactionBody body = this.sourceTransactionBody.getFreeze();
        this.freezeType = FreezeType.valueOf(body.getFreezeType());
        if (body.hasUpdateFile()) {
            this.fileId = FileId.fromProtobuf(body.getUpdateFile());
        }
        this.fileHash = body.getFileHash().toByteArray();
        if (body.hasStartTime()) {
            this.startTime = InstantConverter.fromProtobuf(body.getStartTime());
        }
    }

    FreezeTransactionBody.Builder build() {
        FreezeTransactionBody.Builder builder = FreezeTransactionBody.newBuilder();
        builder.setFreezeType(this.freezeType.code);
        if (this.fileId != null) {
            builder.setUpdateFile(this.fileId.toProtobuf());
        }
        builder.setFileHash(ByteString.copyFrom((byte[])this.fileHash));
        if (this.startTime != null) {
            builder.setStartTime(InstantConverter.toProtobuf(this.startTime));
        }
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFreeze(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setFreeze(this.build());
    }
}

