/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.Splitter;
import com.hedera.hashgraph.sdk.HbarUnit;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Hbar
implements Comparable<Hbar> {
    public static final Hbar ZERO = Hbar.fromTinybars(0L);
    public static final Hbar MAX = Hbar.from(50000000000L);
    public static final Hbar MIN = Hbar.from(-50000000000L);
    private static final Pattern FROM_STRING_PATTERN = Pattern.compile("^((?:\\+|\\-)?\\d+(?:\\.\\d+)?)(\\ (t\u210f|\u03bc\u210f|m\u210f|\u210f|k\u210f|M\u210f|G\u210f))?$");
    private final long valueInTinybar;

    public Hbar(long amount) {
        this(amount, HbarUnit.HBAR);
    }

    Hbar(long amount, HbarUnit unit) {
        this.valueInTinybar = amount * unit.tinybar;
    }

    public Hbar(BigDecimal amount) {
        this(amount, HbarUnit.HBAR);
    }

    Hbar(BigDecimal amount, HbarUnit unit) {
        BigDecimal tinybars = amount.multiply(BigDecimal.valueOf(unit.tinybar));
        if (tinybars.doubleValue() % 1.0 != 0.0) {
            throw new IllegalArgumentException("Amount and Unit combination results in a fractional value for tinybar.  Ensure tinybar value is a whole number.");
        }
        this.valueInTinybar = tinybars.longValue();
    }

    private static HbarUnit getUnit(String symbolString) {
        for (HbarUnit unit : HbarUnit.values()) {
            if (!unit.getSymbol().equals(symbolString)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Attempted to convert string to Hbar, but unit symbol \"" + symbolString + "\" was not recognized");
    }

    public static Hbar fromString(CharSequence text) {
        Matcher matcher = FROM_STRING_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Attempted to convert string to Hbar, but \"" + text + "\" was not correctly formatted");
        }
        List parts = Splitter.on((char)' ').splitToList((CharSequence)text.toString());
        return new Hbar(new BigDecimal((String)parts.get(0)), parts.size() == 2 ? Hbar.getUnit((String)parts.get(1)) : HbarUnit.HBAR);
    }

    public static Hbar fromString(CharSequence text, HbarUnit unit) {
        return new Hbar(new BigDecimal(text.toString()), unit);
    }

    public static Hbar from(long hbars) {
        return new Hbar(hbars, HbarUnit.HBAR);
    }

    public static Hbar from(long amount, HbarUnit unit) {
        return new Hbar(amount, unit);
    }

    public static Hbar from(BigDecimal hbars) {
        return new Hbar(hbars, HbarUnit.HBAR);
    }

    public static Hbar from(BigDecimal amount, HbarUnit unit) {
        return new Hbar(amount, unit);
    }

    public static Hbar fromTinybars(long tinybars) {
        return new Hbar(tinybars, HbarUnit.TINYBAR);
    }

    public BigDecimal to(HbarUnit unit) {
        return BigDecimal.valueOf(this.valueInTinybar).divide(BigDecimal.valueOf(unit.tinybar), MathContext.UNLIMITED);
    }

    public long toTinybars() {
        return this.valueInTinybar;
    }

    public BigDecimal getValue() {
        return this.to(HbarUnit.HBAR);
    }

    public Hbar negated() {
        return Hbar.fromTinybars(-this.valueInTinybar);
    }

    public String toString() {
        if (this.valueInTinybar < 10000L && this.valueInTinybar > -10000L) {
            return Long.toString(this.valueInTinybar) + " " + HbarUnit.TINYBAR.getSymbol();
        }
        return this.to(HbarUnit.HBAR).toString() + " " + HbarUnit.HBAR.getSymbol();
    }

    public String toString(HbarUnit unit) {
        return this.to(unit).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hbar hbar = (Hbar)o;
        return this.valueInTinybar == hbar.valueInTinybar;
    }

    public int hashCode() {
        return Objects.hash(this.valueInTinybar);
    }

    @Override
    public int compareTo(Hbar o) {
        return Long.compare(this.valueInTinybar, o.valueInTinybar);
    }
}

