/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.ThresholdKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class KeyList
extends Key
implements Collection<Key> {
    private final List<Key> keys = new ArrayList<Key>();
    @Nullable
    public Integer threshold;

    public KeyList() {
        this.threshold = null;
    }

    private KeyList(int threshold) {
        this.threshold = threshold;
    }

    public static KeyList of(Key ... keys) {
        KeyList list = new KeyList();
        for (Key key : keys) {
            list.add(key);
        }
        return list;
    }

    public static KeyList withThreshold(int threshold) {
        return new KeyList(threshold);
    }

    static KeyList fromProtobuf(com.hedera.hashgraph.sdk.proto.KeyList keyList, @Nullable Integer threshold) {
        KeyList keys = threshold != null ? new KeyList(threshold) : new KeyList();
        for (int i = 0; i < keyList.getKeysCount(); ++i) {
            keys.add(Key.fromProtobufKey(keyList.getKeys(i)));
        }
        return keys;
    }

    @Nullable
    public Integer getThreshold() {
        return this.threshold;
    }

    public KeyList setThreshold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.keys.contains(o);
    }

    @Override
    public Iterator<Key> iterator() {
        return this.keys.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.keys.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.keys.toArray((Key[])ts);
    }

    @Override
    public boolean add(Key key) {
        return this.keys.add(key);
    }

    @Override
    public boolean remove(Object o) {
        return this.keys.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.keys.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends Key> collection) {
        return this.keys.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.keys.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.keys.retainAll(collection);
    }

    @Override
    public void clear() {
        this.keys.clear();
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        KeyList.Builder protoKeyList = com.hedera.hashgraph.sdk.proto.KeyList.newBuilder();
        for (Key key : this.keys) {
            protoKeyList.addKeys(key.toProtobufKey());
        }
        if (this.threshold != null) {
            return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setThresholdKey(ThresholdKey.newBuilder().setThreshold(this.threshold).setKeys(protoKeyList)).build();
        }
        return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setKeyList(protoKeyList).build();
    }

    com.hedera.hashgraph.sdk.proto.KeyList toProtobuf() {
        KeyList.Builder keyList = com.hedera.hashgraph.sdk.proto.KeyList.newBuilder();
        for (Key key : this.keys) {
            keyList.addKeys(key.toProtobufKey());
        }
        return (com.hedera.hashgraph.sdk.proto.KeyList)keyList.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("threshold", (Object)this.threshold).add("keys", this.keys).toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyList)) {
            return false;
        }
        KeyList keyList = (KeyList)o;
        if (keyList.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < keyList.size(); ++i) {
            if (Arrays.equals(keyList.keys.get(i).toBytes(), this.keys.get(i).toBytes())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keys.hashCode(), this.threshold != null ? this.threshold : -1);
    }
}

