/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoDeleteLiveHashTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class LiveHashDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<LiveHashDeleteTransaction> {
    @Nullable
    private AccountId accountId = null;
    private byte[] hash = new byte[0];

    public LiveHashDeleteTransaction() {
    }

    LiveHashDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public LiveHashDeleteTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    public ByteString getHash() {
        return ByteString.copyFrom((byte[])this.hash);
    }

    public LiveHashDeleteTransaction setHash(byte[] hash) {
        this.requireNotFrozen();
        Objects.requireNonNull(hash);
        this.hash = hash;
        return this;
    }

    public LiveHashDeleteTransaction setHash(ByteString hash) {
        Objects.requireNonNull(hash);
        return this.setHash(hash.toByteArray());
    }

    void initFromTransactionBody() {
        CryptoDeleteLiveHashTransactionBody body = this.sourceTransactionBody.getCryptoDeleteLiveHash();
        if (body.hasAccountOfLiveHash()) {
            this.accountId = AccountId.fromProtobuf(body.getAccountOfLiveHash());
        }
        this.hash = body.getLiveHashToDelete().toByteArray();
    }

    CryptoDeleteLiveHashTransactionBody.Builder build() {
        CryptoDeleteLiveHashTransactionBody.Builder builder = CryptoDeleteLiveHashTransactionBody.newBuilder();
        if (this.accountId != null) {
            builder.setAccountOfLiveHash(this.accountId.toProtobuf());
        }
        builder.setLiveHashToDelete(ByteString.copyFrom((byte[])this.hash));
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getDeleteLiveHashMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoDeleteLiveHash(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        throw new IllegalStateException("Cannot schedule live hash transactions");
    }
}

