/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.ManagedNode;
import com.hedera.hashgraph.sdk.ManagedNodeAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

abstract class ManagedNetwork<ManagedNetworkT extends ManagedNetwork<ManagedNetworkT, KeyT, ManagedNodeT>, KeyT, ManagedNodeT extends ManagedNode<ManagedNodeT, KeyT>> {
    protected static final Integer DEFAULT_MAX_NODE_ATTEMPTS = -1;
    protected final ExecutorService executor;
    protected Map<KeyT, List<ManagedNodeT>> network = new ConcurrentHashMap<KeyT, List<ManagedNodeT>>();
    protected List<ManagedNodeT> nodes = new ArrayList<ManagedNodeT>();
    protected Duration minBackoff = Client.DEFAULT_MIN_BACKOFF;
    protected Duration maxBackoff = Client.DEFAULT_MAX_BACKOFF;
    protected Duration closeTimeout = Client.DEFAULT_CLOSE_TIMEOUT;
    protected int maxNodeAttempts = DEFAULT_MAX_NODE_ATTEMPTS;
    protected boolean transportSecurity;
    @Nullable
    private LedgerId ledgerId;

    protected ManagedNetwork(ExecutorService executor) {
        this.executor = executor;
    }

    @Nullable
    LedgerId getLedgerId() {
        return this.ledgerId;
    }

    synchronized ManagedNetworkT setLedgerId(@Nullable LedgerId ledgerId) {
        this.ledgerId = ledgerId;
        return (ManagedNetworkT)this;
    }

    int getMaxNodeAttempts() {
        return this.maxNodeAttempts;
    }

    synchronized ManagedNetworkT setMaxNodeAttempts(int maxNodeAttempts) {
        this.maxNodeAttempts = maxNodeAttempts;
        return (ManagedNetworkT)this;
    }

    Duration getMinBackoff() {
        return this.minBackoff;
    }

    synchronized ManagedNetworkT setMinBackoff(Duration minBackoff) {
        this.minBackoff = minBackoff;
        for (ManagedNode node : this.nodes) {
            node.setMinBackoff(minBackoff);
        }
        return (ManagedNetworkT)this;
    }

    Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    synchronized ManagedNetworkT setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = maxBackoff;
        for (ManagedNode node : this.nodes) {
            node.setMaxBackoff(maxBackoff);
        }
        return (ManagedNetworkT)this;
    }

    boolean isTransportSecurity() {
        return this.transportSecurity;
    }

    synchronized ManagedNetworkT setTransportSecurity(boolean transportSecurity) throws InterruptedException {
        if (this.transportSecurity != transportSecurity) {
            this.network.clear();
            for (int i = 0; i < this.nodes.size(); ++i) {
                ManagedNode node = (ManagedNode)this.nodes.get(i);
                node.close(this.closeTimeout);
                node = transportSecurity ? node.toSecure() : node.toInsecure();
                this.nodes.set(i, node);
                this.getNodesForKey(node.getKey()).add(node);
            }
        }
        this.transportSecurity = transportSecurity;
        return (ManagedNetworkT)this;
    }

    Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    synchronized ManagedNetworkT setCloseTimeout(Duration closeTimeout) {
        this.closeTimeout = closeTimeout;
        return (ManagedNetworkT)this;
    }

    protected abstract ManagedNodeT createNodeFromNetworkEntry(Map.Entry<String, KeyT> var1);

    protected List<Integer> getNodesToRemove(Map<String, KeyT> network) {
        ArrayList<Integer> nodes = new ArrayList<Integer>(this.nodes.size());
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            ManagedNode node = (ManagedNode)this.nodes.get(i);
            if (this.nodeIsInGivenNetwork(node, network)) continue;
            nodes.add(i);
        }
        return nodes;
    }

    private boolean nodeIsInGivenNetwork(ManagedNodeT node, Map<String, KeyT> network) {
        for (Map.Entry<String, KeyT> entry : network.entrySet()) {
            if (!((ManagedNode)node).getKey().equals(entry.getValue()) || !((ManagedNode)node).address.equals(ManagedNodeAddress.fromString(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    synchronized ManagedNetworkT setNetwork(Map<String, KeyT> network) throws TimeoutException, InterruptedException {
        for (Integer n : this.getNodesToRemove(network)) {
            long stopAt = Instant.now().getEpochSecond() + this.closeTimeout.getSeconds();
            long remainingTime = stopAt - Instant.now().getEpochSecond();
            ManagedNode node = (ManagedNode)this.nodes.get(n);
            if (remainingTime <= 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            this.removeNodeFromNetwork(node);
            node.close(Duration.ofSeconds(remainingTime));
            this.nodes.remove(n);
        }
        for (Map.Entry entry : network.entrySet()) {
            List<ManagedNodeT> nodesForKey = this.getNodesForKey(entry.getValue());
            if (this.addressIsInNodeList((String)entry.getKey(), nodesForKey)) continue;
            ManagedNodeT node = this.createNodeFromNetworkEntry(entry);
            nodesForKey.add(node);
            this.nodes.add(node);
        }
        Collections.shuffle(this.nodes);
        for (List list : this.network.values()) {
            Collections.shuffle(list);
        }
        return (ManagedNetworkT)this;
    }

    private void removeNodeFromNetwork(ManagedNodeT node) {
        List<ManagedNodeT> nodesForKey = this.network.get(((ManagedNode)node).getKey());
        nodesForKey.remove(node);
        if (nodesForKey.isEmpty()) {
            this.network.remove(((ManagedNode)node).getKey());
        }
    }

    private List<ManagedNodeT> getNodesForKey(KeyT key) {
        if (this.network.containsKey(key)) {
            return this.network.get(key);
        }
        ArrayList newList = new ArrayList();
        this.network.put(key, newList);
        return newList;
    }

    private boolean addressIsInNodeList(String addressString, List<ManagedNodeT> nodes) {
        ManagedNodeAddress address = ManagedNodeAddress.fromString(addressString);
        for (ManagedNode node : nodes) {
            if (!node.address.equals(address)) continue;
            return true;
        }
        return false;
    }

    protected void removeDeadNodes() throws InterruptedException {
        if (this.maxNodeAttempts > 0) {
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                ManagedNode node = Objects.requireNonNull((ManagedNode)this.nodes.get(i));
                if (node.getAttempts() < (long)this.maxNodeAttempts) continue;
                node.close(this.closeTimeout);
                this.removeNodeFromNetwork(node);
                this.nodes.remove(i);
            }
        }
    }

    protected synchronized List<ManagedNodeT> getNumberOfMostHealthyNodes(int count) throws InterruptedException {
        Collections.sort(this.nodes);
        this.removeDeadNodes();
        int returnSize = Math.min(count, this.network.size());
        HashMap returnNodes = new HashMap(returnSize);
        for (ManagedNode node : this.nodes) {
            if (returnNodes.size() >= returnSize) break;
            if (returnNodes.containsKey(node.getKey())) continue;
            returnNodes.put(node.getKey(), node);
        }
        ArrayList returnList = new ArrayList();
        returnList.addAll(returnNodes.values());
        return returnList;
    }

    synchronized void close() throws TimeoutException, InterruptedException {
        this.close(this.closeTimeout);
    }

    synchronized void close(Duration timeout) throws TimeoutException, InterruptedException {
        long stopAt = Instant.now().getEpochSecond() + timeout.getSeconds();
        for (ManagedNode node : this.nodes) {
            if (node.channel == null) continue;
            node.channel = node.channel.shutdown();
        }
        for (ManagedNode node : this.nodes) {
            if (stopAt - Instant.now().getEpochSecond() == 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            if (node.channel == null) continue;
            try {
                node.channel.awaitTermination(stopAt - Instant.now().getEpochSecond(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.nodes.clear();
        this.network.clear();
    }
}

