/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Delayer;
import com.hedera.hashgraph.sdk.ManagedNodeAddress;
import io.grpc.ChannelCredentials;
import io.grpc.ConnectivityState;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

abstract class ManagedNode<N extends ManagedNode<N, KeyT>, KeyT>
implements Comparable<ManagedNode<N, KeyT>> {
    private static final int GET_STATE_INTERVAL_MILLIS = 50;
    private static final int GET_STATE_TIMEOUT_MILLIS = 10000;
    private static final int GET_STATE_MAX_ATTEMPTS = 200;
    private boolean hasConnected = false;
    protected final ExecutorService executor;
    protected final ManagedNodeAddress address;
    protected long lastUsed = 0L;
    protected long useCount = 0L;
    protected long backoffUntil;
    protected Duration currentBackoff;
    protected Duration minBackoff;
    protected Duration maxBackoff;
    protected long attempts;
    @Nullable
    protected ManagedChannel channel = null;

    protected ManagedNode(ManagedNodeAddress address, ExecutorService executor) {
        this.executor = executor;
        this.address = address;
        this.currentBackoff = Client.DEFAULT_MIN_BACKOFF;
        this.minBackoff = Client.DEFAULT_MIN_BACKOFF;
        this.maxBackoff = Client.DEFAULT_MAX_BACKOFF;
    }

    protected ManagedNode(N node, ManagedNodeAddress address) {
        this.address = address;
        this.executor = ((ManagedNode)node).executor;
        this.minBackoff = ((ManagedNode)node).minBackoff;
        this.maxBackoff = ((ManagedNode)node).maxBackoff;
        this.backoffUntil = ((ManagedNode)node).backoffUntil;
        this.currentBackoff = ((ManagedNode)node).currentBackoff;
        this.attempts = ((ManagedNode)node).attempts;
        this.lastUsed = ((ManagedNode)node).lastUsed;
        this.useCount = ((ManagedNode)node).useCount;
    }

    protected String getAuthority() {
        return "127.0.0.1";
    }

    abstract N toInsecure();

    abstract N toSecure();

    abstract KeyT getKey();

    ManagedNodeAddress getAddress() {
        return this.address;
    }

    Duration getMinBackoff() {
        return this.minBackoff;
    }

    N setMinBackoff(Duration minBackoff) {
        this.minBackoff = minBackoff;
        return (N)this;
    }

    Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    N setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = this.maxBackoff;
        return (N)this;
    }

    long getAttempts() {
        return this.attempts;
    }

    boolean isHealthy() {
        return this.backoffUntil < System.currentTimeMillis();
    }

    synchronized void increaseDelay() {
        ++this.attempts;
        this.backoffUntil = System.currentTimeMillis() + this.currentBackoff.toMillis();
        this.currentBackoff = Duration.ofMillis(Math.min(this.currentBackoff.toMillis() * 2L, this.maxBackoff.toMillis()));
    }

    synchronized void decreaseDelay() {
        this.currentBackoff = Duration.ofMillis(Math.max(this.currentBackoff.toMillis() / 2L, this.minBackoff.toMillis()));
    }

    long getRemainingTimeForBackoff() {
        return this.backoffUntil - System.currentTimeMillis();
    }

    ChannelCredentials getChannelCredentials() {
        return TlsChannelCredentials.create();
    }

    synchronized ManagedChannel getChannel() {
        InProcessChannelBuilder channelBuilder;
        ++this.useCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.channel != null) {
            return this.channel;
        }
        if (this.address.isInProcess()) {
            channelBuilder = InProcessChannelBuilder.forName((String)Objects.requireNonNull(this.address.getName()));
        } else if (this.address.isTransportSecurity()) {
            channelBuilder = Grpc.newChannelBuilder((String)this.address.toString(), (ChannelCredentials)this.getChannelCredentials());
            String authority = this.getAuthority();
            if (authority != null) {
                channelBuilder = channelBuilder.overrideAuthority(authority);
            }
        } else {
            channelBuilder = ManagedChannelBuilder.forTarget((String)this.address.toString()).usePlaintext();
        }
        this.channel = channelBuilder.keepAliveTimeout(10L, TimeUnit.SECONDS).userAgent(this.getUserAgent()).executor((Executor)this.executor).build();
        return this.channel;
    }

    boolean channelFailedToConnect() {
        if (this.hasConnected) {
            return false;
        }
        this.hasConnected = this.getChannel().getState(true) == ConnectivityState.READY;
        try {
            for (int i = 0; i < 200 && !this.hasConnected; ++i) {
                TimeUnit.MILLISECONDS.sleep(50L);
                this.hasConnected = this.getChannel().getState(true) == ConnectivityState.READY;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return !this.hasConnected;
    }

    private CompletableFuture<Boolean> channelFailedToConnectAsync(int i, ConnectivityState state) {
        boolean bl = this.hasConnected = state == ConnectivityState.READY;
        if (i >= 200 || this.hasConnected) {
            return CompletableFuture.completedFuture(!this.hasConnected);
        }
        return Delayer.delayFor(50L, this.executor).thenCompose(ignored -> this.channelFailedToConnectAsync(i + 1, this.getChannel().getState(true)));
    }

    CompletableFuture<Boolean> channelFailedToConnectAsync() {
        if (this.hasConnected) {
            return CompletableFuture.completedFuture(false);
        }
        return this.channelFailedToConnectAsync(0, this.getChannel().getState(true));
    }

    synchronized void close(Duration timeout) throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdown();
            this.channel.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS);
            this.channel = null;
        }
    }

    @Override
    public int compareTo(ManagedNode<N, KeyT> node) {
        if (this.isHealthy() && node.isHealthy()) {
            return this.compareToSameHealth(node);
        }
        if (this.isHealthy() && !node.isHealthy()) {
            return -1;
        }
        if (!this.isHealthy() && node.isHealthy()) {
            return 1;
        }
        return this.compareToSameHealth(node);
    }

    private int compareToSameHealth(ManagedNode<N, KeyT> node) {
        if (this.useCount < node.useCount) {
            return -1;
        }
        if (this.useCount > node.useCount) {
            return 1;
        }
        if (this.lastUsed < node.lastUsed) {
            return -1;
        }
        if (this.lastUsed > node.lastUsed) {
            return 1;
        }
        return 0;
    }

    private String getUserAgent() {
        Package thePackage = this.getClass().getPackage();
        String implementationVersion = thePackage != null ? thePackage.getImplementationVersion() : null;
        return "hedera-sdk-java/" + (String)(implementationVersion != null ? "v" + implementationVersion : "DEV");
    }
}

