/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadKeyException;
import com.hedera.hashgraph.sdk.Crypto;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.PublicKeyECDSA;
import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import java.io.IOException;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;

public class PrivateKeyECDSA
extends PrivateKey {
    private final BigInteger keyData;

    PrivateKeyECDSA(BigInteger keyData, @Nullable PublicKey publicKey) {
        this.keyData = keyData;
        this.publicKey = publicKey;
    }

    static PrivateKeyECDSA generateInternal() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(ECDSA_SECP256K1_DOMAIN, ThreadLocalSecureRandom.current());
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters pubParams = (ECPublicKeyParameters)keypair.getPublic();
        return new PrivateKeyECDSA(privParams.getD(), new PublicKeyECDSA(pubParams.getQ().getEncoded(true)));
    }

    static PrivateKeyECDSA fromPrivateKeyInfoInternal(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1OctetString privateKey = (ASN1OctetString)privateKeyInfo.parsePrivateKey();
            return new PrivateKeyECDSA(new BigInteger(1, privateKey.getOctets()), null);
        }
        catch (IOException e) {
            throw new BadKeyException(e);
        }
    }

    public static PrivateKey fromBytesInternal(byte[] privateKey) {
        if (privateKey.length == 32) {
            return new PrivateKeyECDSA(new BigInteger(1, privateKey), null);
        }
        return PrivateKeyECDSA.fromPrivateKeyInfoInternal(PrivateKeyInfo.getInstance((Object)privateKey));
    }

    static byte[] legacyDeriveChildKey(byte[] entropy, long index) {
        throw new IllegalStateException("ECDSA secp256k1 keys do not currently support derivation");
    }

    @Override
    public PrivateKey legacyDerive(long index) {
        throw new IllegalStateException("ECDSA secp256k1 keys do not currently support derivation");
    }

    @Override
    public boolean isDerivable() {
        return false;
    }

    @Override
    public PrivateKey derive(int index) {
        throw new IllegalStateException("ECDSA secp256k1 keys do not currently support derivation");
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        ECPoint q = ECDSA_SECP256K1_DOMAIN.getG().multiply(this.keyData);
        ECPublicKeyParameters publicParams = new ECPublicKeyParameters(q, ECDSA_SECP256K1_DOMAIN);
        this.publicKey = new PublicKeyECDSA(publicParams.getQ().getEncoded(true));
        return this.publicKey;
    }

    @Override
    public byte[] sign(byte[] message) {
        byte[] hash = Crypto.calcKeccak256(message);
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        signer.init(true, (CipherParameters)new ECPrivateKeyParameters(this.keyData, ECDSA_SECP256K1_DOMAIN));
        BigInteger[] bigSig = signer.generateSignature(hash);
        byte[] sigBytes = Arrays.copyOf((byte[])PrivateKeyECDSA.bigIntTo32Bytes(bigSig[0]), (int)64);
        System.arraycopy(PrivateKeyECDSA.bigIntTo32Bytes(bigSig[1]), 0, sigBytes, 32, 32);
        return sigBytes;
    }

    @Override
    public byte[] toBytes() {
        return this.toBytesDER();
    }

    private static byte[] bigIntTo32Bytes(BigInteger n) {
        byte[] bytes = n.toByteArray();
        byte[] bytes32 = new byte[32];
        System.arraycopy(bytes, Math.max(0, bytes.length - 32), bytes32, Math.max(0, 32 - bytes.length), Math.min(32, bytes.length));
        return bytes32;
    }

    @Override
    public byte[] toBytesRaw() {
        return PrivateKeyECDSA.bigIntTo32Bytes(this.keyData);
    }

    @Override
    public byte[] toBytesDER() {
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(ID_ECDSA_SECP256K1), (ASN1Encodable)new DEROctetString(this.toBytesRaw())).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

