/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ScheduleDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<ScheduleDeleteTransaction> {
    @Nullable
    private ScheduleId scheduleId = null;

    public ScheduleDeleteTransaction() {
        this.defaultMaxTransactionFee = new Hbar(5L);
    }

    ScheduleDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    ScheduleDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public ScheduleId getScheduleId() {
        return this.scheduleId;
    }

    public ScheduleDeleteTransaction setScheduleId(ScheduleId scheduleId) {
        Objects.requireNonNull(scheduleId);
        this.requireNotFrozen();
        this.scheduleId = scheduleId;
        return this;
    }

    void initFromTransactionBody() {
        ScheduleDeleteTransactionBody body = this.sourceTransactionBody.getScheduleDelete();
        if (body.hasScheduleID()) {
            this.scheduleId = ScheduleId.fromProtobuf(body.getScheduleID());
        }
    }

    ScheduleDeleteTransactionBody.Builder build() {
        ScheduleDeleteTransactionBody.Builder builder = ScheduleDeleteTransactionBody.newBuilder();
        if (this.scheduleId != null) {
            builder.setScheduleID(this.scheduleId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.scheduleId != null) {
            this.scheduleId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ScheduleServiceGrpc.getDeleteScheduleMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setScheduleDelete(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setScheduleDelete(this.build());
    }
}

