/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ExchangeRate;
import com.hedera.hashgraph.sdk.proto.ExchangeRateSet;
import com.hedera.hashgraph.sdk.proto.TimestampSeconds;
import com.hedera.hashgraph.sdk.proto.TransactionReceipt;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class TransactionReceipt {
    public final Status status;
    public final com.hedera.hashgraph.sdk.ExchangeRate exchangeRate;
    @Nullable
    public final AccountId accountId;
    @Nullable
    public final FileId fileId;
    @Nullable
    public final ContractId contractId;
    @Nullable
    public final TopicId topicId;
    @Nullable
    public final TokenId tokenId;
    @Nullable
    public final Long topicSequenceNumber;
    @Nullable
    public final ByteString topicRunningHash;
    public final Long totalSupply;
    @Nullable
    public final ScheduleId scheduleId;
    @Nullable
    public final TransactionId scheduledTransactionId;
    public final List<Long> serials;
    public final List<TransactionReceipt> duplicates;
    public final List<TransactionReceipt> children;

    private TransactionReceipt(Status status, com.hedera.hashgraph.sdk.ExchangeRate exchangeRate, @Nullable AccountId accountId, @Nullable FileId fileId, @Nullable ContractId contractId, @Nullable TopicId topicId, @Nullable TokenId tokenId, @Nullable Long topicSequenceNumber, @Nullable ByteString topicRunningHash, Long totalSupply, @Nullable ScheduleId scheduleId, @Nullable TransactionId scheduledTransactionId, List<Long> serials, List<TransactionReceipt> duplicates, List<TransactionReceipt> children) {
        this.status = status;
        this.exchangeRate = exchangeRate;
        this.accountId = accountId;
        this.fileId = fileId;
        this.contractId = contractId;
        this.topicId = topicId;
        this.tokenId = tokenId;
        this.topicSequenceNumber = topicSequenceNumber;
        this.topicRunningHash = topicRunningHash;
        this.totalSupply = totalSupply;
        this.scheduleId = scheduleId;
        this.scheduledTransactionId = scheduledTransactionId;
        this.serials = serials;
        this.duplicates = duplicates;
        this.children = children;
    }

    static TransactionReceipt fromProtobuf(com.hedera.hashgraph.sdk.proto.TransactionReceipt transactionReceipt, List<TransactionReceipt> duplicates, List<TransactionReceipt> children) {
        Status status = Status.valueOf(transactionReceipt.getStatus());
        ExchangeRateSet rate = transactionReceipt.getExchangeRate();
        com.hedera.hashgraph.sdk.ExchangeRate exchangeRate = com.hedera.hashgraph.sdk.ExchangeRate.fromProtobuf(rate.getCurrentRate());
        AccountId accountId = transactionReceipt.hasAccountID() ? AccountId.fromProtobuf(transactionReceipt.getAccountID()) : null;
        FileId fileId = transactionReceipt.hasFileID() ? FileId.fromProtobuf(transactionReceipt.getFileID()) : null;
        ContractId contractId = transactionReceipt.hasContractID() ? ContractId.fromProtobuf(transactionReceipt.getContractID()) : null;
        TopicId topicId = transactionReceipt.hasTopicID() ? TopicId.fromProtobuf(transactionReceipt.getTopicID()) : null;
        TokenId tokenId = transactionReceipt.hasTokenID() ? TokenId.fromProtobuf(transactionReceipt.getTokenID()) : null;
        Long topicSequenceNumber = transactionReceipt.getTopicSequenceNumber() == 0L ? null : Long.valueOf(transactionReceipt.getTopicSequenceNumber());
        ByteString topicRunningHash = transactionReceipt.getTopicRunningHash().isEmpty() ? null : transactionReceipt.getTopicRunningHash();
        long totalSupply = transactionReceipt.getNewTotalSupply();
        ScheduleId scheduleId = transactionReceipt.hasScheduleID() ? ScheduleId.fromProtobuf(transactionReceipt.getScheduleID()) : null;
        TransactionId scheduledTransactionId = transactionReceipt.hasScheduledTransactionID() ? TransactionId.fromProtobuf(transactionReceipt.getScheduledTransactionID()) : null;
        List<Long> serials = transactionReceipt.getSerialNumbersList();
        return new TransactionReceipt(status, exchangeRate, accountId, fileId, contractId, topicId, tokenId, topicSequenceNumber, topicRunningHash, totalSupply, scheduleId, scheduledTransactionId, serials, duplicates, children);
    }

    public static TransactionReceipt fromProtobuf(com.hedera.hashgraph.sdk.proto.TransactionReceipt transactionReceipt) {
        return TransactionReceipt.fromProtobuf(transactionReceipt, new ArrayList<TransactionReceipt>(), new ArrayList<TransactionReceipt>());
    }

    public static TransactionReceipt fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TransactionReceipt.fromProtobuf((com.hedera.hashgraph.sdk.proto.TransactionReceipt)((TransactionReceipt.Builder)com.hedera.hashgraph.sdk.proto.TransactionReceipt.parseFrom(bytes).toBuilder()).build());
    }

    com.hedera.hashgraph.sdk.proto.TransactionReceipt toProtobuf() {
        TransactionReceipt.Builder transactionReceiptBuilder = com.hedera.hashgraph.sdk.proto.TransactionReceipt.newBuilder().setStatus(this.status.code).setExchangeRate(ExchangeRateSet.newBuilder().setCurrentRate(ExchangeRate.newBuilder().setHbarEquiv(this.exchangeRate.hbars).setCentEquiv(this.exchangeRate.cents).setExpirationTime(TimestampSeconds.newBuilder().setSeconds(this.exchangeRate.expirationTime.getEpochSecond())))).setNewTotalSupply(this.totalSupply);
        if (this.accountId != null) {
            transactionReceiptBuilder.setAccountID(this.accountId.toProtobuf());
        }
        if (this.fileId != null) {
            transactionReceiptBuilder.setFileID(this.fileId.toProtobuf());
        }
        if (this.contractId != null) {
            transactionReceiptBuilder.setContractID(this.contractId.toProtobuf());
        }
        if (this.topicId != null) {
            transactionReceiptBuilder.setTopicID(this.topicId.toProtobuf());
        }
        if (this.tokenId != null) {
            transactionReceiptBuilder.setTokenID(this.tokenId.toProtobuf());
        }
        if (this.topicSequenceNumber != null) {
            transactionReceiptBuilder.setTopicSequenceNumber(this.topicSequenceNumber);
        }
        if (this.topicRunningHash != null) {
            transactionReceiptBuilder.setTopicRunningHash(this.topicRunningHash);
        }
        if (this.scheduleId != null) {
            transactionReceiptBuilder.setScheduleID(this.scheduleId.toProtobuf());
        }
        if (this.scheduledTransactionId != null) {
            transactionReceiptBuilder.setScheduledTransactionID(this.scheduledTransactionId.toProtobuf());
        }
        for (Long serial : this.serials) {
            transactionReceiptBuilder.addSerialNumbers(serial);
        }
        return (com.hedera.hashgraph.sdk.proto.TransactionReceipt)transactionReceiptBuilder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("exchangeRate", (Object)this.exchangeRate).add("accountId", (Object)this.accountId).add("fileId", (Object)this.fileId).add("contractId", (Object)this.contractId).add("topicId", (Object)this.topicId).add("tokenId", (Object)this.tokenId).add("topicSequenceNumber", (Object)this.topicSequenceNumber).add("topicRunningHash", (Object)this.topicRunningHash).add("totalSupply", (Object)this.totalSupply).add("scheduleId", (Object)this.scheduleId).add("scheduledTransactionId", (Object)this.scheduledTransactionId).add("serials", this.serials).add("duplicates", this.duplicates).add("children", this.children).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

