/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.AssessedCustomFee;
import com.hedera.hashgraph.sdk.ContractFunctionResult;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftTransfer;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.Transfer;
import com.hedera.hashgraph.sdk.proto.AccountAmount;
import com.hedera.hashgraph.sdk.proto.NftTransfer;
import com.hedera.hashgraph.sdk.proto.TokenAssociation;
import com.hedera.hashgraph.sdk.proto.TokenTransferList;
import com.hedera.hashgraph.sdk.proto.TransactionRecord;
import com.hedera.hashgraph.sdk.proto.TransferList;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class TransactionRecord {
    public final TransactionReceipt receipt;
    public final ByteString transactionHash;
    public final Instant consensusTimestamp;
    public final TransactionId transactionId;
    public final String transactionMemo;
    public final Hbar transactionFee;
    @Nullable
    public final ContractFunctionResult contractFunctionResult;
    public final List<Transfer> transfers;
    public final Map<TokenId, Map<AccountId, Long>> tokenTransfers;
    public final Map<TokenId, List<TokenNftTransfer>> tokenNftTransfers;
    @Nullable
    public final ScheduleId scheduleRef;
    public final List<AssessedCustomFee> assessedCustomFees;
    public final List<com.hedera.hashgraph.sdk.TokenAssociation> automaticTokenAssociations;
    @Nullable
    public final PublicKey aliasKey;
    public final List<TransactionRecord> children;
    public final List<TransactionRecord> duplicates;
    @Nullable
    public final Instant parentConsensusTimestamp;

    private TransactionRecord(TransactionReceipt transactionReceipt, ByteString transactionHash, Instant consensusTimestamp, TransactionId transactionId, String transactionMemo, long transactionFee, @Nullable ContractFunctionResult contractFunctionResult, List<Transfer> transfers, Map<TokenId, Map<AccountId, Long>> tokenTransfers, Map<TokenId, List<TokenNftTransfer>> tokenNftTransfers, @Nullable ScheduleId scheduleRef, List<AssessedCustomFee> assessedCustomFees, List<com.hedera.hashgraph.sdk.TokenAssociation> automaticTokenAssociations, @Nullable PublicKey aliasKey, List<TransactionRecord> children, List<TransactionRecord> duplicates, @Nullable Instant parentConsensusTimestamp) {
        this.receipt = transactionReceipt;
        this.transactionHash = transactionHash;
        this.consensusTimestamp = consensusTimestamp;
        this.transactionMemo = transactionMemo;
        this.transactionId = transactionId;
        this.transfers = transfers;
        this.contractFunctionResult = contractFunctionResult;
        this.transactionFee = Hbar.fromTinybars(transactionFee);
        this.tokenTransfers = tokenTransfers;
        this.tokenNftTransfers = tokenNftTransfers;
        this.scheduleRef = scheduleRef;
        this.assessedCustomFees = assessedCustomFees;
        this.automaticTokenAssociations = automaticTokenAssociations;
        this.aliasKey = aliasKey;
        this.children = children;
        this.duplicates = duplicates;
        this.parentConsensusTimestamp = parentConsensusTimestamp;
    }

    static TransactionRecord fromProtobuf(com.hedera.hashgraph.sdk.proto.TransactionRecord transactionRecord, List<TransactionRecord> children, List<TransactionRecord> duplicates) {
        ArrayList<Transfer> transfers = new ArrayList<Transfer>(transactionRecord.getTransferList().getAccountAmountsCount());
        for (AccountAmount accountAmount : transactionRecord.getTransferList().getAccountAmountsList()) {
            transfers.add(Transfer.fromProtobuf(accountAmount));
        }
        HashMap<TokenId, Map<AccountId, Long>> tokenTransfers = new HashMap<TokenId, Map<AccountId, Long>>();
        HashMap<TokenId, List<TokenNftTransfer>> tokenNftTransfers = new HashMap<TokenId, List<TokenNftTransfer>>();
        for (TokenTransferList tokenTransferList : transactionRecord.getTokenTransferListsList()) {
            if (tokenTransferList.getTransfersCount() > 0) {
                HashMap<AccountId, Long> accountAmounts = new HashMap<AccountId, Long>();
                for (AccountAmount accountAmount : tokenTransferList.getTransfersList()) {
                    accountAmounts.put(AccountId.fromProtobuf(accountAmount.getAccountID()), accountAmount.getAmount());
                }
                tokenTransfers.put(TokenId.fromProtobuf(tokenTransferList.getToken()), accountAmounts);
                continue;
            }
            if (tokenTransferList.getNftTransfersCount() <= 0) continue;
            ArrayList<TokenNftTransfer> nftTransfers = new ArrayList<TokenNftTransfer>();
            for (NftTransfer transfer : tokenTransferList.getNftTransfersList()) {
                nftTransfers.add(TokenNftTransfer.fromProtobuf(transfer));
            }
            tokenNftTransfers.put(TokenId.fromProtobuf(tokenTransferList.getToken()), nftTransfers);
        }
        ArrayList<AssessedCustomFee> fees = new ArrayList<AssessedCustomFee>(transactionRecord.getAssessedCustomFeesCount());
        for (com.hedera.hashgraph.sdk.proto.AssessedCustomFee fee : transactionRecord.getAssessedCustomFeesList()) {
            fees.add(AssessedCustomFee.fromProtobuf(fee));
        }
        ContractFunctionResult contractFunctionResult = transactionRecord.hasContractCallResult() ? new ContractFunctionResult(transactionRecord.getContractCallResult()) : (transactionRecord.hasContractCreateResult() ? new ContractFunctionResult(transactionRecord.getContractCreateResult()) : null);
        ArrayList<com.hedera.hashgraph.sdk.TokenAssociation> automaticTokenAssociations = new ArrayList<com.hedera.hashgraph.sdk.TokenAssociation>(transactionRecord.getAutomaticTokenAssociationsCount());
        for (TokenAssociation tokenAssociation : transactionRecord.getAutomaticTokenAssociationsList()) {
            automaticTokenAssociations.add(com.hedera.hashgraph.sdk.TokenAssociation.fromProtobuf(tokenAssociation));
        }
        PublicKey aliasKey = PublicKey.fromAliasBytes(transactionRecord.getAlias());
        return new TransactionRecord(TransactionReceipt.fromProtobuf(transactionRecord.getReceipt()), transactionRecord.getTransactionHash(), InstantConverter.fromProtobuf(transactionRecord.getConsensusTimestamp()), TransactionId.fromProtobuf(transactionRecord.getTransactionID()), transactionRecord.getMemo(), transactionRecord.getTransactionFee(), contractFunctionResult, transfers, tokenTransfers, tokenNftTransfers, transactionRecord.hasScheduleRef() ? ScheduleId.fromProtobuf(transactionRecord.getScheduleRef()) : null, fees, automaticTokenAssociations, aliasKey, children, duplicates, transactionRecord.hasParentConsensusTimestamp() ? InstantConverter.fromProtobuf(transactionRecord.getParentConsensusTimestamp()) : null);
    }

    static TransactionRecord fromProtobuf(com.hedera.hashgraph.sdk.proto.TransactionRecord transactionRecord) {
        return TransactionRecord.fromProtobuf(transactionRecord, new ArrayList<TransactionRecord>(), new ArrayList<TransactionRecord>());
    }

    public static TransactionRecord fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TransactionRecord.fromProtobuf((com.hedera.hashgraph.sdk.proto.TransactionRecord)((TransactionRecord.Builder)com.hedera.hashgraph.sdk.proto.TransactionRecord.parseFrom(bytes).toBuilder()).build());
    }

    com.hedera.hashgraph.sdk.proto.TransactionRecord toProtobuf() {
        TransferList.Builder transferList = TransferList.newBuilder();
        for (Transfer transfer : this.transfers) {
            transferList.addAccountAmounts(transfer.toProtobuf());
        }
        TransactionRecord.Builder transactionRecord = com.hedera.hashgraph.sdk.proto.TransactionRecord.newBuilder().setReceipt(this.receipt.toProtobuf()).setTransactionHash(this.transactionHash).setConsensusTimestamp(InstantConverter.toProtobuf(this.consensusTimestamp)).setTransactionID(this.transactionId.toProtobuf()).setMemo(this.transactionMemo).setTransactionFee(this.transactionFee.toTinybars()).setTransferList(transferList);
        for (Map.Entry<TokenId, Map<AccountId, Long>> tokenEntry : this.tokenTransfers.entrySet()) {
            TokenTransferList.Builder tokenTransfersList = TokenTransferList.newBuilder().setToken(tokenEntry.getKey().toProtobuf());
            for (Map.Entry<AccountId, Long> aaEntry : tokenEntry.getValue().entrySet()) {
                tokenTransfersList.addTransfers((AccountAmount)AccountAmount.newBuilder().setAccountID(aaEntry.getKey().toProtobuf()).setAmount(aaEntry.getValue()).build());
            }
            transactionRecord.addTokenTransferLists(tokenTransfersList);
        }
        if (this.contractFunctionResult != null) {
            transactionRecord.setContractCallResult(this.contractFunctionResult.toProtobuf());
        }
        if (this.scheduleRef != null) {
            transactionRecord.setScheduleRef(this.scheduleRef.toProtobuf());
        }
        for (AssessedCustomFee fee : this.assessedCustomFees) {
            transactionRecord.addAssessedCustomFees(fee.toProtobuf());
        }
        for (com.hedera.hashgraph.sdk.TokenAssociation tokenAssociation : this.automaticTokenAssociations) {
            transactionRecord.addAutomaticTokenAssociations(tokenAssociation.toProtobuf());
        }
        if (this.aliasKey != null) {
            transactionRecord.setAlias(this.aliasKey.toProtobufKey().toByteString());
        }
        if (this.parentConsensusTimestamp != null) {
            transactionRecord.setParentConsensusTimestamp(InstantConverter.toProtobuf(this.parentConsensusTimestamp));
        }
        return (com.hedera.hashgraph.sdk.proto.TransactionRecord)transactionRecord.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("receipt", (Object)this.receipt).add("transactionHash", (Object)Hex.toHexString((byte[])this.transactionHash.toByteArray())).add("consensusTimestamp", (Object)this.consensusTimestamp).add("transactionId", (Object)this.transactionId).add("transactionMemo", (Object)this.transactionMemo).add("transactionFee", (Object)this.transactionFee).add("contractFunctionResult", (Object)this.contractFunctionResult).add("transfers", this.transfers).add("tokenTransfers", this.tokenTransfers).add("tokenNftTransfers", this.tokenNftTransfers).add("scheduleRef", (Object)this.scheduleRef).add("assessedCustomFees", this.assessedCustomFees).add("automaticTokenAssociations", this.automaticTokenAssociations).add("aliasKey", (Object)this.aliasKey).add("children", this.children).add("duplicates", this.duplicates).add("parentConsensusTimestamp", (Object)this.parentConsensusTimestamp).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

