/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONLexer;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class JsonTools {
    public static final String INDENT = "  ";

    public static String toJsonFieldName(String fieldName) {
        int length = fieldName.length();
        StringBuilder result = new StringBuilder(length);
        boolean isNextUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char ch = fieldName.charAt(i);
            if (ch == '_') {
                isNextUpperCase = true;
                continue;
            }
            if (isNextUpperCase) {
                if ('a' <= ch && ch <= 'z') {
                    ch = (char)(ch - 97 + 65);
                }
                result.append(ch);
                isNextUpperCase = false;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String unescape(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r");
    }

    public static String escape(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
    }

    public static JSONParser.ObjContext parseJson(@NonNull ReadableSequentialData input) throws IOException {
        JSONLexer lexer = new JSONLexer(CharStreams.fromStream((InputStream)input.asInputStream()));
        JSONParser parser = new JSONParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        JSONParser.JsonContext jsonContext = parser.json();
        JSONParser.ValueContext valueContext = jsonContext.value();
        return valueContext.obj();
    }

    public static JSONParser.ObjContext parseJson(@NonNull CharBuffer input) {
        CodePointBuffer.Builder codePointBufferBuilder = CodePointBuffer.builder((int)input.remaining());
        codePointBufferBuilder.append(input);
        JSONLexer lexer = new JSONLexer((CharStream)CodePointCharStream.fromBuffer((CodePointBuffer)codePointBufferBuilder.build(), (String)"CharBuffer"));
        JSONParser parser = new JSONParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        JSONParser.JsonContext jsonContext = parser.json();
        JSONParser.ValueContext valueContext = jsonContext.value();
        return valueContext.obj();
    }

    public static <T> List<T> parseObjArray(JSONParser.ArrContext arrContext, JsonCodec<T> codec) {
        return arrContext.value().stream().map(v -> {
            try {
                return codec.parse(v.obj(), false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).toList();
    }

    public static int parseInteger(JSONParser.ValueContext valueContext) {
        return Integer.parseInt(valueContext.STRING() != null ? valueContext.STRING().getText() : valueContext.NUMBER().getText());
    }

    public static long parseLong(JSONParser.ValueContext valueContext) {
        return Long.parseLong(valueContext.STRING() != null ? valueContext.STRING().getText() : valueContext.NUMBER().getText());
    }

    public static float parseFloat(JSONParser.ValueContext valueContext) {
        return Float.parseFloat(valueContext.STRING() != null ? valueContext.STRING().getText() : valueContext.NUMBER().getText());
    }

    public static double parseDouble(JSONParser.ValueContext valueContext) {
        return Double.parseDouble(valueContext.STRING() != null ? valueContext.STRING().getText() : valueContext.NUMBER().getText());
    }

    public static boolean parseBoolean(JSONParser.ValueContext valueContext) {
        return Boolean.parseBoolean(valueContext.getText());
    }

    private static String rawFieldCode(String fieldName, String rawValue) {
        return "\"" + fieldName + "\": " + rawValue;
    }

    public static <T> String field(String indent, String fieldName, JsonCodec<T> codec, @Nullable T value) {
        if (value != null) {
            return "\"" + JsonTools.toJsonFieldName(fieldName) + "\": " + codec.toJSON(value, indent, true);
        }
        return "\"" + JsonTools.toJsonFieldName(fieldName) + "\": null";
    }

    public static String field(String fieldName, String value) {
        return JsonTools.rawFieldCode(fieldName, "\"" + JsonTools.escape(value) + "\"");
    }

    public static String field(String fieldName, Bytes value) {
        return JsonTools.rawFieldCode(fieldName, "\"" + value.toBase64() + "\"");
    }

    public static String field(String fieldName, byte[] value) {
        return JsonTools.rawFieldCode(fieldName, "\"" + Base64.getEncoder().encodeToString(value) + "\"");
    }

    public static String field(String fieldName, boolean value) {
        return JsonTools.rawFieldCode(fieldName, value ? "true" : "false");
    }

    public static String field(String fieldName, int value) {
        return JsonTools.rawFieldCode(fieldName, Integer.toString(value));
    }

    public static String field(String fieldName, long value) {
        return JsonTools.rawFieldCode(fieldName, "\"" + Long.toString(value) + "\"");
    }

    public static String field(String fieldName, float value) {
        if (Float.isNaN(value)) {
            return JsonTools.rawFieldCode(fieldName, "\"NaN\"");
        }
        if (Float.isInfinite(value)) {
            return JsonTools.rawFieldCode(fieldName, "\"" + (value < 0.0f ? "-Infinity" : "Infinity") + "\"");
        }
        return JsonTools.rawFieldCode(fieldName, Float.toString(value));
    }

    public static String field(String fieldName, double value) {
        if (Double.isNaN(value)) {
            return JsonTools.rawFieldCode(fieldName, "\"NaN\"");
        }
        if (Double.isInfinite(value)) {
            return JsonTools.rawFieldCode(fieldName, "\"" + (value < 0.0 ? "-Infinity" : "Infinity") + "\"");
        }
        return JsonTools.rawFieldCode(fieldName, Double.toString(value));
    }

    public static String field(String fieldName, Boolean value) {
        if (value == null) {
            return JsonTools.rawFieldCode(fieldName, "null");
        }
        return JsonTools.rawFieldCode(fieldName, Boolean.toString(value));
    }

    public static String field(String fieldName, Integer value) {
        if (value == null) {
            return JsonTools.rawFieldCode(fieldName, "null");
        }
        return JsonTools.rawFieldCode(fieldName, Integer.toString(value));
    }

    public static String field(String fieldName, Long value, boolean quote) {
        if (value == null) {
            return JsonTools.rawFieldCode(fieldName, "null");
        }
        if (quote) {
            return JsonTools.rawFieldCode(fieldName, "\"" + Long.toString(value) + "\"");
        }
        return JsonTools.rawFieldCode(fieldName, Long.toString(value));
    }

    public static String field(String fieldName, Float value) {
        if (value == null) {
            return JsonTools.rawFieldCode(fieldName, "null");
        }
        return JsonTools.field(fieldName, value.floatValue());
    }

    public static String field(String fieldName, Double value) {
        if (value == null) {
            return JsonTools.rawFieldCode(fieldName, "null");
        }
        return JsonTools.field(fieldName, (double)value);
    }

    public static <T> String arrayField(String fieldName, FieldDefinition fieldDefinition, List<T> items) {
        if (items != null) {
            if (items.isEmpty()) {
                return JsonTools.rawFieldCode(fieldName, "[]");
            }
            String values = items.stream().map(item -> {
                if (fieldDefinition.optional() && item == null) {
                    return "\"null\"";
                }
                return switch (fieldDefinition.type()) {
                    default -> throw new IncompatibleClassChangeError();
                    case FieldType.STRING -> "\"" + JsonTools.escape((String)item) + "\"";
                    case FieldType.BYTES -> "\"" + ((Bytes)item).toBase64() + "\"";
                    case FieldType.INT32, FieldType.SINT32, FieldType.UINT32, FieldType.FIXED32, FieldType.SFIXED32 -> Integer.toString((Integer)item);
                    case FieldType.INT64, FieldType.SINT64, FieldType.UINT64, FieldType.FIXED64, FieldType.SFIXED64 -> "\"" + Long.toString((Long)item) + "\"";
                    case FieldType.FLOAT -> Float.toString(((Float)item).floatValue());
                    case FieldType.DOUBLE -> Double.toString((Double)item);
                    case FieldType.BOOL -> Boolean.toString((Boolean)item);
                    case FieldType.ENUM -> "\"" + ((EnumWithProtoMetadata)item).protoName() + "\"";
                    case FieldType.MESSAGE -> throw new UnsupportedOperationException("No expected here should have called other arrayField() method");
                };
            }).collect(Collectors.joining(", "));
            return JsonTools.rawFieldCode(fieldName, "[" + values + "]");
        }
        return null;
    }

    public static <T> String arrayField(String indent, String fieldName, JsonCodec<T> codec, List<T> items) {
        if (items != null) {
            if (items.isEmpty()) {
                return JsonTools.rawFieldCode(fieldName, "[]");
            }
            StringBuilder code = new StringBuilder("\"" + fieldName + "\": [");
            for (int i = 0; i < items.size(); ++i) {
                T item = items.get(i);
                code.append(codec.toJSON(item, indent, true));
                if (i >= items.size() - 1) continue;
                code.append(", ");
            }
            code.append("]");
            return code.toString();
        }
        return null;
    }
}

