/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProtoTestTools {
    private static final int BUFFER_SIZE = 0x100000;
    private static final int CHAR_BUFFER_SIZE = 0x100000;
    private static final ThreadLocal<BufferedData> THREAD_LOCAL_BUFFERS = ThreadLocal.withInitial(() -> BufferedData.allocate(0x100000));
    private static final ThreadLocal<BufferedData> THREAD_LOCAL_BUFFERS_2 = ThreadLocal.withInitial(() -> BufferedData.allocate(0x100000));
    private static final ThreadLocal<ByteBuffer> THREAD_LOCAL_BYTE_BUFFERS = ThreadLocal.withInitial(() -> ByteBuffer.allocate(0x100000));
    private static final ThreadLocal<CharBuffer> THREAD_LOCAL_CHAR_BUFFERS = ThreadLocal.withInitial(() -> CharBuffer.allocate(0x100000));
    private static final ThreadLocal<CharBuffer> THREAD_LOCAL_CHAR_BUFFERS_2 = ThreadLocal.withInitial(() -> CharBuffer.allocate(0x100000));
    public static final List<Integer> INTEGER_TESTS_LIST = List.of(Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(-42), Integer.valueOf(-21), Integer.valueOf(0), Integer.valueOf(21), Integer.valueOf(42), Integer.valueOf(Integer.MAX_VALUE));
    public static final List<Integer> UNSIGNED_INTEGER_TESTS_LIST = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(Integer.MAX_VALUE));
    public static final List<Long> LONG_TESTS_LIST = List.of(Long.valueOf(Long.MIN_VALUE), Long.valueOf(-42L), Long.valueOf(-21L), Long.valueOf(0L), Long.valueOf(21L), Long.valueOf(42L), Long.valueOf(Long.MAX_VALUE));
    public static final List<Long> UNSIGNED_LONG_TESTS_LIST = List.of(Long.valueOf(0L), Long.valueOf(21L), Long.valueOf(42L), Long.valueOf(Long.MAX_VALUE));
    public static final List<Float> FLOAT_TESTS_LIST = List.of(Float.valueOf(Float.MIN_NORMAL), Float.valueOf(-102.7f), Float.valueOf(-5.0f), Float.valueOf(1.7f), Float.valueOf(0.0f), Float.valueOf(3.0f), Float.valueOf(5.2f), Float.valueOf(42.1f), Float.valueOf(Float.MAX_VALUE));
    public static final List<Double> DOUBLE_TESTS_LIST = List.of(Double.valueOf(Double.MIN_NORMAL), Double.valueOf(-102.7), Double.valueOf(-5.0), Double.valueOf(1.7), Double.valueOf(0.0), Double.valueOf(3.0), Double.valueOf(5.2), Double.valueOf(42.1), Double.valueOf(Double.MAX_VALUE));
    public static final List<Boolean> BOOLEAN_TESTS_LIST = List.of(Boolean.valueOf(true), Boolean.valueOf(false));
    public static final List<Bytes> BYTES_TESTS_LIST = List.of(Bytes.wrap(new byte[0]), Bytes.wrap(new byte[]{1}), Bytes.wrap(new byte[]{1, 2, 3, -1, -128, 127}));
    public static final List<String> STRING_TESTS_LIST = List.of("", "This a small to speed tests\nCouple extended chars \u00a9\u00ab \u3042\u3081 \u0628\u0650\u0647\u0627\n");

    private ProtoTestTools() {
    }

    public static BufferedData getThreadLocalDataBuffer() {
        BufferedData local = THREAD_LOCAL_BUFFERS.get();
        local.reset();
        return local;
    }

    public static BufferedData getThreadLocalDataBuffer2() {
        BufferedData local = THREAD_LOCAL_BUFFERS_2.get();
        local.reset();
        return local;
    }

    public static ByteBuffer getThreadLocalByteBuffer() {
        ByteBuffer local = THREAD_LOCAL_BYTE_BUFFERS.get();
        local.clear();
        return local;
    }

    public static CharBuffer getThreadLocalCharBuffer() {
        CharBuffer local = THREAD_LOCAL_CHAR_BUFFERS.get();
        local.clear();
        return local;
    }

    public static CharBuffer getThreadLocalCharBuffer2() {
        CharBuffer local = THREAD_LOCAL_CHAR_BUFFERS_2.get();
        local.clear();
        return local;
    }

    public static <T> List<T> addNull(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list.size() + 1);
        newList.add(null);
        newList.addAll(list);
        return newList;
    }

    public static <T> List<List<T>> generateListArguments(List<T> list) {
        int itemsToUse;
        ArrayList<List<T>> outputList = new ArrayList<List<T>>(list.size() / 5 + 1);
        outputList.add(Collections.emptyList());
        for (int i = 0; i < list.size(); i += itemsToUse) {
            itemsToUse = Math.min(5, list.size() - i);
            outputList.add(list.subList(i, i + itemsToUse));
        }
        return outputList;
    }
}

