/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.DataAccessException;
import com.hedera.pbj.runtime.io.DataEncodingException;
import com.hedera.pbj.runtime.io.UnsafeUtils;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

final class ByteArrayBufferedData
extends BufferedData {
    private final byte[] array;
    private final int arrayOffset;

    ByteArrayBufferedData(ByteBuffer buffer) {
        super(buffer);
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException("Cannot create a ByteArrayBufferedData over a buffer with no array");
        }
        this.array = buffer.array();
        this.arrayOffset = buffer.arrayOffset();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        for (int i = 0; i < this.buffer.limit(); ++i) {
            int v = this.array[this.arrayOffset + i] & 0xFF;
            sb.append(v);
            if (i >= this.buffer.limit() - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean contains(long offset, @NonNull byte[] bytes) {
        if (offset < 0L || offset >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int len = bytes.length;
        if (this.length() - offset < (long)len) {
            return false;
        }
        int fromThisIndex = Math.toIntExact((long)this.arrayOffset + offset);
        int fromToIndex = fromThisIndex + len;
        return Arrays.equals(this.array, fromThisIndex, fromToIndex, bytes, 0, len);
    }

    @Override
    public byte getByte(long offset) {
        this.validateCanRead(offset, 0L);
        return this.array[Math.toIntExact((long)this.arrayOffset + offset)];
    }

    @Override
    public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        this.validateLen(maxLength);
        long len = Math.min((long)maxLength, this.length() - offset);
        this.validateCanRead(offset, len);
        if (len == 0L) {
            return 0L;
        }
        System.arraycopy(this.array, Math.toIntExact((long)this.arrayOffset + offset), dst, dstOffset, Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull ByteBuffer dst) {
        if (!dst.hasArray()) {
            return super.getBytes(offset, dst);
        }
        long len = Math.min(this.length() - offset, (long)dst.remaining());
        byte[] dstArr = dst.array();
        int dstPos = dst.position();
        int dstArrOffset = dst.arrayOffset();
        System.arraycopy(this.array, Math.toIntExact((long)this.arrayOffset + offset), dstArr, dstArrOffset + dstPos, Math.toIntExact(len));
        return len;
    }

    @Override
    @NonNull
    public Bytes getBytes(long offset, long len) {
        this.validateLen(len);
        if (len == 0L) {
            return Bytes.EMPTY;
        }
        if (this.length() - offset < len) {
            throw new BufferUnderflowException();
        }
        byte[] res = new byte[Math.toIntExact(len)];
        System.arraycopy(this.array, Math.toIntExact((long)this.arrayOffset + offset), res, 0, res.length);
        return Bytes.wrap(res);
    }

    @Override
    public int getVarInt(long offset, boolean zigZag) {
        return (int)this.getVar(Math.toIntExact(offset), zigZag);
    }

    @Override
    public long getVarLong(long offset, boolean zigZag) {
        return this.getVar(Math.toIntExact(offset), zigZag);
    }

    private long getVar(int offset, boolean zigZag) {
        int i;
        if (offset < 0 || offset >= this.buffer.limit()) {
            throw new IndexOutOfBoundsException();
        }
        int readOffset = this.arrayOffset + offset;
        int rem = this.buffer.limit() - offset;
        if (rem > 10) {
            rem = 10;
        }
        long value = 0L;
        for (i = 0; i != rem; ++i) {
            byte b = UnsafeUtils.getArrayByteNoChecks(this.array, readOffset + i);
            value |= (long)(b & 0x7F) << i * 7;
            if (b < 0) continue;
            return zigZag ? value >>> 1 ^ -(value & 1L) : value;
        }
        throw i == 10 ? new DataEncodingException("Malformed var int") : new BufferUnderflowException();
    }

    @Override
    public byte readByte() {
        if (this.remaining() == 0L) {
            throw new BufferUnderflowException();
        }
        int pos = this.buffer.position();
        byte res = this.array[this.arrayOffset + pos];
        this.buffer.position(pos + 1);
        return res;
    }

    @Override
    public long readBytes(@NonNull byte[] dst, int offset, int maxLength) {
        this.validateLen(maxLength);
        int len = Math.toIntExact(Math.min((long)maxLength, this.remaining()));
        if (len == 0) {
            return 0L;
        }
        int pos = this.buffer.position();
        System.arraycopy(this.array, this.arrayOffset + pos, dst, offset, len);
        this.buffer.position(pos + len);
        return len;
    }

    @Override
    public long readBytes(@NonNull ByteBuffer dst) {
        if (!dst.hasArray()) {
            return super.readBytes(dst);
        }
        long len = Math.min(this.remaining(), (long)dst.remaining());
        int pos = this.buffer.position();
        byte[] dstArr = dst.array();
        int dstPos = dst.position();
        int dstArrOffset = dst.arrayOffset();
        System.arraycopy(this.array, this.arrayOffset + pos, dstArr, dstArrOffset + dstPos, Math.toIntExact(len));
        this.buffer.position(Math.toIntExact((long)pos + len));
        dst.position(Math.toIntExact((long)dstPos + len));
        return len;
    }

    @Override
    @NonNull
    public Bytes readBytes(int len) {
        this.validateLen(len);
        int pos = this.buffer.position();
        this.validateCanRead(pos, len);
        if (len == 0) {
            return Bytes.EMPTY;
        }
        byte[] res = new byte[len];
        System.arraycopy(this.array, this.arrayOffset + pos, res, 0, len);
        this.buffer.position(pos + len);
        return Bytes.wrap(res);
    }

    @Override
    public int readVarInt(boolean zigZag) {
        return (int)this.readVar(zigZag);
    }

    @Override
    public long readVarLong(boolean zigZag) {
        return this.readVar(zigZag);
    }

    private long readVar(boolean zigZag) {
        int i;
        int pos = this.buffer.position();
        int offset = this.arrayOffset + pos;
        int rem = this.buffer.remaining();
        if (rem > 10) {
            rem = 10;
        }
        long value = 0L;
        for (i = 0; i != rem; ++i) {
            byte b = UnsafeUtils.getArrayByteNoChecks(this.array, offset + i);
            value |= (long)(b & 0x7F) << i * 7;
            if (b < 0) continue;
            this.buffer.position(pos + i);
            return zigZag ? value >>> 1 ^ -(value & 1L) : value;
        }
        throw i == 10 ? new DataEncodingException("Malformed var int") : new BufferUnderflowException();
    }

    @Override
    public void writeByte(byte b) {
        this.validateCanWrite(1L);
        int pos = this.buffer.position();
        this.array[this.arrayOffset + pos] = b;
        this.buffer.position(pos + 1);
    }

    @Override
    public void writeBytes(@NonNull byte[] src, int offset, int len) {
        this.validateLen(len);
        this.validateCanWrite(len);
        int pos = this.buffer.position();
        System.arraycopy(src, offset, this.array, this.arrayOffset + pos, len);
        this.buffer.position(pos + len);
    }

    @Override
    public void writeBytes(@NonNull ByteBuffer src) {
        if (!src.hasArray()) {
            super.writeBytes(src);
            return;
        }
        long len = src.remaining();
        this.validateCanWrite(len);
        int pos = this.buffer.position();
        byte[] srcArr = src.array();
        int srcArrOffset = src.arrayOffset();
        int srcPos = src.position();
        System.arraycopy(srcArr, srcArrOffset + srcPos, this.array, this.arrayOffset + pos, Math.toIntExact(len));
        src.position(Math.toIntExact((long)srcPos + len));
        this.buffer.position(Math.toIntExact((long)pos + len));
    }

    @Override
    public int writeBytes(@NonNull InputStream src, int maxLength) {
        Objects.requireNonNull(src);
        if (maxLength < 0) {
            throw new IllegalArgumentException("The length must be >= 0");
        }
        if (maxLength == 0) {
            return 0;
        }
        long numBytesToRead = Math.min((long)maxLength, this.remaining());
        if (numBytesToRead == 0L) {
            return 0;
        }
        try {
            int pos = this.buffer.position();
            int totalBytesRead = 0;
            while ((long)totalBytesRead < numBytesToRead) {
                int bytesRead = src.read(this.array, pos + this.arrayOffset, (int)numBytesToRead - totalBytesRead);
                if (bytesRead == -1) {
                    this.buffer.position(pos);
                    return totalBytesRead;
                }
                pos += bytesRead;
                totalBytesRead += bytesRead;
            }
            this.buffer.position(pos);
            return totalBytesRead;
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
    }
}

